/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.screencast;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import sun.awt.OSInfo;
import sun.awt.UNIXToolkit;
import sun.awt.screencast.TokenItem;
import sun.awt.screencast.TokenStorage;
import sun.security.action.GetPropertyAction;

public class ScreencastHelper {
    static final boolean SCREENCAST_DEBUG;
    private static final boolean IS_NATIVE_LOADED;
    private static final int ERROR = -1;
    private static final int DENIED = -11;
    private static final int OUT_OF_BOUNDS = -12;
    private static final int DELAY_BEFORE_SESSION_CLOSE = 2000;
    private static volatile TimerTask timerTask;
    private static final Timer timerCloseSession;

    private ScreencastHelper() {
    }

    public static boolean isAvailable() {
        return IS_NATIVE_LOADED;
    }

    private static native boolean loadPipewire(boolean var0);

    private static native int getRGBPixelsImpl(int var0, int var1, int var2, int var3, int[] var4, int[] var5, String var6);

    private static List<Rectangle> getSystemScreensBounds() {
        return Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).map(graphicsDevice -> graphicsDevice.getDefaultConfiguration().getBounds()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private static synchronized native void closeSession();

    private static void timerCloseSessionRestart() {
        if (timerTask != null) {
            timerTask.cancel();
        }
        timerTask = new TimerTask(){

            @Override
            public void run() {
                ScreencastHelper.closeSession();
            }
        };
        timerCloseSession.schedule(timerTask, 2000L);
    }

    public static synchronized void getRGBPixels(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        if (!IS_NATIVE_LOADED) {
            return;
        }
        ScreencastHelper.timerCloseSessionRestart();
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        List list = ScreencastHelper.getSystemScreensBounds().stream().filter(rectangle2::intersects).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        if (SCREENCAST_DEBUG) {
            System.out.printf("// getRGBPixels in %s, affectedScreenBounds %s\n", rectangle2, list);
        }
        if (list.isEmpty()) {
            if (SCREENCAST_DEBUG) {
                System.out.println("// getRGBPixels - requested area outside of any screen");
            }
            return;
        }
        Set<TokenItem> set = TokenStorage.getTokens(list);
        int[] nArray2 = list.stream().filter(rectangle2::intersects).flatMapToInt(rectangle -> IntStream.of(rectangle.x, rectangle.y, rectangle.width, rectangle.height)).toArray();
        for (TokenItem tokenItem : set) {
            n5 = ScreencastHelper.getRGBPixelsImpl(n, n2, n3, n4, nArray, nArray2, tokenItem.token);
            if (n5 >= 0) {
                return;
            }
            if (ScreencastHelper.checkReturnValue(n5)) continue;
            return;
        }
        n5 = ScreencastHelper.getRGBPixelsImpl(n, n2, n3, n4, nArray, nArray2, null);
        ScreencastHelper.checkReturnValue(n5);
    }

    private static boolean checkReturnValue(int n) {
        if (n == -11) {
            throw new SecurityException("Screen Capture in the selected area was not allowed");
        }
        if (n == -1) {
            if (SCREENCAST_DEBUG) {
                System.err.println("Screen capture failed.");
            }
        } else if (n == -12 && SCREENCAST_DEBUG) {
            System.err.println("Token does not provide access to requested area.");
        }
        return n != -1;
    }

    static {
        timerTask = null;
        timerCloseSession = new Timer("auto-close screencast session", true);
        if (AccessController.doPrivileged(() -> OSInfo.getOSType()) == OSInfo.OSType.SOLARIS) {
            SCREENCAST_DEBUG = false;
            IS_NATIVE_LOADED = false;
        } else {
            SCREENCAST_DEBUG = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("awt.robot.screenshotDebug", "false")));
            boolean bl = false;
            if (!(Toolkit.getDefaultToolkit() instanceof UNIXToolkit && ((UNIXToolkit)Toolkit.getDefaultToolkit()).loadGTK() && ScreencastHelper.loadPipewire(SCREENCAST_DEBUG))) {
                System.err.println("Could not load native libraries for ScreencastHelper");
                bl = true;
            }
            IS_NATIVE_LOADED = !bl;
        }
    }
}

