/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class DefaultFileSystemProvider {
    private static FileSystemProvider INSTANCE = DefaultFileSystemProvider.create();

    private DefaultFileSystemProvider() {
    }

    private static FileSystemProvider createProvider(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        try {
            return (FileSystemProvider)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    static FileSystemProvider create() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string.equals("SunOS")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.SolarisFileSystemProvider");
        }
        if (string.equals("Linux")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.LinuxFileSystemProvider");
        }
        if (string.contains("OS X")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.MacOSXFileSystemProvider");
        }
        if (string.equals("AIX")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.AixFileSystemProvider");
        }
        throw new AssertionError((Object)"Platform not recognized");
    }

    public static FileSystemProvider instance() {
        return INSTANCE;
    }
}

