/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import java.io.IOException;
import java.net.Proxy;
import java.net.SecureCacheResponse;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.https.HttpsClient;

public abstract class AbstractDelegateHttpsURLConnection
extends HttpURLConnection {
    protected AbstractDelegateHttpsURLConnection(URL uRL, Handler handler) throws IOException {
        this(uRL, null, handler);
    }

    protected AbstractDelegateHttpsURLConnection(URL uRL, Proxy proxy, Handler handler) throws IOException {
        super(uRL, proxy, handler);
    }

    protected abstract SSLSocketFactory getSSLSocketFactory();

    protected abstract HostnameVerifier getHostnameVerifier();

    @Override
    public void setNewClient(URL uRL) throws IOException {
        this.setNewClient(uRL, false);
    }

    @Override
    public void setNewClient(URL uRL, boolean bl) throws IOException {
        int n = this.getReadTimeout();
        this.http = HttpsClient.New(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), null, -1, bl, this.getConnectTimeout(), this);
        this.http.setReadTimeout(n);
        ((HttpsClient)this.http).afterConnect();
    }

    @Override
    public void setProxiedClient(URL uRL, String string, int n) throws IOException {
        this.setProxiedClient(uRL, string, n, false);
    }

    @Override
    public void setProxiedClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxiedConnect(uRL, string, n, bl);
        if (!this.http.isCachedConnection()) {
            this.doTunneling();
        }
        ((HttpsClient)this.http).afterConnect();
    }

    @Override
    protected void proxiedConnect(URL uRL, String string, int n, boolean bl) throws IOException {
        if (this.connected) {
            return;
        }
        int n2 = this.getReadTimeout();
        this.http = HttpsClient.New(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), string, n, bl, this.getConnectTimeout(), this);
        this.http.setReadTimeout(n2);
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.plainConnect();
        if (this.cachedResponse != null) {
            return;
        }
        if (!this.http.isCachedConnection() && this.http.needsTunneling()) {
            this.doTunneling();
        }
        ((HttpsClient)this.http).afterConnect();
    }

    @Override
    protected HttpClient getNewHttpClient(URL uRL, Proxy proxy, int n) throws IOException {
        return HttpsClient.New(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), proxy, true, n, (HttpURLConnection)this);
    }

    @Override
    protected HttpClient getNewHttpClient(URL uRL, Proxy proxy, int n, boolean bl) throws IOException {
        return HttpsClient.New(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), proxy, bl, n, (HttpURLConnection)this);
    }

    public String getCipherSuite() {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getCipherSuite();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        if (this.cachedResponse != null) {
            List<Certificate> list = ((SecureCacheResponse)this.cachedResponse).getLocalCertificateChain();
            if (list == null) {
                return null;
            }
            return list.toArray(new Certificate[0]);
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            List<Certificate> list = ((SecureCacheResponse)this.cachedResponse).getServerCertificateChain();
            if (list == null) {
                return null;
            }
            return list.toArray(new Certificate[0]);
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getServerCertificates();
    }

    public javax.security.cert.X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            throw new UnsupportedOperationException("this method is not supported when using cache");
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getServerCertificateChain();
    }

    Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getPeerPrincipal();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getPeerPrincipal();
    }

    Principal getLocalPrincipal() {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getLocalPrincipal();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getLocalPrincipal();
    }

    private boolean useExtendedCallerInfo(URL uRL) {
        HttpsClient httpsClient = (HttpsClient)this.http;
        if (httpsClient.getSSLSession() == null) {
            return false;
        }
        String string = this.http.getSpnegoCBT();
        if (string.equals("never")) {
            return false;
        }
        String string2 = uRL.getHost();
        if (string.startsWith("domain:")) {
            String[] stringArray;
            for (String string3 : stringArray = string.substring(7).split(",")) {
                if (string2.equalsIgnoreCase(string3)) {
                    return true;
                }
                if (!string3.startsWith("*.") || !string2.regionMatches(true, string2.length() - string3.length() + 1, string3, 1, string3.length() - 1)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected HttpCallerInfo getHttpCallerInfo(URL uRL, String string, int n) {
        if (!this.useExtendedCallerInfo(uRL)) {
            return super.getHttpCallerInfo(uRL, string, n);
        }
        HttpsClient httpsClient = (HttpsClient)this.http;
        try {
            Certificate[] certificateArray = httpsClient.getServerCertificates();
            if (certificateArray[0] instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                return new HttpCallerInfo(uRL, string, n, x509Certificate);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        return super.getHttpCallerInfo(uRL, string, n);
    }

    @Override
    protected HttpCallerInfo getHttpCallerInfo(URL uRL) {
        if (!this.useExtendedCallerInfo(uRL)) {
            return super.getHttpCallerInfo(uRL);
        }
        HttpsClient httpsClient = (HttpsClient)this.http;
        try {
            Certificate[] certificateArray = httpsClient.getServerCertificates();
            if (certificateArray[0] instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                return new HttpCallerInfo(uRL, x509Certificate);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        return super.getHttpCallerInfo(uRL);
    }
}

