/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv2;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.internal.platform.CgroupSubsystem;
import jdk.internal.platform.CgroupSubsystemController;
import jdk.internal.platform.CgroupUtil;
import jdk.internal.platform.cgroupv2.CgroupV2SubsystemController;

public class CgroupV2Subsystem
implements CgroupSubsystem {
    private static final CgroupV2Subsystem INSTANCE = CgroupV2Subsystem.initSubsystem();
    private static final long[] LONG_ARRAY_NOT_SUPPORTED = null;
    private static final int[] INT_ARRAY_UNAVAILABLE = null;
    private final CgroupSubsystemController unified;
    private static final String PROVIDER_NAME = "cgroupv2";
    private static final int PER_CPU_SHARES = 1024;
    private static final String MAX_VAL = "max";
    private static final Object EMPTY_STR = "";
    private static final long NO_SWAP = 0L;

    private CgroupV2Subsystem(CgroupSubsystemController cgroupSubsystemController) {
        this.unified = cgroupSubsystemController;
    }

    private long getLongVal(String string, long l) {
        return CgroupSubsystemController.getLongValue(this.unified, string, CgroupV2SubsystemController::convertStringToLong, l);
    }

    private long getLongVal(String string) {
        return this.getLongVal(string, -1L);
    }

    private static CgroupV2Subsystem initSubsystem() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = null;
        try {
            object4 = CgroupUtil.readFilePrivileged(Paths.get("/proc/self/mountinfo", new String[0]));
            object3 = null;
            try {
                object2 = object4.filter(string -> string.contains(" - cgroup2 ")).collect(Collectors.joining());
                object = ((String)object2).split(" ");
                string2 = object[4];
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object4 != null) {
                    if (object3 != null) {
                        try {
                            object4.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        object4.close();
                    }
                }
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        object4 = null;
        try {
            object3 = CgroupUtil.readAllLinesPrivileged(Paths.get("/proc/self/cgroup", new String[0]));
            object2 = object3.iterator();
            if (object2.hasNext()) {
                object = (String)object2.next();
                String[] stringArray = ((String)object).split(":");
                if (stringArray.length != 3) {
                    return null;
                }
                if (!"0".equals(stringArray[0])) {
                    return null;
                }
                object4 = stringArray[2];
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        object3 = new CgroupV2SubsystemController(string2, (String)object4);
        return new CgroupV2Subsystem((CgroupSubsystemController)object3);
    }

    public static CgroupSubsystem getInstance() {
        return INSTANCE;
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        long l = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "usage_usec");
        if (l < 0L) {
            return l;
        }
        return TimeUnit.MICROSECONDS.toNanos(l);
    }

    @Override
    public long[] getPerCpuUsage() {
        return LONG_ARRAY_NOT_SUPPORTED;
    }

    @Override
    public long getCpuUserUsage() {
        long l = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "user_usec");
        if (l < 0L) {
            return l;
        }
        return TimeUnit.MICROSECONDS.toNanos(l);
    }

    @Override
    public long getCpuSystemUsage() {
        long l = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "system_usec");
        if (l < 0L) {
            return l;
        }
        return TimeUnit.MICROSECONDS.toNanos(l);
    }

    @Override
    public long getCpuPeriod() {
        return this.getFromCpuMax(1);
    }

    @Override
    public long getCpuQuota() {
        return this.getFromCpuMax(0);
    }

    private long getFromCpuMax(int n) {
        String string = CgroupSubsystemController.getStringValue(this.unified, "cpu.max");
        if (string == null) {
            return -1L;
        }
        String[] stringArray = string.split("\\s+");
        if (stringArray.length != 2) {
            return -1L;
        }
        String string2 = stringArray[n];
        return this.limitFromString(string2);
    }

    private long limitFromString(String string) {
        if (string == null || MAX_VAL.equals(string)) {
            return -1L;
        }
        return Long.parseLong(string);
    }

    @Override
    public long getCpuShares() {
        int n;
        long l = this.getLongVal("cpu.weight");
        if (l == 100L || l <= 0L) {
            return -1L;
        }
        int n2 = (int)l;
        int n3 = 262142 * n2 - 1;
        double d = (double)n3 / 9999.0;
        if ((n3 = (int)d + 2) <= 1024) {
            return 1024L;
        }
        int n4 = n3 / 1024;
        int n5 = n4 * 1024;
        int n6 = (n4 + 1) * 1024;
        int n7 = Math.max(n5, n3) - Math.min(n5, n3);
        n3 = n7 <= (n = Math.max(n6, n3) - Math.min(n6, n3)) ? n5 : n6;
        return n3;
    }

    @Override
    public long getCpuNumPeriods() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        long l = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "throttled_usec");
        if (l < 0L) {
            return l;
        }
        return TimeUnit.MICROSECONDS.toNanos(l);
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        String string = CgroupSubsystemController.getStringValue(this.unified, "cpuset.cpus");
        return this.getCpuSet(string);
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        String string = CgroupSubsystemController.getStringValue(this.unified, "cpuset.cpus.effective");
        return this.getCpuSet(string);
    }

    @Override
    public int[] getCpuSetMems() {
        String string = CgroupSubsystemController.getStringValue(this.unified, "cpuset.mems");
        return this.getCpuSet(string);
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        String string = CgroupSubsystemController.getStringValue(this.unified, "cpuset.mems.effective");
        return this.getCpuSet(string);
    }

    private int[] getCpuSet(String string) {
        if (string == null || EMPTY_STR.equals(string)) {
            return INT_ARRAY_UNAVAILABLE;
        }
        return CgroupSubsystemController.stringRangeToIntArray(string);
    }

    @Override
    public long getMemoryFailCount() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "memory.events", MAX_VAL);
    }

    @Override
    public long getMemoryLimit() {
        String string = CgroupSubsystemController.getStringValue(this.unified, "memory.max");
        return this.limitFromString(string);
    }

    @Override
    public long getMemoryUsage() {
        return this.getLongVal("memory.current");
    }

    @Override
    public long getTcpMemoryUsage() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "memory.stat", "sock");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        String string = CgroupSubsystemController.getStringValue(this.unified, "memory.swap.max");
        if (string == null) {
            return this.getMemoryLimit();
        }
        long l = this.limitFromString(string);
        if (l >= 0L) {
            long l2 = this.getMemoryLimit();
            assert (l2 >= 0L);
            return l2 + l;
        }
        return l;
    }

    @Override
    public long getMemoryAndSwapUsage() {
        long l = this.getMemoryUsage();
        if (l >= 0L) {
            long l2 = this.getLongVal("memory.swap.current", 0L);
            return l + l2;
        }
        return l;
    }

    @Override
    public long getMemorySoftLimit() {
        String string = CgroupSubsystemController.getStringValue(this.unified, "memory.low");
        return this.limitFromString(string);
    }

    @Override
    public long getBlkIOServiceCount() {
        return this.sumTokensIOStat(CgroupV2Subsystem::lineToRandWIOs);
    }

    @Override
    public long getBlkIOServiced() {
        return this.sumTokensIOStat(CgroupV2Subsystem::lineToRBytesAndWBytesIO);
    }

    private long sumTokensIOStat(Function<String, Long> function) {
        try {
            return CgroupUtil.readFilePrivileged(Paths.get(this.unified.path(), "io.stat")).map(function).collect(Collectors.summingLong(l -> l));
        }
        catch (UncheckedIOException uncheckedIOException) {
            return -1L;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private static String[] getRWIOMatchTokenNames() {
        return new String[]{"rios", "wios"};
    }

    private static String[] getRWBytesIOMatchTokenNames() {
        return new String[]{"rbytes", "wbytes"};
    }

    public static Long lineToRandWIOs(String string) {
        String[] stringArray = CgroupV2Subsystem.getRWIOMatchTokenNames();
        return CgroupV2Subsystem.ioStatLineToLong(string, stringArray);
    }

    public static Long lineToRBytesAndWBytesIO(String string) {
        String[] stringArray = CgroupV2Subsystem.getRWBytesIOMatchTokenNames();
        return CgroupV2Subsystem.ioStatLineToLong(string, stringArray);
    }

    private static Long ioStatLineToLong(String string, String[] stringArray) {
        if (string == null || EMPTY_STR.equals(string)) {
            return 0L;
        }
        String[] stringArray2 = string.split("\\s+");
        long l = 0L;
        for (String string2 : stringArray2) {
            String[] stringArray3 = string2.split("=");
            if (stringArray3.length != 2) continue;
            for (String string3 : stringArray) {
                if (!string3.equals(stringArray3[0])) continue;
                l += CgroupV2Subsystem.longOrZero(stringArray3[1]);
            }
        }
        return l;
    }

    private static long longOrZero(String string) {
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }
}

