/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv1;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import jdk.internal.platform.CgroupSubsystem;
import jdk.internal.platform.CgroupSubsystemController;
import jdk.internal.platform.CgroupUtil;
import jdk.internal.platform.CgroupV1Metrics;
import jdk.internal.platform.cgroupv1.CgroupV1MemorySubSystemController;
import jdk.internal.platform.cgroupv1.CgroupV1SubsystemController;

public class CgroupV1Subsystem
implements CgroupSubsystem,
CgroupV1Metrics {
    private CgroupV1MemorySubSystemController memory;
    private CgroupV1SubsystemController cpu;
    private CgroupV1SubsystemController cpuacct;
    private CgroupV1SubsystemController cpuset;
    private CgroupV1SubsystemController blkio;
    private boolean activeSubSystems = false;
    private static final CgroupV1Subsystem INSTANCE = CgroupV1Subsystem.initSubSystem();
    private static final String PROVIDER_NAME = "cgroupv1";

    private CgroupV1Subsystem() {
    }

    public static CgroupV1Subsystem getInstance() {
        return INSTANCE;
    }

    private static CgroupV1Subsystem initSubSystem() {
        Throwable throwable;
        Stream<String> stream;
        CgroupV1Subsystem cgroupV1Subsystem = new CgroupV1Subsystem();
        try {
            stream = CgroupUtil.readFilePrivileged(Paths.get("/proc/self/mountinfo", new String[0]));
            throwable = null;
            try {
                stream.filter(string -> string.contains(" - cgroup ")).map(string -> string.split(" ")).forEach(stringArray -> CgroupV1Subsystem.createSubSystemController(cgroupV1Subsystem, stringArray));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            stream = CgroupUtil.readFilePrivileged(Paths.get("/proc/self/cgroup", new String[0]));
            throwable = null;
            try {
                stream.map(string -> string.split(":", 3)).filter(stringArray -> ((String[])stringArray).length >= 3).forEach(stringArray -> CgroupV1Subsystem.setSubSystemControllerPath(cgroupV1Subsystem, stringArray));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (cgroupV1Subsystem.activeSubSystems()) {
            return cgroupV1Subsystem;
        }
        return null;
    }

    private static void createSubSystemController(CgroupV1Subsystem cgroupV1Subsystem, String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length < 5) {
            return;
        }
        Path path = Paths.get(stringArray[4], new String[0]);
        String[] stringArray3 = stringArray2 = path.getFileName().toString().split(",");
        int n = stringArray3.length;
        block14: for (int i = 0; i < n; ++i) {
            String string;
            switch (string = stringArray3[i]) {
                case "memory": {
                    cgroupV1Subsystem.setMemorySubSystem(new CgroupV1MemorySubSystemController(stringArray[3], stringArray[4]));
                    continue block14;
                }
                case "cpuset": {
                    cgroupV1Subsystem.setCpuSetController(new CgroupV1SubsystemController(stringArray[3], stringArray[4]));
                    continue block14;
                }
                case "cpuacct": {
                    cgroupV1Subsystem.setCpuAcctController(new CgroupV1SubsystemController(stringArray[3], stringArray[4]));
                    continue block14;
                }
                case "cpu": {
                    cgroupV1Subsystem.setCpuController(new CgroupV1SubsystemController(stringArray[3], stringArray[4]));
                    continue block14;
                }
                case "blkio": {
                    cgroupV1Subsystem.setBlkIOController(new CgroupV1SubsystemController(stringArray[3], stringArray[4]));
                    continue block14;
                }
            }
        }
    }

    private static void setSubSystemControllerPath(CgroupV1Subsystem cgroupV1Subsystem, String[] stringArray) {
        String string = stringArray[1];
        String string2 = stringArray[2];
        if (string != null && string2 != null) {
            String[] stringArray2 = string.split(",");
            int n = stringArray2.length;
            block14: for (int i = 0; i < n; ++i) {
                String string3;
                switch (string3 = stringArray2[i]) {
                    case "memory": {
                        CgroupV1Subsystem.setPath(cgroupV1Subsystem, cgroupV1Subsystem.memoryController(), string2);
                        continue block14;
                    }
                    case "cpuset": {
                        CgroupV1Subsystem.setPath(cgroupV1Subsystem, cgroupV1Subsystem.cpuSetController(), string2);
                        continue block14;
                    }
                    case "cpuacct": {
                        CgroupV1Subsystem.setPath(cgroupV1Subsystem, cgroupV1Subsystem.cpuController(), string2);
                        continue block14;
                    }
                    case "cpu": {
                        CgroupV1Subsystem.setPath(cgroupV1Subsystem, cgroupV1Subsystem.cpuAcctController(), string2);
                        continue block14;
                    }
                    case "blkio": {
                        CgroupV1Subsystem.setPath(cgroupV1Subsystem, cgroupV1Subsystem.blkIOController(), string2);
                        continue block14;
                    }
                }
            }
        }
    }

    private static void setPath(CgroupV1Subsystem cgroupV1Subsystem, CgroupV1SubsystemController cgroupV1SubsystemController, String string) {
        if (cgroupV1SubsystemController != null) {
            cgroupV1SubsystemController.setPath(string);
            if (cgroupV1SubsystemController instanceof CgroupV1MemorySubSystemController) {
                CgroupV1MemorySubSystemController cgroupV1MemorySubSystemController = (CgroupV1MemorySubSystemController)cgroupV1SubsystemController;
                boolean bl = CgroupV1Subsystem.getHierarchical(cgroupV1MemorySubSystemController);
                cgroupV1MemorySubSystemController.setHierarchical(bl);
                boolean bl2 = CgroupV1Subsystem.getSwapEnabled(cgroupV1MemorySubSystemController);
                cgroupV1MemorySubSystemController.setSwapEnabled(bl2);
            }
            cgroupV1Subsystem.setActiveSubSystems();
        }
    }

    private static boolean getSwapEnabled(CgroupV1MemorySubSystemController cgroupV1MemorySubSystemController) {
        long l = CgroupV1Subsystem.getLongValue(cgroupV1MemorySubSystemController, "memory.memsw.limit_in_bytes");
        return l > 0L;
    }

    private static boolean getHierarchical(CgroupV1MemorySubSystemController cgroupV1MemorySubSystemController) {
        long l = CgroupV1Subsystem.getLongValue(cgroupV1MemorySubSystemController, "memory.use_hierarchy");
        return l > 0L;
    }

    private void setActiveSubSystems() {
        this.activeSubSystems = true;
    }

    private boolean activeSubSystems() {
        return this.activeSubSystems;
    }

    private void setMemorySubSystem(CgroupV1MemorySubSystemController cgroupV1MemorySubSystemController) {
        this.memory = cgroupV1MemorySubSystemController;
    }

    private void setCpuController(CgroupV1SubsystemController cgroupV1SubsystemController) {
        this.cpu = cgroupV1SubsystemController;
    }

    private void setCpuAcctController(CgroupV1SubsystemController cgroupV1SubsystemController) {
        this.cpuacct = cgroupV1SubsystemController;
    }

    private void setCpuSetController(CgroupV1SubsystemController cgroupV1SubsystemController) {
        this.cpuset = cgroupV1SubsystemController;
    }

    private void setBlkIOController(CgroupV1SubsystemController cgroupV1SubsystemController) {
        this.blkio = cgroupV1SubsystemController;
    }

    private CgroupV1SubsystemController memoryController() {
        return this.memory;
    }

    private CgroupV1SubsystemController cpuController() {
        return this.cpu;
    }

    private CgroupV1SubsystemController cpuAcctController() {
        return this.cpuacct;
    }

    private CgroupV1SubsystemController cpuSetController() {
        return this.cpuset;
    }

    private CgroupV1SubsystemController blkIOController() {
        return this.blkio;
    }

    private static long getLongValue(CgroupSubsystemController cgroupSubsystemController, String string) {
        return CgroupSubsystemController.getLongValue(cgroupSubsystemController, string, CgroupV1SubsystemController::convertStringToLong, -1L);
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        return CgroupV1Subsystem.getLongValue(this.cpuacct, "cpuacct.usage");
    }

    @Override
    public long[] getPerCpuUsage() {
        String string = CgroupSubsystemController.getStringValue(this.cpuacct, "cpuacct.usage_percpu");
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(" ");
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = Long.parseLong(stringArray[i]);
        }
        return lArray;
    }

    @Override
    public long getCpuUserUsage() {
        return CgroupV1SubsystemController.getLongEntry(this.cpuacct, "cpuacct.stat", "user");
    }

    @Override
    public long getCpuSystemUsage() {
        return CgroupV1SubsystemController.getLongEntry(this.cpuacct, "cpuacct.stat", "system");
    }

    @Override
    public long getCpuPeriod() {
        return CgroupV1Subsystem.getLongValue(this.cpu, "cpu.cfs_period_us");
    }

    @Override
    public long getCpuQuota() {
        return CgroupV1Subsystem.getLongValue(this.cpu, "cpu.cfs_quota_us");
    }

    @Override
    public long getCpuShares() {
        long l = CgroupV1Subsystem.getLongValue(this.cpu, "cpu.shares");
        if (l == 0L || l == 1024L) {
            return -1L;
        }
        return l;
    }

    @Override
    public long getCpuNumPeriods() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "throttled_time");
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.cpus"));
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.effective_cpus"));
    }

    @Override
    public int[] getCpuSetMems() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.mems"));
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.effective_mems"));
    }

    @Override
    public double getCpuSetMemoryPressure() {
        return CgroupV1SubsystemController.getDoubleValue(this.cpuset, "cpuset.memory_pressure");
    }

    @Override
    public Boolean isCpuSetMemoryPressureEnabled() {
        long l = CgroupV1Subsystem.getLongValue(this.cpuset, "cpuset.memory_pressure_enabled");
        return l == 1L;
    }

    @Override
    public long getMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.failcnt");
    }

    @Override
    public long getMemoryLimit() {
        long l = CgroupV1Subsystem.getLongValue(this.memory, "memory.limit_in_bytes");
        if (l > CgroupV1SubsystemController.UNLIMITED_MIN && this.memory.isHierarchical()) {
            String string = "hierarchical_memory_limit";
            l = CgroupV1SubsystemController.getLongValueMatchingLine(this.memory, "memory.stat", string);
        }
        return CgroupV1SubsystemController.longValOrUnlimited(l);
    }

    @Override
    public long getMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.max_usage_in_bytes");
    }

    @Override
    public long getMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.usage_in_bytes");
    }

    @Override
    public long getKernelMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.failcnt");
    }

    @Override
    public long getKernelMemoryLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.limit_in_bytes"));
    }

    @Override
    public long getKernelMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.max_usage_in_bytes");
    }

    @Override
    public long getKernelMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.usage_in_bytes");
    }

    @Override
    public long getTcpMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.failcnt");
    }

    @Override
    public long getTcpMemoryLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.limit_in_bytes"));
    }

    @Override
    public long getTcpMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.max_usage_in_bytes");
    }

    @Override
    public long getTcpMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapFailCount() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryFailCount();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.failcnt");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryLimit();
        }
        long l = CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.limit_in_bytes");
        if (l > CgroupV1SubsystemController.UNLIMITED_MIN && this.memory.isHierarchical()) {
            String string = "hierarchical_memsw_limit";
            l = CgroupV1SubsystemController.getLongValueMatchingLine(this.memory, "memory.stat", string);
        }
        return CgroupV1SubsystemController.longValOrUnlimited(l);
    }

    @Override
    public long getMemoryAndSwapMaxUsage() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryMaxUsage();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.max_usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapUsage() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryUsage();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.usage_in_bytes");
    }

    @Override
    public Boolean isMemoryOOMKillEnabled() {
        long l = CgroupV1SubsystemController.getLongEntry(this.memory, "memory.oom_control", "oom_kill_disable");
        return l == 0L;
    }

    @Override
    public long getMemorySoftLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.soft_limit_in_bytes"));
    }

    @Override
    public long getBlkIOServiceCount() {
        return CgroupV1SubsystemController.getLongEntry(this.blkio, "blkio.throttle.io_service_bytes", "Total");
    }

    @Override
    public long getBlkIOServiced() {
        return CgroupV1SubsystemController.getLongEntry(this.blkio, "blkio.throttle.io_serviced", "Total");
    }

    private static native boolean isUseContainerSupport();
}

