/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTypeTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.AnnotationEntryGen;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.CodeExceptionGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.FieldGenOrMethodGen;
import com.sun.org.apache.bcel.internal.generic.IINC;
import com.sun.org.apache.bcel.internal.generic.IfInstruction;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.LineNumberGen;
import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MethodObserver;
import com.sun.org.apache.bcel.internal.generic.NOP;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.TargetLostException;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

public class MethodGen
extends FieldGenOrMethodGen {
    private String className;
    private Type[] argTypes;
    private String[] argNames;
    private int maxLocals;
    private int maxStack;
    private InstructionList il;
    private boolean stripAttributes;
    private LocalVariableTypeTable localVariableTypeTable = null;
    private final List<LocalVariableGen> variableList = new ArrayList<LocalVariableGen>();
    private final List<LineNumberGen> lineNumberList = new ArrayList<LineNumberGen>();
    private final List<CodeExceptionGen> exceptionList = new ArrayList<CodeExceptionGen>();
    private final List<String> throwsList = new ArrayList<String>();
    private final List<Attribute> codeAttrsList = new ArrayList<Attribute>();
    private List<AnnotationEntryGen>[] paramAnnotations;
    private boolean hasParameterAnnotations = false;
    private boolean haveUnpackedParameterAnnotations = false;
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            MethodGen THIS = (MethodGen)o1;
            MethodGen THAT = (MethodGen)o2;
            return Objects.equals(THIS.getName(), THAT.getName()) && Objects.equals(THIS.getSignature(), THAT.getSignature());
        }

        @Override
        public int hashCode(Object o) {
            MethodGen THIS = (MethodGen)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private List<MethodObserver> observers;

    public MethodGen(int access_flags, Type return_type, Type[] argTypes, String[] argNames, String method_name, String className, InstructionList il, ConstantPoolGen cp) {
        super(access_flags);
        this.setType(return_type);
        this.setArgumentTypes(argTypes);
        this.setArgumentNames(argNames);
        this.setName(method_name);
        this.setClassName(className);
        this.setInstructionList(il);
        this.setConstantPool(cp);
        boolean abstract_ = this.isAbstract() || this.isNative();
        InstructionHandle start = null;
        InstructionHandle end = null;
        if (!abstract_) {
            start = il.getStart();
            if (!this.isStatic() && className != null) {
                this.addLocalVariable("this", ObjectType.getInstance(className), start, end);
            }
        }
        if (argTypes != null) {
            int size = argTypes.length;
            for (Type arg_type : argTypes) {
                if (Type.VOID != arg_type) continue;
                throw new ClassGenException("'void' is an illegal argument type for a method");
            }
            if (argNames != null) {
                if (size != argNames.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + argNames.length);
                }
            } else {
                argNames = new String[size];
                for (int i = 0; i < size; ++i) {
                    argNames[i] = "arg" + i;
                }
                this.setArgumentNames(argNames);
            }
            if (!abstract_) {
                for (int i = 0; i < size; ++i) {
                    this.addLocalVariable(argNames[i], argTypes[i], start, end);
                }
            }
        }
    }

    public MethodGen(Method method, String className, ConstantPoolGen cp) {
        this(method.getAccessFlags(), Type.getReturnType(method.getSignature()), Type.getArgumentTypes(method.getSignature()), null, method.getName(), className, (method.getAccessFlags() & 0x500) == 0 ? new InstructionList(MethodGen.getByteCodes(method)) : null, cp);
        Attribute[] attributes;
        for (Attribute attribute : attributes = method.getAttributes()) {
            Attribute a = attribute;
            if (a instanceof Code) {
                Attribute[] c_attributes;
                Code c = (Code)a;
                this.setMaxStack(c.getMaxStack());
                this.setMaxLocals(c.getMaxLocals());
                Object[] ces = c.getExceptionTable();
                if (ces != null) {
                    for (Object ce : ces) {
                        InstructionHandle end;
                        int type = ((CodeException)ce).getCatchType();
                        ObjectType c_type = null;
                        if (type > 0) {
                            String cen = method.getConstantPool().getConstantString(type, (byte)7);
                            c_type = ObjectType.getInstance(cen);
                        }
                        int end_pc = ((CodeException)ce).getEndPC();
                        int length = MethodGen.getByteCodes(method).length;
                        if (length == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(((CodeException)ce).getStartPC()), end, this.il.findHandle(((CodeException)ce).getHandlerPC()), c_type);
                    }
                }
                Attribute[] attributeArray = c_attributes = c.getAttributes();
                int n = attributeArray.length;
                for (int ce = 0; ce < n; ++ce) {
                    Attribute c_attribute = attributeArray[ce];
                    a = c_attribute;
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln;
                        for (LineNumber l : ln = ((LineNumberTable)a).getLineNumberTable()) {
                            InstructionHandle ih = this.il.findHandle(l.getStartPC());
                            if (ih == null) continue;
                            this.addLineNumber(ih, l.getLineNumber());
                        }
                        continue;
                    }
                    if (a instanceof LocalVariableTable) {
                        this.updateLocalVariableTable((LocalVariableTable)a);
                        continue;
                    }
                    if (a instanceof LocalVariableTypeTable) {
                        this.localVariableTypeTable = (LocalVariableTypeTable)a.copy(cp.getConstantPool());
                        continue;
                    }
                    this.addCodeAttribute(a);
                }
                continue;
            }
            if (a instanceof ExceptionTable) {
                String[] names = ((ExceptionTable)a).getExceptionNames();
                for (String name2 : names) {
                    this.addException(name2);
                }
                continue;
            }
            if (a instanceof Annotations) {
                AnnotationEntry[] aes;
                Annotations runtimeAnnotations = (Annotations)a;
                for (AnnotationEntry element : aes = runtimeAnnotations.getAnnotationEntries()) {
                    this.addAnnotationEntry(new AnnotationEntryGen(element, cp, false));
                }
                continue;
            }
            this.addAttribute(a);
        }
    }

    private static byte[] getByteCodes(Method method) {
        Code code = method.getCode();
        if (code == null) {
            throw new IllegalStateException(String.format("The method '%s' has no code.", method));
        }
        return code.getCode();
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end, int orig_index) {
        byte t = type.getType();
        if (t != 16) {
            LocalVariableGen l;
            int i;
            int add = type.getSize();
            if (slot + add > this.maxLocals) {
                this.maxLocals = slot + add;
            }
            if ((i = this.variableList.indexOf(l = new LocalVariableGen(slot, name, type, start, end, orig_index))) >= 0) {
                this.variableList.set(i, l);
            } else {
                this.variableList.add(l);
            }
            return l;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, slot, start, end, slot);
    }

    public LocalVariableGen addLocalVariable(String name, Type type, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, this.maxLocals, start, end);
    }

    public void removeLocalVariable(LocalVariableGen l) {
        this.variableList.remove(l);
    }

    public void removeLocalVariables() {
        this.variableList.clear();
    }

    public LocalVariableGen[] getLocalVariables() {
        int size = this.variableList.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.variableList.toArray(lg);
        for (int i = 0; i < size; ++i) {
            if (lg[i].getStart() == null && this.il != null) {
                lg[i].setStart(this.il.getStart());
            }
            if (lg[i].getEnd() != null || this.il == null) continue;
            lg[i].setEnd(this.il.getEnd());
        }
        if (size > 1) {
            Arrays.sort(lg, new Comparator<LocalVariableGen>(){

                @Override
                public int compare(LocalVariableGen o1, LocalVariableGen o2) {
                    return o1.getIndex() - o2.getIndex();
                }
            });
        }
        return lg;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        for (int i = 0; i < size; ++i) {
            lv[i] = lg[i].getLocalVariable(cp);
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public LocalVariableTypeTable getLocalVariableTypeTable() {
        return this.localVariableTypeTable;
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int srcLine) {
        LineNumberGen l = new LineNumberGen(ih, srcLine);
        this.lineNumberList.add(l);
        return l;
    }

    public void removeLineNumber(LineNumberGen l) {
        this.lineNumberList.remove(l);
    }

    public void removeLineNumbers() {
        this.lineNumberList.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.lineNumberList.size()];
        this.lineNumberList.toArray(lg);
        return lg;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen cp) {
        int size = this.lineNumberList.size();
        LineNumber[] ln = new LineNumber[size];
        for (int i = 0; i < size; ++i) {
            ln[i] = this.lineNumberList.get(i).getLineNumber();
        }
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exceptionList.add(c);
        return c;
    }

    public void removeExceptionHandler(CodeExceptionGen c) {
        this.exceptionList.remove(c);
    }

    public void removeExceptionHandlers() {
        this.exceptionList.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exceptionList.size()];
        this.exceptionList.toArray(cg);
        return cg;
    }

    private CodeException[] getCodeExceptions() {
        int size = this.exceptionList.size();
        CodeException[] c_exc = new CodeException[size];
        for (int i = 0; i < size; ++i) {
            CodeExceptionGen c = this.exceptionList.get(i);
            c_exc[i] = c.getCodeException(super.getConstantPool());
        }
        return c_exc;
    }

    public void addException(String className) {
        this.throwsList.add(className);
    }

    public void removeException(String c) {
        this.throwsList.remove(c);
    }

    public void removeExceptions() {
        this.throwsList.clear();
    }

    public String[] getExceptions() {
        return this.throwsList.toArray(new String[0]);
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen cp) {
        int size = this.throwsList.size();
        int[] ex = new int[size];
        for (int i = 0; i < size; ++i) {
            ex[i] = cp.addClass(this.throwsList.get(i));
        }
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public void addCodeAttribute(Attribute a) {
        this.codeAttrsList.add(a);
    }

    public void removeLocalVariableTypeTable() {
        this.localVariableTypeTable = null;
    }

    public void removeCodeAttribute(Attribute a) {
        this.codeAttrsList.remove(a);
    }

    public void removeCodeAttributes() {
        this.localVariableTypeTable = null;
        this.codeAttrsList.clear();
    }

    public Attribute[] getCodeAttributes() {
        return this.codeAttrsList.toArray(new Attribute[0]);
    }

    public void addAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs;
        for (Attribute attr : attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries())) {
            this.addAttribute(attr);
        }
    }

    public void addParameterAnnotationsAsAttribute(ConstantPoolGen cp) {
        if (!this.hasParameterAnnotations) {
            return;
        }
        Attribute[] attrs = AnnotationEntryGen.getParameterAnnotationAttributes(cp, this.paramAnnotations);
        if (attrs != null) {
            for (Attribute attr : attrs) {
                this.addAttribute(attr);
            }
        }
    }

    private Attribute[] addRuntimeAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs;
        for (Attribute attr : attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries())) {
            this.addAttribute(attr);
        }
        return attrs;
    }

    private Attribute[] addRuntimeParameterAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs;
        if (!this.hasParameterAnnotations) {
            return new Attribute[0];
        }
        for (Attribute attr : attrs = AnnotationEntryGen.getParameterAnnotationAttributes(cp, this.paramAnnotations)) {
            this.addAttribute(attr);
        }
        return attrs;
    }

    public void removeRuntimeAttributes(Attribute[] attrs) {
        for (Attribute attr : attrs) {
            this.removeAttribute(attr);
        }
    }

    public Method getMethod() {
        String signature = this.getSignature();
        ConstantPoolGen _cp = super.getConstantPool();
        int name_index = _cp.addUtf8(super.getName());
        int signature_index = _cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.variableList.size() > 0 && !this.stripAttributes) {
            this.updateLocalVariableTable(this.getLocalVariableTable(_cp));
            lvt = this.getLocalVariableTable(_cp);
            this.addCodeAttribute(lvt);
        }
        if (this.localVariableTypeTable != null) {
            if (lvt != null) {
                this.adjustLocalVariableTypeTable(lvt);
            }
            this.addCodeAttribute(this.localVariableTypeTable);
        }
        if (this.lineNumberList.size() > 0 && !this.stripAttributes) {
            lnt = this.getLineNumberTable(_cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        for (Attribute code_attr : code_attrs) {
            attrs_len += code_attr.getLength() + 6;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract() && !this.isNative()) {
            Attribute[] attributes;
            for (Attribute a : attributes = this.getAttributes()) {
                if (!(a instanceof Code)) continue;
                this.removeAttribute(a);
            }
            code = new Code(_cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.maxStack, this.maxLocals, byte_code, c_exc, code_attrs, _cp.getConstantPool());
            this.addAttribute(code);
        }
        Attribute[] annotations = this.addRuntimeAnnotationsAsAttribute(_cp);
        Attribute[] parameterAnnotations = this.addRuntimeParameterAnnotationsAsAttribute(_cp);
        ExceptionTable et = null;
        if (this.throwsList.size() > 0) {
            et = this.getExceptionTable(_cp);
            this.addAttribute(et);
        }
        Method m = new Method(super.getAccessFlags(), name_index, signature_index, this.getAttributes(), _cp.getConstantPool());
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (this.localVariableTypeTable != null) {
            this.removeCodeAttribute(this.localVariableTypeTable);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        this.removeRuntimeAttributes(annotations);
        this.removeRuntimeAttributes(parameterAnnotations);
        return m;
    }

    private void updateLocalVariableTable(LocalVariableTable a) {
        LocalVariable[] lv = a.getLocalVariableTable();
        this.removeLocalVariables();
        for (LocalVariable l : lv) {
            InstructionHandle start = this.il.findHandle(l.getStartPC());
            InstructionHandle end = this.il.findHandle(l.getStartPC() + l.getLength());
            if (null == start) {
                start = this.il.getStart();
            }
            this.addLocalVariable(l.getName(), Type.getType(l.getSignature()), l.getIndex(), start, end, l.getOrigIndex());
        }
    }

    private void adjustLocalVariableTypeTable(LocalVariableTable lvt) {
        LocalVariable[] lvg;
        LocalVariable[] lv = lvt.getLocalVariableTable();
        block0: for (LocalVariable element : lvg = this.localVariableTypeTable.getLocalVariableTypeTable()) {
            for (LocalVariable l : lv) {
                if (!element.getName().equals(l.getName()) || element.getIndex() != l.getOrigIndex()) continue;
                element.setLength(l.getLength());
                element.setStartPC(l.getStartPC());
                element.setIndex(l.getIndex());
                continue block0;
            }
        }
    }

    public void removeNOPs() {
        if (this.il != null) {
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                InstructionHandle next = ih.getNext();
                if (next != null && ih.getInstruction() instanceof NOP) {
                    try {
                        this.il.delete(ih);
                    }
                    catch (TargetLostException e) {
                        for (InstructionHandle target : e.getTargets()) {
                            for (InstructionTargeter targeter : target.getTargeters()) {
                                targeter.updateTarget(target, next);
                            }
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setMaxLocals(int m) {
        this.maxLocals = m;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxStack(int m) {
        this.maxStack = m;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String class_name) {
        this.className = class_name;
    }

    public void setReturnType(Type return_type) {
        this.setType(return_type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] arg_types) {
        this.argTypes = arg_types;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.argTypes.clone();
    }

    public void setArgumentType(int i, Type type) {
        this.argTypes[i] = type;
    }

    public Type getArgumentType(int i) {
        return this.argTypes[i];
    }

    public void setArgumentNames(String[] arg_names) {
        this.argNames = arg_names;
    }

    public String[] getArgumentNames() {
        return (String[])this.argNames.clone();
    }

    public void setArgumentName(int i, String name) {
        this.argNames[i] = name;
    }

    public String getArgumentName(int i) {
        return this.argNames[i];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList il) {
        this.il = il;
    }

    @Override
    public String getSignature() {
        return Type.getMethodSignature(super.getType(), this.argTypes);
    }

    public void setMaxStack() {
        this.maxStack = this.il != null ? MethodGen.getMaxStack(super.getConstantPool(), this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max;
            int n = max = this.isStatic() ? 0 : 1;
            if (this.argTypes != null) {
                for (Type arg_type : this.argTypes) {
                    max += arg_type.getSize();
                }
            }
            for (InstructionHandle ih = this.il.getStart(); ih != null; ih = ih.getNext()) {
                int index;
                Instruction ins = ih.getInstruction();
                if (!(ins instanceof LocalVariableInstruction) && !(ins instanceof RET) && !(ins instanceof IINC) || (index = ((IndexedInstruction)((Object)ins)).getIndex() + ((TypedInstruction)((Object)ins)).getType(super.getConstantPool()).getSize()) <= max) continue;
                max = index;
            }
            this.maxLocals = max;
        } else {
            this.maxLocals = 0;
        }
    }

    public void stripAttributes(boolean flag) {
        this.stripAttributes = flag;
    }

    public static int getMaxStack(ConstantPoolGen cp, InstructionList il, CodeExceptionGen[] et) {
        BranchStack branchTargets = new BranchStack();
        for (CodeExceptionGen element : et) {
            InstructionHandle handler_pc = element.getHandlerPC();
            if (handler_pc == null) continue;
            branchTargets.push(handler_pc, 1);
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            Instruction instruction = ih.getInstruction();
            short opcode = instruction.getOpcode();
            int delta = instruction.produceStack(cp) - instruction.consumeStack(cp);
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    InstructionHandle[] targets;
                    Select select = (Select)branch;
                    for (InstructionHandle target : targets = select.getTargets()) {
                        branchTargets.push(target, stackDepth);
                    }
                    ih = null;
                } else if (!(branch instanceof IfInstruction)) {
                    if (opcode == 168 || opcode == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public void addObserver(MethodObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<MethodObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(MethodObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (MethodObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    public final String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        String signature = Type.getMethodSignature(super.getType(), this.argTypes);
        signature = Utility.methodSignatureToString(signature, super.getName(), access, true, this.getLocalVariableTable(super.getConstantPool()));
        StringBuilder buf = new StringBuilder(signature);
        for (Attribute a : this.getAttributes()) {
            if (a instanceof Code || a instanceof ExceptionTable) continue;
            buf.append(" [").append(a).append("]");
        }
        if (this.throwsList.size() > 0) {
            for (String throwsDescriptor : this.throwsList) {
                buf.append("\n\t\tthrows ").append(throwsDescriptor);
            }
        }
        return buf.toString();
    }

    public MethodGen copy(String className, ConstantPoolGen cp) {
        Method m = ((MethodGen)this.clone()).getMethod();
        MethodGen mg = new MethodGen(m, className, super.getConstantPool());
        if (super.getConstantPool() != cp) {
            mg.setConstantPool(cp);
            mg.getInstructionList().replaceConstantPool(super.getConstantPool(), cp);
        }
        return mg;
    }

    public List<AnnotationEntryGen> getAnnotationsOnParameter(int i) {
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations || i > this.argTypes.length) {
            return null;
        }
        return this.paramAnnotations[i];
    }

    private void ensureExistingParameterAnnotationsUnpacked() {
        if (this.haveUnpackedParameterAnnotations) {
            return;
        }
        Attribute[] attrs = this.getAttributes();
        ParameterAnnotations paramAnnVisAttr = null;
        ParameterAnnotations paramAnnInvisAttr = null;
        for (Attribute attribute : attrs) {
            if (!(attribute instanceof ParameterAnnotations)) continue;
            if (!this.hasParameterAnnotations) {
                List[] parmList = new List[this.argTypes.length];
                this.paramAnnotations = parmList;
                for (int j = 0; j < this.argTypes.length; ++j) {
                    this.paramAnnotations[j] = new ArrayList<AnnotationEntryGen>();
                }
            }
            this.hasParameterAnnotations = true;
            ParameterAnnotations rpa = (ParameterAnnotations)attribute;
            if (rpa instanceof RuntimeVisibleParameterAnnotations) {
                paramAnnVisAttr = rpa;
            } else {
                paramAnnInvisAttr = rpa;
            }
            ParameterAnnotationEntry[] parameterAnnotationEntries = rpa.getParameterAnnotationEntries();
            for (int j = 0; j < parameterAnnotationEntries.length; ++j) {
                ParameterAnnotationEntry immutableArray = rpa.getParameterAnnotationEntries()[j];
                List<AnnotationEntryGen> mutable = this.makeMutableVersion(immutableArray.getAnnotationEntries());
                this.paramAnnotations[j].addAll(mutable);
            }
        }
        if (paramAnnVisAttr != null) {
            this.removeAttribute(paramAnnVisAttr);
        }
        if (paramAnnInvisAttr != null) {
            this.removeAttribute(paramAnnInvisAttr);
        }
        this.haveUnpackedParameterAnnotations = true;
    }

    private List<AnnotationEntryGen> makeMutableVersion(AnnotationEntry[] mutableArray) {
        ArrayList<AnnotationEntryGen> result = new ArrayList<AnnotationEntryGen>();
        for (AnnotationEntry element : mutableArray) {
            result.add(new AnnotationEntryGen(element, this.getConstantPool(), false));
        }
        return result;
    }

    public void addParameterAnnotation(int parameterIndex, AnnotationEntryGen annotation) {
        List<AnnotationEntryGen> existingAnnotations;
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations) {
            List[] parmList = new List[this.argTypes.length];
            this.paramAnnotations = parmList;
            this.hasParameterAnnotations = true;
        }
        if ((existingAnnotations = this.paramAnnotations[parameterIndex]) != null) {
            existingAnnotations.add(annotation);
        } else {
            ArrayList<AnnotationEntryGen> l = new ArrayList<AnnotationEntryGen>();
            l.add(annotation);
            this.paramAnnotations[parameterIndex] = l;
        }
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }

    static final class BranchStack {
        private final Stack<BranchTarget> branchTargets = new Stack();
        private final Map<InstructionHandle, BranchTarget> visitedTargets = new HashMap<InstructionHandle, BranchTarget>();

        BranchStack() {
        }

        public void push(InstructionHandle target, int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        private BranchTarget visit(InstructionHandle target, int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private boolean visited(InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }

    static final class BranchTarget {
        final InstructionHandle target;
        final int stackDepth;

        BranchTarget(InstructionHandle target, int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }
}

