/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.NativeKey;
import com.oracle.security.ucrypto.NativeRSAKeyFactory;
import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoMech;
import com.oracle.security.ucrypto.UcryptoProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import sun.nio.ch.DirectBuffer;

class NativeRSASignature
extends SignatureSpi {
    private static final int PKCS1PADDING_LEN = 11;
    private final UcryptoMech mech;
    private final int encodedLen;
    private SignatureContextRef pCtxt = null;
    private boolean initialized = false;
    private boolean sign = true;
    private int sigLength;
    private NativeKey key;
    private NativeRSAKeyFactory keyFactory;

    NativeRSASignature(UcryptoMech ucryptoMech, int n) throws NoSuchAlgorithmException {
        this.mech = ucryptoMech;
        this.encodedLen = n;
        this.keyFactory = new NativeRSAKeyFactory();
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected synchronized void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        NativeKey nativeKey = this.key;
        int n = this.sigLength;
        if (privateKey != this.key) {
            if (!(privateKey instanceof RSAPrivateKey)) {
                throw new InvalidKeyException("RSAPrivateKey required. Received: " + privateKey.getClass().getName());
            }
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            BigInteger bigInteger = rSAPrivateKey.getModulus();
            n = this.checkRSAKeyLength(bigInteger);
            BigInteger bigInteger2 = rSAPrivateKey.getPrivateExponent();
            try {
                if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
                    nativeKey = (NativeKey)((Object)this.keyFactory.engineGeneratePrivate(new RSAPrivateCrtKeySpec(bigInteger, rSAPrivateCrtKey.getPublicExponent(), bigInteger2, rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient())));
                } else {
                    nativeKey = (NativeKey)((Object)this.keyFactory.engineGeneratePrivate(new RSAPrivateKeySpec(bigInteger, bigInteger2)));
                }
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        this.init(true, nativeKey, n);
    }

    @Override
    protected synchronized void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        NativeKey nativeKey = this.key;
        int n = this.sigLength;
        if (publicKey != this.key) {
            if (publicKey instanceof RSAPublicKey) {
                BigInteger bigInteger = ((RSAPublicKey)publicKey).getModulus();
                n = this.checkRSAKeyLength(bigInteger);
                try {
                    nativeKey = (NativeKey)((Object)this.keyFactory.engineGeneratePublic(new RSAPublicKeySpec(bigInteger, ((RSAPublicKey)publicKey).getPublicExponent())));
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    throw new InvalidKeyException(invalidKeySpecException);
                }
            } else {
                throw new InvalidKeyException("RSAPublicKey required. Received: " + publicKey.getClass().getName());
            }
        }
        this.init(false, nativeKey, n);
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
    }

    @Override
    protected synchronized byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.sigLength];
        int n = this.doFinal(byArray, 0, this.sigLength);
        if (n < 0) {
            throw new SignatureException(new UcryptoException(-n));
        }
        return byArray;
    }

    @Override
    protected synchronized int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        if (byArray == null || n < 0 || byArray.length - n < this.sigLength || n2 < this.sigLength) {
            throw new SignatureException("Invalid output buffer. offset: " + n + ". len: " + n2 + ". sigLength: " + this.sigLength);
        }
        int n3 = this.doFinal(byArray, n, this.sigLength);
        if (n3 < 0) {
            throw new SignatureException(new UcryptoException(-n3));
        }
        return this.sigLength;
    }

    @Override
    protected synchronized void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        int n = this.update(byArray, 0, 1);
        if (n < 0) {
            throw new SignatureException(new UcryptoException(-n));
        }
    }

    @Override
    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (byArray == null || n < 0 || n2 == 0) {
            return;
        }
        int n3 = this.update(byArray, n, n2);
        if (n3 < 0) {
            throw new SignatureException(new UcryptoException(-n3));
        }
    }

    @Override
    protected synchronized void engineUpdate(ByteBuffer byteBuffer) {
        int n;
        int n2;
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            return;
        }
        if (!(byteBuffer instanceof DirectBuffer)) {
            super.engineUpdate(byteBuffer);
            return;
        }
        long l = ((DirectBuffer)((Object)byteBuffer)).address();
        int n3 = this.update(l + (long)(n2 = byteBuffer.position()), n = byteBuffer.remaining());
        if (n3 < 0) {
            throw new UcryptoException(-n3);
        }
        byteBuffer.position(n2 + n);
    }

    @Override
    protected synchronized boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    @Override
    protected synchronized boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        if (byArray == null || n < 0 || byArray.length - n < this.sigLength || n2 != this.sigLength) {
            throw new SignatureException("Invalid signature length: got " + n2 + " but was expecting " + this.sigLength);
        }
        int n3 = this.doFinal(byArray, n, n2);
        if (n3 == 0) {
            return true;
        }
        UcryptoProvider.debug("Signature: " + (Object)((Object)this.mech) + " verification error " + new UcryptoException(-n3).getMessage());
        return false;
    }

    void reset(boolean bl) {
        this.initialized = false;
        if (this.pCtxt != null) {
            this.pCtxt.dispose(bl);
            this.pCtxt = null;
        }
    }

    private static native long nativeInit(int var0, boolean var1, long var2, int var4);

    private static native int nativeUpdate(long var0, boolean var2, byte[] var3, int var4, int var5);

    private static native int nativeUpdate(long var0, boolean var2, long var3, int var5);

    private static native int nativeFinal(long var0, boolean var2, byte[] var3, int var4, int var5);

    private void init(boolean bl, NativeKey nativeKey, int n) {
        this.reset(true);
        this.sign = bl;
        this.sigLength = n;
        this.key = nativeKey;
        long l = NativeRSASignature.nativeInit(this.mech.value(), bl, nativeKey.value(), nativeKey.length());
        boolean bl2 = this.initialized = l != 0L;
        if (!this.initialized) {
            throw new UcryptoException("Cannot initialize Signature");
        }
        this.pCtxt = new SignatureContextRef(this, l, bl);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.init(this.sign, this.key, this.sigLength);
            if (!this.initialized) {
                throw new UcryptoException("Cannot initialize Signature");
            }
        }
    }

    private int update(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException("inOfs :" + n + ". inLen: " + n2 + ". in.length: " + byArray.length);
        }
        this.ensureInitialized();
        int n3 = NativeRSASignature.nativeUpdate(this.pCtxt.id, this.sign, byArray, n, n2);
        if (n3 < 0) {
            this.reset(false);
        }
        return n3;
    }

    private int update(long l, int n) {
        this.ensureInitialized();
        int n2 = NativeRSASignature.nativeUpdate(this.pCtxt.id, this.sign, l, n);
        if (n2 < 0) {
            this.reset(false);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doFinal(byte[] byArray, int n, int n2) {
        try {
            int n3;
            this.ensureInitialized();
            int n4 = n3 = NativeRSASignature.nativeFinal(this.pCtxt.id, this.sign, byArray, n, n2);
            return n4;
        }
        finally {
            this.reset(false);
        }
    }

    private int checkRSAKeyLength(BigInteger bigInteger) throws InvalidKeyException {
        int n = bigInteger.bitLength() + 7 >> 3;
        int n2 = n - 11;
        if (n2 < this.encodedLen) {
            throw new InvalidKeyException("Key is too short for this signature algorithm. maxDataSize: " + n2 + ". encodedLen: " + this.encodedLen);
        }
        return n;
    }

    private static class SignatureContextRef
    extends PhantomReference<NativeRSASignature>
    implements Comparable<SignatureContextRef> {
        private static ReferenceQueue<NativeRSASignature> refQueue = new ReferenceQueue();
        private static Set<SignatureContextRef> refList = new ConcurrentSkipListSet<SignatureContextRef>();
        private final long id;
        private final boolean sign;

        private static void drainRefQueueBounded() {
            SignatureContextRef signatureContextRef;
            while ((signatureContextRef = (SignatureContextRef)refQueue.poll()) != null) {
                signatureContextRef.dispose(true);
            }
        }

        SignatureContextRef(NativeRSASignature nativeRSASignature, long l, boolean bl) {
            super(nativeRSASignature, refQueue);
            this.id = l;
            this.sign = bl;
            refList.add(this);
            UcryptoProvider.debug("Resource: track Signature Ctxt " + this.id);
            SignatureContextRef.drainRefQueueBounded();
        }

        @Override
        public int compareTo(SignatureContextRef signatureContextRef) {
            if (this.id == signatureContextRef.id) {
                return 0;
            }
            return this.id < signatureContextRef.id ? -1 : 1;
        }

        void dispose(boolean bl) {
            refList.remove(this);
            try {
                if (bl) {
                    UcryptoProvider.debug("Resource: free Signature Ctxt " + this.id);
                    NativeRSASignature.nativeFinal(this.id, this.sign, null, 0, 0);
                } else {
                    UcryptoProvider.debug("Resource: stop tracking Signature Ctxt " + this.id);
                }
            }
            finally {
                this.clear();
            }
        }
    }

    public static final class SHA512
    extends NativeRSASignature {
        public SHA512() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_SHA512_RSA_PKCS, 83);
        }
    }

    public static final class SHA384
    extends NativeRSASignature {
        public SHA384() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_SHA384_RSA_PKCS, 67);
        }
    }

    public static final class SHA256
    extends NativeRSASignature {
        public SHA256() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_SHA256_RSA_PKCS, 51);
        }
    }

    public static final class SHA1
    extends NativeRSASignature {
        public SHA1() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_SHA1_RSA_PKCS, 35);
        }
    }

    public static final class MD5
    extends NativeRSASignature {
        public MD5() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_MD5_RSA_PKCS, 34);
        }
    }
}

