/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.Environment;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import com.sun.deploy.trace.TraceMessage;
import com.sun.deploy.trace.TraceStream;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;

public class Trace {
    private static boolean automation = false;
    private static final List<TraceMessage> initQueue = new ArrayList<TraceMessage>();
    private static boolean isInitDone = false;
    private static final List queue = new ArrayList();
    private static final Set traceListeners = new HashSet();
    private static final Set enabledTraceLevels = Collections.synchronizedSet(new HashSet());
    private static final PrintStream traceStdout = new PrintStream(new TraceStream());
    private static final PrintStream traceStderr = new PrintStream(new TraceStream());
    private static PrintStream realStdout = null;
    private static PrintStream realStderr = null;
    private static String[] nativeTracePrefixes = new String[]{"javaws", "jp2launcher", "npjp2", "jp2iexp"};
    private static final TraceMsgQueueChecker queueChecker = new TraceMsgQueueChecker();

    private Trace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureMessageQueueProcessingStarted() {
        TraceMsgQueueChecker traceMsgQueueChecker = queueChecker;
        synchronized (traceMsgQueueChecker) {
            queueChecker.notifyAll();
        }
    }

    public static synchronized void redirectStdioStderr() {
        if (null == realStdout && realStdout != traceStdout) {
            realStdout = System.out;
        }
        if (null == realStderr && realStderr != traceStderr) {
            realStderr = System.err;
        }
        System.setOut(traceStdout);
        System.setErr(traceStderr);
    }

    public static synchronized void restoreStdioStdErr() {
        if (null != realStdout && System.out == traceStdout) {
            System.setOut(realStdout);
        }
        if (null != realStderr && System.err == traceStderr) {
            System.setErr(realStderr);
        }
        realStdout = null;
        realStderr = null;
    }

    public static synchronized PrintStream getRealStdout() {
        if (null != realStdout && System.out == traceStdout) {
            return realStdout;
        }
        return System.out;
    }

    public static synchronized PrintStream getRealStderr() {
        if (null != realStderr && System.err == traceStderr) {
            return realStderr;
        }
        return System.err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        while (true) {
            List list = queue;
            synchronized (list) {
                if (queue.isEmpty()) {
                    break;
                }
                queue.notifyAll();
                try {
                    queue.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
        Trace.fireFlushEvent();
    }

    public static boolean isEnabled() {
        return enabledTraceLevels.size() > 1;
    }

    public static void setInitialTraceLevel() {
        Trace.setInitialTraceLevel(false);
    }

    public static void setInitialTraceLevel(boolean bl) {
        String string = bl ? null : Config.getStringProperty("deployment.trace.level");
        Trace.setInitialTraceLevel(string);
    }

    public static void setInitialTraceLevel(String string) {
        if (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("all")) {
                    Trace.setEnabled(TraceLevel.BASIC, true);
                    Trace.setEnabled(TraceLevel.CACHE, true);
                    Trace.setEnabled(TraceLevel.NETWORK, true);
                    Trace.setEnabled(TraceLevel.TEMP, true);
                    Trace.setEnabled(TraceLevel.SECURITY, true);
                    Trace.setEnabled(TraceLevel.EXTENSIONS, true);
                    Trace.setEnabled(TraceLevel.LIVECONNECT, true);
                    Trace.setEnabled(TraceLevel.UI, true);
                    Trace.setEnabled(TraceLevel.PRELOADER, true);
                    Trace.setEnabled(TraceLevel.RULESET, true);
                    break;
                }
                if (string2.equalsIgnoreCase("basic")) {
                    Trace.setEnabled(TraceLevel.BASIC, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("cache")) {
                    Trace.setEnabled(TraceLevel.CACHE, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("net")) {
                    Trace.setEnabled(TraceLevel.NETWORK, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("temp")) {
                    Trace.setEnabled(TraceLevel.TEMP, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("security")) {
                    Trace.setEnabled(TraceLevel.SECURITY, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("ext")) {
                    Trace.setEnabled(TraceLevel.EXTENSIONS, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("liveconnect")) {
                    Trace.setEnabled(TraceLevel.LIVECONNECT, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("ui")) {
                    Trace.setEnabled(TraceLevel.UI, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("preloader")) {
                    Trace.setEnabled(TraceLevel.PRELOADER, true);
                    continue;
                }
                if (!string2.equalsIgnoreCase("ruleset")) continue;
                Trace.setEnabled(TraceLevel.RULESET, true);
            }
        }
    }

    public static boolean isEnabled(TraceLevel traceLevel) {
        return enabledTraceLevels.contains(traceLevel);
    }

    public static void setEnabled(TraceLevel traceLevel, boolean bl) {
        if (bl) {
            enabledTraceLevels.add(traceLevel);
        } else {
            enabledTraceLevels.remove(traceLevel);
        }
    }

    public static boolean isAutomationEnabled() {
        return automation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDone() {
        List list = queue;
        synchronized (list) {
            isInitDone = true;
            List<TraceMessage> list2 = initQueue;
            synchronized (list2) {
                ListIterator<TraceMessage> listIterator = initQueue.listIterator();
                while (listIterator.hasNext()) {
                    TraceMessage traceMessage = (TraceMessage)listIterator.next();
                    TraceLevel traceLevel = traceMessage.getLevel();
                    if (!enabledTraceLevels.contains(traceLevel)) continue;
                    Trace.enQueue(traceMessage);
                }
                initQueue.clear();
            }
        }
    }

    public static void enableAutomation(boolean bl) {
        automation = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enInitQueue(TraceMessage traceMessage) {
        List<TraceMessage> list = initQueue;
        synchronized (list) {
            initQueue.add(traceMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enQueue(TraceMessage traceMessage) {
        List list = queue;
        synchronized (list) {
            queue.add(traceMessage);
            queue.notifyAll();
        }
    }

    public static void print(String string, TraceLevel traceLevel) {
        TraceMessage traceMessage = new TraceMessage(traceLevel, string);
        if (!isInitDone) {
            Trace.enInitQueue(traceMessage);
        } else if (enabledTraceLevels.contains(traceLevel)) {
            Trace.enQueue(traceMessage);
        }
    }

    public static void println(String string, TraceLevel traceLevel) {
        TraceMessage traceMessage = new TraceMessage(traceLevel, string, true);
        if (!isInitDone) {
            Trace.enInitQueue(traceMessage);
        } else if (enabledTraceLevels.contains(traceLevel)) {
            Trace.enQueue(traceMessage);
        }
    }

    public static void println(String string) {
        Trace.println(string, TraceLevel.DEFAULT);
    }

    public static void print(String string) {
        Trace.print(string, TraceLevel.DEFAULT);
    }

    public static void msgPrintln(String string, Object[] objectArray, TraceLevel traceLevel) {
        String string2 = ResourceManager.getMessage(string);
        String string3 = MessageFormat.format(string2, objectArray);
        TraceMessage traceMessage = new TraceMessage(traceLevel, string3, true);
        if (!isInitDone) {
            Trace.enInitQueue(traceMessage);
        } else if (enabledTraceLevels.contains(traceLevel)) {
            Trace.enQueue(traceMessage);
        }
    }

    public static void msgPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.DEFAULT);
    }

    public static void msgPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.BASIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTraceListener(TraceListener traceListener) {
        Set set = traceListeners;
        synchronized (set) {
            traceListeners.add(traceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTraceListener(TraceListener traceListener) {
        Set set = traceListeners;
        synchronized (set) {
            traceListeners.remove(traceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTraceListeners() {
        Set set = traceListeners;
        synchronized (set) {
            traceListeners.clear();
        }
    }

    public static void resetTraceLevel() {
        enabledTraceLevels.clear();
        enabledTraceLevels.add(TraceLevel.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void firePrintlnEvent(TraceMessage traceMessage) {
        TraceListener[] traceListenerArray;
        Set set = traceListeners;
        synchronized (set) {
            traceListenerArray = traceListeners.toArray(new TraceListener[traceListeners.size()]);
        }
        for (int i = 0; i < traceListenerArray.length; ++i) {
            try {
                traceListenerArray[i].print(traceMessage.getMessage());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireFlushEvent() {
        TraceListener[] traceListenerArray;
        Set set = traceListeners;
        synchronized (set) {
            traceListenerArray = traceListeners.toArray(new TraceListener[traceListeners.size()]);
        }
        for (int i = 0; i < traceListenerArray.length; ++i) {
            try {
                traceListenerArray[i].flush();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void ignoredException(Exception exception) {
        Trace.ignored(exception);
    }

    public static void ignored(Throwable throwable) {
        if (enabledTraceLevels.size() > 1) {
            throwable.printStackTrace();
        }
    }

    public static void ignored(Throwable throwable, boolean bl) {
        Throwable throwable2 = throwable;
        if (bl && throwable.getCause() != null) {
            throwable2 = throwable.getCause();
        }
        Trace.ignored(throwable2);
    }

    public static void printException(Throwable throwable) {
        Trace.printException(null, throwable);
    }

    public static void printException(Component component, Throwable throwable) {
        Trace.printException(component, throwable, null, null);
    }

    public static void printException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2);
    }

    public static void printException(Component component, Throwable throwable, String string, String string2) {
        Trace.printException(component, throwable, string, string2, true);
    }

    public static void printException(Component component, Throwable throwable, String string, String string2, boolean bl) {
        Trace.println("Ignored exception: " + throwable);
        if (bl && !Trace.isAutomationEnabled()) {
            if (string == null) {
                string = ResourceManager.getMessage("dialogfactory.general_error");
            }
            ToolkitStore.getUI().showExceptionDialog(component, null, throwable, string2, string, null, null);
        }
    }

    public static void netPrintln(String string) {
        Trace.println(string, TraceLevel.NETWORK);
    }

    public static void msgNetPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.NETWORK);
    }

    public static void msgNetPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.NETWORK);
    }

    public static void netPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceManager.getMessage("dialogfactory.net_error"), null, false);
    }

    public static void netPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, false);
    }

    public static void securityPrintln(String string) {
        Trace.println(string, TraceLevel.SECURITY);
    }

    public static void msgSecurityPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.SECURITY);
    }

    public static void msgSecurityPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.SECURITY);
    }

    public static void securityPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceManager.getMessage("dialogfactory.security_error"), null, true);
    }

    public static void securityPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, true);
    }

    public static void extPrintln(String string) {
        Trace.println(string, TraceLevel.EXTENSIONS);
    }

    public static void msgExtPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.EXTENSIONS);
    }

    public static void msgExtPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.EXTENSIONS);
    }

    public static void extPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceManager.getMessage("dialogfactory.ext_error"), null, true);
    }

    public static void extPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, true);
    }

    public static void liveConnectPrintln(String string) {
        Trace.println(string, TraceLevel.LIVECONNECT);
    }

    public static void msgLiveConnectPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.LIVECONNECT);
    }

    public static void msgLiveConnectPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.LIVECONNECT);
    }

    public static void liveConnectPrintException(Throwable throwable) {
        Trace.printException(null, throwable, null, null, false);
    }

    public static void cleanUpLogFiles(final String string, final String string2, File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string3 = file.getName();
                if (string3.startsWith(string) && string3.endsWith(string2)) {
                    return true;
                }
                for (int i = 0; i < nativeTracePrefixes.length; ++i) {
                    if (!string3.startsWith(nativeTracePrefixes[i])) continue;
                    return true;
                }
                return false;
            }
        });
        int n = Config.getIntProperty("deployment.max.output.files");
        if (n > 0 && fileArray.length >= n) {
            int n2 = fileArray.length;
            Arrays.sort(fileArray, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    Date date = new Date(((File)object).lastModified());
                    Date date2 = new Date(((File)object2).lastModified());
                    return date.compareTo(date2);
                }
            });
            for (int i = 0; i < n2 - n + 1; ++i) {
                fileArray[i].delete();
            }
        }
    }

    public static File createTempFile(String string, String string2, File file) {
        try {
            if (file != null) {
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                Trace.cleanUpLogFiles(string, string2, file);
            }
            String string3 = string + "_" + Platform.get().getNativePID() + "_";
            return File.createTempFile(string3, string2, file);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            return null;
        }
    }

    public static String getIntro() {
        DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy");
        Date date = new Date(BuiltInProperties.expirationTime);
        dateFormat = DateFormat.getInstance();
        StringBuffer stringBuffer = new StringBuffer();
        String string = Environment.isJavaWebStart() ? "product.javaws.name" : "product.javapi.name";
        stringBuffer.append(ResourceManager.getString(string, "11.341.2.25"));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceManager.getString("console.using_jre_version", System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name")));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceManager.getString("console.expires", dateFormat.format(date)));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceManager.getString("console.user.home") + " = " + System.getProperty("user.home"));
        return stringBuffer.toString();
    }

    static {
        Trace.resetTraceLevel();
        Thread thread = new Thread((Runnable)queueChecker, "traceMsgQueueThread");
        thread.setDaemon(true);
        thread.start();
    }

    private static class TraceMsgQueueChecker
    implements Runnable {
        private TraceMsgQueueChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                object = this;
                synchronized (object) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (true) {
                object = null;
                List list = queue;
                synchronized (list) {
                    if (queue.isEmpty()) {
                        try {
                            queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    try {
                        object = (TraceMessage)queue.remove(0);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    queue.notifyAll();
                }
                if (object == null) continue;
                Trace.firePrintlnEvent((TraceMessage)object);
            }
        }
    }
}

