/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTable
extends Attribute {
    private LocalVariable[] localVariableTable;

    public LocalVariableTable(LocalVariableTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTable(), c.getConstantPool());
    }

    public LocalVariableTable(int nameIndex, int length, LocalVariable[] localVariableTable, ConstantPool constantPool) {
        super((byte)5, nameIndex, length, constantPool);
        this.localVariableTable = localVariableTable;
    }

    LocalVariableTable(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LocalVariable[])null, constant_pool);
        int local_variable_table_length = input.readUnsignedShort();
        this.localVariableTable = new LocalVariable[local_variable_table_length];
        for (int i = 0; i < local_variable_table_length; ++i) {
            this.localVariableTable[i] = new LocalVariable(input, constant_pool);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.localVariableTable.length);
        for (LocalVariable variable : this.localVariableTable) {
            variable.dump(file);
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        return this.localVariableTable;
    }

    @Deprecated
    public final LocalVariable getLocalVariable(int index) {
        for (LocalVariable variable : this.localVariableTable) {
            if (variable.getIndex() != index) continue;
            return variable;
        }
        return null;
    }

    public final LocalVariable getLocalVariable(int index, int pc) {
        for (LocalVariable variable : this.localVariableTable) {
            if (variable.getIndex() != index) continue;
            int start_pc = variable.getStartPC();
            int end_pc = start_pc + variable.getLength();
            if (pc < start_pc || pc > end_pc) continue;
            return variable;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] local_variable_table) {
        this.localVariableTable = local_variable_table;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.localVariableTable.length; ++i) {
            buf.append(this.localVariableTable[i]);
            if (i >= this.localVariableTable.length - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        LocalVariableTable c = (LocalVariableTable)this.clone();
        c.localVariableTable = new LocalVariable[this.localVariableTable.length];
        for (int i = 0; i < this.localVariableTable.length; ++i) {
            c.localVariableTable[i] = this.localVariableTable[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    public final int getTableLength() {
        return this.localVariableTable == null ? 0 : this.localVariableTable.length;
    }
}

