/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fr_CA extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Acre = new String[] {
               "heure normale de l\u2019Acre",
               "",
               "heure avanc\u00e9e de l\u2019Acre",
               "",
               "heure de l\u2019Acre",
               "",
            };
        final String[] Apia = new String[] {
               "heure normale d\u2019Apia",
               "",
               "heure avanc\u00e9e d\u2019Apia",
               "",
               "heure d\u2019Apia",
               "",
            };
        final String[] Cook = new String[] {
               "heure normale des \u00eeles Cook",
               "",
               "heure avanc\u00e9e des \u00eeles Cook",
               "",
               "heure des \u00eeles Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "heure normale de Cuba",
               "",
               "heure avanc\u00e9e de Cuba",
               "",
               "heure de Cuba",
               "",
            };
        final String[] Fiji = new String[] {
               "heure normale des \u00eeles Fidji",
               "",
               "heure avanc\u00e9e des \u00eeles Fidji",
               "",
               "heure des \u00eeles Fidji",
               "",
            };
        final String[] Hovd = new String[] {
               "heure normale de Hovd",
               "",
               "heure avanc\u00e9e de Hovd",
               "",
               "heure de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "heure normale d\u2019Iran",
               "",
               "heure avanc\u00e9e d\u2019Iran",
               "",
               "heure de l\u2019Iran",
               "",
            };
        final String[] Omsk = new String[] {
               "heure normale d\u2019Omsk",
               "",
               "heure avanc\u00e9e d\u2019Omsk",
               "",
               "heure d\u2019Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "heure normale du P\u00e9rou",
               "",
               "heure avanc\u00e9e du P\u00e9rou",
               "",
               "heure du P\u00e9rou",
               "",
            };
        final String[] Chile = new String[] {
               "heure normale du Chili",
               "",
               "heure avanc\u00e9e du Chili",
               "",
               "heure du Chili",
               "",
            };
        final String[] China = new String[] {
               "heure normale de Chine",
               "",
               "heure avanc\u00e9e de Chine",
               "",
               "heure de Chine",
               "",
            };
        final String[] Japan = new String[] {
               "heure normale du Japon",
               "",
               "heure avanc\u00e9e du Japon",
               "",
               "heure du Japon",
               "",
            };
        final String[] Korea = new String[] {
               "heure normale de la Cor\u00e9e",
               "",
               "heure avanc\u00e9e de Cor\u00e9e",
               "",
               "heure de la Cor\u00e9e",
               "",
            };
        final String[] Samoa = new String[] {
               "heure normale des Samoa",
               "",
               "heure avanc\u00e9e des Samoa",
               "",
               "heure des Samoa",
               "",
            };
        final String[] Tonga = new String[] {
               "heure normale des Tonga",
               "",
               "heure avanc\u00e9e de Tonga",
               "",
               "heure des Tonga",
               "",
            };
        final String[] Alaska = new String[] {
               "heure normale de l\u2019Alaska",
               "",
               "heure avanc\u00e9e de l\u2019Alaska",
               "",
               "heure de l\u2019Alaska",
               "",
            };
        final String[] Amazon = new String[] {
               "heure normale de l\u2019Amazonie",
               "",
               "heure avanc\u00e9e de l\u2019Amazonie",
               "",
               "heure de l\u2019Amazonie",
               "",
            };
        final String[] Anadyr = new String[] {
               "heure normale d\u2019Anadyr",
               "",
               "heure avanc\u00e9e d\u2019Anadyr",
               "",
               "heure d\u2019Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "heure normale des A\u00e7ores",
               "",
               "heure avanc\u00e9e des A\u00e7ores",
               "",
               "heure des A\u00e7ores",
               "",
            };
        final String[] Easter = new String[] {
               "heure normale de l\u2019\u00eele de P\u00e2ques",
               "",
               "heure avanc\u00e9e de l\u2019\u00eele de P\u00e2ques",
               "",
               "heure de l\u2019\u00eele de P\u00e2ques",
               "",
            };
        final String[] Israel = new String[] {
               "heure normale d\u2019Isra\u00ebl",
               "",
               "heure avanc\u00e9e d\u2019Isra\u00ebl",
               "",
               "heure d\u2019Isra\u00ebl",
               "",
            };
        final String[] Moscow = new String[] {
               "heure normale de Moscou",
               "",
               "heure avanc\u00e9e de Moscou",
               "",
               "heure de Moscou",
               "",
            };
        final String[] Taipei = new String[] {
               "heure normale de Taipei",
               "",
               "heure avanc\u00e9e de Taipei",
               "",
               "heure de Taipei",
               "",
            };
        final String[] Arabian = new String[] {
               "heure normale de l\u2019Arabie",
               "",
               "heure avanc\u00e9e de l\u2019Arabie",
               "",
               "heure de l\u2019Arabie",
               "",
            };
        final String[] Armenia = new String[] {
               "heure normale de l\u2019Arm\u00e9nie",
               "",
               "heure avanc\u00e9e d\u2019Arm\u00e9nie",
               "",
               "heure de l\u2019Arm\u00e9nie",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "temps universel coordonn\u00e9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "heure normale de la G\u00e9orgie",
               "",
               "heure avanc\u00e9e de G\u00e9orgie",
               "",
               "heure de la G\u00e9orgie",
               "",
            };
        final String[] Irkutsk = new String[] {
               "heure normale d\u2019Irkoutsk",
               "",
               "heure avanc\u00e9e d\u2019Irkoutsk",
               "",
               "heure d\u2019Irkoutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "heure normale de Magadan",
               "",
               "heure avanc\u00e9e de Magadan",
               "",
               "heure de Magadan",
               "",
            };
        final String[] Norfolk = new String[] {
               "heure normale de l\u2019\u00eele Norfolk",
               "",
               "heure avanc\u00e9e de l\u2019\u00eele Norfolk",
               "",
               "heure de l\u2019\u00eele Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "heure normale de Fernando de Noronha",
               "",
               "heure avanc\u00e9e de Fernando de Noronha",
               "",
               "heure de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "heure de la R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "heure normale de l\u2019Uruguay",
               "",
               "heure avanc\u00e9e de l\u2019Uruguay",
               "",
               "heure de l\u2019Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "heure normale du Vanuatu",
               "",
               "heure avanc\u00e9e de Vanuatu",
               "",
               "heure du Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "heure normale de Iakoutsk",
               "",
               "heure avanc\u00e9e de Iakoutsk",
               "",
               "heure de Iakoutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "heure normale de l\u2019Atlantique",
               "",
               "heure avanc\u00e9e de l\u2019Atlantique",
               "",
               "heure de l\u2019Atlantique",
               "",
            };
        final String[] Brasilia = new String[] {
               "heure normale de Brasilia",
               "",
               "heure avanc\u00e9e de Brasilia",
               "",
               "heure de Brasilia",
               "",
            };
        final String[] Colombia = new String[] {
               "heure normale de Colombie",
               "",
               "heure avanc\u00e9e de Colombie",
               "",
               "heure de Colombie",
               "",
            };
        final String[] Falkland = new String[] {
               "heure normale des \u00eeles Malouines",
               "",
               "heure avanc\u00e9e des \u00eeles Malouines",
               "",
               "heure des \u00eeles Malouines",
               "",
            };
        final String[] Mongolia = new String[] {
               "heure normale d\u2019Oulan-Bator",
               "",
               "heure avanc\u00e9e d\u2019Oulan-Bator",
               "",
               "heure d\u2019Oulan-Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "heure normale du Pakistan",
               "",
               "heure avanc\u00e9e du Pakistan",
               "",
               "heure du Pakistan",
               "",
            };
        final String[] Paraguay = new String[] {
               "heure normale du Paraguay",
               "",
               "heure avanc\u00e9e du Paraguay",
               "",
               "heure du Paraguay",
               "",
            };
        final String[] Sakhalin = new String[] {
               "heure normale de Sakhaline",
               "",
               "heure avanc\u00e9e de Sakhaline",
               "",
               "heure de Sakhaline",
               "",
            };
        final String[] Argentina = new String[] {
               "heure normale d\u2019Argentine",
               "",
               "heure avanc\u00e9e de l\u2019Argentine",
               "",
               "heure de l\u2019Argentine",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "heure normale de Hong Kong",
               "",
               "heure avanc\u00e9e de Hong Kong",
               "",
               "heure de Hong Kong",
               "",
            };
        final String[] Kamchatka = new String[] {
               "heure normale de Petropavlovsk-Kamchatski",
               "",
               "heure avanc\u00e9e de Petropavlovsk-Kamchatski",
               "",
               "heure de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "heure normale de Lord Howe",
               "",
               "heure avanc\u00e9e de Lord Howe",
               "",
               "heure de Lord Howe",
               "",
            };
        final String[] Mauritius = new String[] {
               "heure normale de Maurice",
               "",
               "heure avanc\u00e9e de Maurice",
               "",
               "heure de Maurice",
               "",
            };
        final String[] Volgograd = new String[] {
               "heure normale de Volgograd",
               "",
               "heure avanc\u00e9e de Volgograd",
               "",
               "heure de Volgograd",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "heure normale de l\u2019Azerba\u00efdjan",
               "",
               "heure avanc\u00e9e d\u2019Azerba\u00efdjan",
               "",
               "heure de l\u2019Azerba\u00efdjan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "heure normale du Bangladesh",
               "",
               "heure avanc\u00e9e du Bangladesh",
               "",
               "heure du Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "heure normale du Cap-Vert",
               "",
               "heure avanc\u00e9e du Cap-Vert",
               "",
               "heure du Cap-Vert",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "heure normale de l\u2019Ouzb\u00e9kistan",
               "",
               "heure avanc\u00e9e de l\u2019Ouzb\u00e9kistan",
               "",
               "heure de l\u2019Ouzb\u00e9kistan",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "heure normale de Krasno\u00efarsk",
               "",
               "heure avanc\u00e9e de Krasno\u00efarsk",
               "",
               "heure de Krasno\u00efarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "heure normale de la Nouvelle-Z\u00e9lande",
               "",
               "heure avanc\u00e9e de la Nouvelle-Z\u00e9lande",
               "",
               "heure de la Nouvelle-Z\u00e9lande",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "heure normale de Novossibirsk",
               "",
               "heure avanc\u00e9e de Novossibirsk",
               "",
               "heure de Novossibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "heure normale des Philippines",
               "",
               "heure avanc\u00e9e des Philippines",
               "",
               "heure des Philippines",
               "",
            };
        final String[] Vladivostok = new String[] {
               "heure normale de Vladivostok",
               "",
               "heure avanc\u00e9e de Vladivostok",
               "",
               "heure de Vladivostok",
               "",
            };
        final String[] Newfoundland = new String[] {
               "heure normale de Terre-Neuve",
               "HNT",
               "heure avanc\u00e9e de Terre-Neuve",
               "HAT",
               "heure de Terre-Neuve",
               "HT",
            };
        final String[] Turkmenistan = new String[] {
               "heure normale du Turkm\u00e9nistan",
               "",
               "heure avanc\u00e9e du Turkm\u00e9nistan",
               "",
               "heure du Turkm\u00e9nistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "heure de Guyane fran\u00e7aise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "heure normale de la Nouvelle-Cal\u00e9donie",
               "",
               "heure avanc\u00e9e de Nouvelle-Cal\u00e9donie",
               "",
               "heure de la Nouvelle-Cal\u00e9donie",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "heure normale d\u2019Ekaterinbourg",
               "",
               "heure avanc\u00e9e d\u2019Ekaterinbourg",
               "",
               "heure d\u2019Ekaterinbourg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "heure d\u2019Afrique centrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "heure d\u2019Afrique orientale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "heure normale d\u2019Afrique de l\u2019Ouest",
               "",
               "heure avanc\u00e9e d\u2019Afrique de l\u2019Ouest",
               "",
               "heure d\u2019Afrique de l\u2019Ouest",
               "",
            };
        final String[] Europe_Central = new String[] {
               "heure normale de l\u2019Europe centrale",
               "",
               "heure avanc\u00e9e de l\u2019Europe centrale",
               "",
               "heure de l\u2019Europe centrale",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "heure normale de l\u2019Europe de l\u2019Est",
               "",
               "heure avanc\u00e9e de l\u2019Europe de l\u2019Est",
               "",
               "heure de l\u2019Europe de l\u2019Est",
               "",
            };
        final String[] Europe_Western = new String[] {
               "heure normale de l\u2019Europe de l\u2019Ouest",
               "",
               "heure avanc\u00e9e de l\u2019Europe de l\u2019Ouest",
               "",
               "heure de l\u2019Europe de l\u2019Ouest",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "heure normale du Pacifique mexicain",
               "",
               "heure avanc\u00e9e du Pacifique mexicain",
               "",
               "heure du Pacifique mexicain",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "heure normale d\u2019Afrique du Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "heure normale du Centre",
               "HNC",
               "heure avanc\u00e9e du Centre",
               "HAC",
               "heure du Centre",
               "HC",
            };
        final String[] America_Eastern = new String[] {
               "heure normale de l\u2019Est",
               "HNE",
               "heure avanc\u00e9e de l\u2019Est",
               "HAE",
               "heure de l\u2019Est",
               "HE",
            };
        final String[] America_Pacific = new String[] {
               "heure normale du Pacifique",
               "HNP",
               "heure avanc\u00e9e du Pacifique",
               "HAP",
               "heure du Pacifique",
               "HP",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "heure normale d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "",
               "heure avanc\u00e9e d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "",
               "heure d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "heure normale de Saint-Pierre-et-Miquelon",
               "",
               "heure avanc\u00e9e de Saint-Pierre-et-Miquelon",
               "",
               "heure de Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "heure normale des Rocheuses",
               "HNR",
               "heure avanc\u00e9e des Rocheuses",
               "HAR",
               "heure des Rocheuses",
               "HR",
            };
        final String[] Mexico_Northwest = new String[] {
               "heure normale du Nord-Ouest du Mexique",
               "",
               "heure avanc\u00e9e du Nord-Ouest du Mexique",
               "",
               "heure du Nord-Ouest du Mexique",
               "",
            };
        final String[] Australia_Central = new String[] {
               "heure normale du centre de l\u2019Australie",
               "",
               "heure avanc\u00e9e du centre de l\u2019Australie",
               "",
               "heure du centre de l\u2019Australie",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "heure normale de l\u2019Est de l\u2019Australie",
               "",
               "heure avanc\u00e9e de l\u2019Est de l\u2019Australie",
               "",
               "heure de l\u2019Est de l\u2019Australie",
               "",
            };
        final String[] Australia_Western = new String[] {
               "heure normale de l\u2019Ouest de l\u2019Australie",
               "",
               "heure avanc\u00e9e de l\u2019Ouest de l\u2019Australie",
               "",
               "heure de l\u2019Ouest de l\u2019Australie",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "heure normale de l\u2019Est du Groenland",
               "",
               "heure avanc\u00e9e de l\u2019Est du Groenland",
               "",
               "heure de l\u2019Est du Groenland",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "heure normale de l\u2019Ouest du Groenland",
               "",
               "heure avanc\u00e9e de l\u2019Ouest du Groenland",
               "",
               "heure de l\u2019Ouest du Groenland",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "heure normale du centre-ouest de l\u2019Australie",
               "",
               "heure avanc\u00e9e du centre-ouest de l\u2019Australie",
               "",
               "heure du centre-ouest de l\u2019Australie",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Riyadh", Arabian },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Karachi", Pakistan },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "",
                    "",
                    "heure avanc\u00e9e irlandaise",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "",
                    "",
                    "heure avanc\u00e9e britannique",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Mountain },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "",
                    "",
                    "heure avanc\u00e9e britannique",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Mountain },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Thimphu", "Thimphou" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Tripoli", "Tripoli [Libye]" },
            { "timezone.excity.America/Cayman", "\u00eeles Ca\u00efmans" },
            { "timezone.excity.Europe/Vatican", "Vatican" },
            { "timezone.excity.Pacific/Easter", "\u00eele de P\u00e2ques" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.Atlantic/Faeroe", "\u00eeles F\u00e9ro\u00e9" },
            { "timezone.excity.America/Barbados", "Barbade (La)" },
            { "timezone.excity.America/St_Johns", "St. John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Saint-Christophe-et-Ni\u00e9v\u00e8s" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Isle_of_Man", "\u00eele de Man" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah [Dakota du Nord]" },
            { "timezone.excity.America/North_Dakota/Center", "Center [Dakota du Nord]" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota du Nord" },
        };
        return data;
    }
}
