/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "greenwichsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "acrejsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "acrejsk\u00fd letn\u00fd \u010das",
               "",
               "acrejsk\u00fd \u010das",
               "",
            };
        final String[] Apia = new String[] {
               "apijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "apijsk\u00fd letn\u00fd \u010das",
               "",
               "apijsk\u00fd \u010das",
               "",
            };
        final String[] Cook = new String[] {
               "\u0161tandardn\u00fd \u010das Cookov\u00fdch ostrovov",
               "",
               "letn\u00fd \u010das Cookov\u00fdch ostrovov",
               "",
               "\u010das Cookov\u00fdch ostrovov",
               "",
            };
        final String[] Cuba = new String[] {
               "kub\u00e1nsky \u0161tandardn\u00fd \u010das",
               "",
               "kub\u00e1nsky letn\u00fd \u010das",
               "",
               "kub\u00e1nsky \u010das",
               "",
            };
        final String[] Fiji = new String[] {
               "fid\u017eijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "fid\u017eijsk\u00fd letn\u00fd \u010das",
               "",
               "fid\u017eijsk\u00fd \u010das",
               "",
            };
        final String[] Gulf = new String[] {
               "\u0161tandardn\u00fd \u010das Perzsk\u00e9ho z\u00e1livu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "chovdsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "chovdsk\u00fd letn\u00fd \u010das",
               "",
               "chovdsk\u00fd \u010das",
               "",
            };
        final String[] Iran = new String[] {
               "ir\u00e1nsky \u0161tandardn\u00fd \u010das",
               "",
               "ir\u00e1nsky letn\u00fd \u010das",
               "",
               "ir\u00e1nsky \u010das",
               "",
            };
        final String[] Niue = new String[] {
               "niuejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "omsk\u00fd letn\u00fd \u010das",
               "",
               "omsk\u00fd \u010das",
               "",
            };
        final String[] Peru = new String[] {
               "peru\u00e1nsky \u0161tandardn\u00fd \u010das",
               "",
               "peru\u00e1nsky letn\u00fd \u010das",
               "",
               "peru\u00e1nsky \u010das",
               "",
            };
        final String[] Truk = new String[] {
               "chuuksk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u010das ostrova Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Casey = new String[] {
               "\u010das Caseyho stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u010dilsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "\u010dilsk\u00fd letn\u00fd \u010das",
               "",
               "\u010dilsk\u00fd \u010das",
               "",
            };
        final String[] China = new String[] {
               "\u010d\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "\u010d\u00ednsky letn\u00fd \u010das",
               "",
               "\u010d\u00ednsky \u010das",
               "",
            };
        final String[] Cocos = new String[] {
               "\u010das Kokosov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "\u010das Davisovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "japonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "japonsk\u00fd letn\u00fd \u010das",
               "",
               "japonsk\u00fd \u010das",
               "",
            };
        final String[] Korea = new String[] {
               "k\u00f3rejsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "k\u00f3rejsk\u00fd letn\u00fd \u010das",
               "",
               "k\u00f3rejsk\u00fd \u010das",
               "",
            };
        final String[] Nauru = new String[] {
               "naurusk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nep\u00e1lsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samojsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "samojsk\u00fd letn\u00fd \u010das",
               "",
               "samojsk\u00fd \u010das",
               "",
            };
        final String[] Syowa = new String[] {
               "\u010das stanice \u0160\u00f3wa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ton\u017esk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "ton\u017esk\u00fd letn\u00fd \u010das",
               "",
               "ton\u017esk\u00fd \u010das",
               "",
            };
        final String[] Alaska = new String[] {
               "alja\u0161sk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "alja\u0161sk\u00fd letn\u00fd \u010das",
               "",
               "alja\u0161sk\u00fd \u010das",
               "",
            };
        final String[] Amazon = new String[] {
               "amazonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "amazonsk\u00fd letn\u00fd \u010das",
               "",
               "amazonsk\u00fd \u010das",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Anadyrsk\u00fd letn\u00fd \u010das",
               "",
               "Anadyrsk\u00fd \u010das",
               "",
            };
        final String[] Azores = new String[] {
               "azorsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "azorsk\u00fd letn\u00fd \u010das",
               "",
               "azorsk\u00fd \u010das",
               "",
            };
        final String[] Bhutan = new String[] {
               "bhut\u00e1nsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "brunejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "\u0161tandardn\u00fd \u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
               "letn\u00fd \u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
               "\u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
            };
        final String[] Guyana = new String[] {
               "guyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "izraelsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "izraelsk\u00fd letn\u00fd \u010das",
               "",
               "izraelsk\u00fd \u010das",
               "",
            };
        final String[] Kosrae = new String[] {
               "kosrajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "\u010das Mawsonovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "moskovsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "moskovsk\u00fd letn\u00fd \u010das",
               "",
               "moskovsk\u00fd \u010das",
               "",
            };
        final String[] Ponape = new String[] {
               "ponapsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Samarsk\u00fd letn\u00fd \u010das",
               "",
               "Samarsk\u00fd \u010das",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahitsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "tchajpejsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "tchajpejsk\u00fd letn\u00fd \u010das",
               "",
               "tchajpejsk\u00fd \u010das",
               "",
            };
        final String[] Tuvalu = new String[] {
               "tuvalsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "\u010das stanice Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u010das ostrovov Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arabsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "arabsk\u00fd letn\u00fd \u010das",
               "",
               "arabsk\u00fd \u010das",
               "",
            };
        final String[] Armenia = new String[] {
               "arm\u00e9nsky \u0161tandardn\u00fd \u010das",
               "",
               "arm\u00e9nsky letn\u00fd \u010das",
               "",
               "arm\u00e9nsky \u010das",
               "",
            };
        final String[] Bolivia = new String[] {
               "bol\u00edvijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathamsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "chathamsk\u00fd letn\u00fd \u010das",
               "",
               "chathamsk\u00fd \u010das",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinovan\u00fd svetov\u00fd \u010das",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ekv\u00e1dorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "gambiersk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "gruz\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "gruz\u00ednsky letn\u00fd \u010das",
               "",
               "gruz\u00ednsky \u010das",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "irkutsk\u00fd letn\u00fd \u010das",
               "",
               "irkutsk\u00fd \u010das",
               "",
            };
        final String[] Magadan = new String[] {
               "magadansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "magadansk\u00fd letn\u00fd \u010das",
               "",
               "magadansk\u00fd \u010das",
               "",
            };
        final String[] Myanmar = new String[] {
               "mjanmarsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "\u0161tandardn\u00fd \u010das s\u00faostrovia Fernando de Noronha",
               "",
               "letn\u00fd \u010das s\u00faostrovia Fernando de Noronha",
               "",
               "\u010das s\u00faostrovia Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "r\u00e9unionsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u010das Rotherovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u010das \u0160alam\u00fanov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguajsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "uruguajsk\u00fd letn\u00fd \u010das",
               "",
               "uruguajsk\u00fd \u010das",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "vanuatsk\u00fd letn\u00fd \u010das",
               "",
               "vanuatsk\u00fd \u010das",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "jakutsk\u00fd letn\u00fd \u010das",
               "",
               "jakutsk\u00fd \u010das",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlantick\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "atlantick\u00fd letn\u00fd \u010das",
               "",
               "atlantick\u00fd \u010das",
               "",
            };
        final String[] Brasilia = new String[] {
               "braz\u00edlsky \u0161tandardn\u00fd \u010das",
               "",
               "braz\u00edlsky letn\u00fd \u010das",
               "",
               "braz\u00edlsky \u010das",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorrsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "kolumbijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "kolumbijsk\u00fd letn\u00fd \u010das",
               "",
               "kolumbijsk\u00fd \u010das",
               "",
            };
        final String[] Falkland = new String[] {
               "falklandsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "falklandsk\u00fd letn\u00fd \u010das",
               "",
               "falklandsk\u00fd \u010das",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajzijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "maldivsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ulanb\u00e1tarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "ulanb\u00e1tarsk\u00fd letn\u00fd \u010das",
               "",
               "ulanb\u00e1tarsk\u00fd \u010das",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "pakistansk\u00fd letn\u00fd \u010das",
               "",
               "pakistansk\u00fd \u010das",
               "",
            };
        final String[] Paraguay = new String[] {
               "paraguajsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "paraguajsk\u00fd letn\u00fd \u010das",
               "",
               "paraguajsk\u00fd \u010das",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u010das Pitcairnov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "sachalinsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "sachalinsk\u00fd letn\u00fd \u010das",
               "",
               "sachalinsk\u00fd \u010das",
               "",
            };
        final String[] Suriname = new String[] {
               "surinamsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argent\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "argent\u00ednsky letn\u00fd \u010das",
               "",
               "argent\u00ednsky \u010das",
               "",
            };
        final String[] Christmas = new String[] {
               "\u010das Viano\u010dn\u00e9ho ostrova",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "galap\u00e1gsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "hongkonsk\u00fd letn\u00fd \u010das",
               "",
               "hongkonsk\u00fd \u010das",
               "",
            };
        final String[] Indochina = new String[] {
               "indo\u010d\u00ednsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kam\u010datsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Petropavlovsk-Kam\u010datskijsk\u00fd letn\u00fd \u010das",
               "",
               "Petropavlovsk-Kam\u010datsk\u00fd \u010das",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "\u0161tandardn\u00fd \u010das ostrova lorda Howa",
               "",
               "letn\u00fd \u010das ostrova lorda Howa",
               "",
               "\u010das ostrova lorda Howa",
               "",
            };
        final String[] Macquarie = new String[] {
               "\u010das ostrova Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marquesas = new String[] {
               "mark\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "maur\u00edcijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "maur\u00edcijsk\u00fd letn\u00fd \u010das",
               "",
               "maur\u00edcijsk\u00fd \u010das",
               "",
            };
        final String[] Pyongyang = new String[] {
               "pchjongjansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Singapore = new String[] {
               "singapursk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajd\u017eansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "azerbajd\u017eansk\u00fd letn\u00fd \u010das",
               "",
               "azerbajd\u017eansk\u00fd \u010das",
               "",
            };
        final String[] Bangladesh = new String[] {
               "banglad\u00e9\u0161sky \u0161tandardn\u00fd \u010das",
               "",
               "banglad\u00e9\u0161sky letn\u00fd \u010das",
               "",
               "banglad\u00e9\u0161sky \u010das",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kapverdsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "kapverdsk\u00fd letn\u00fd \u010das",
               "",
               "kapverdsk\u00fd \u010das",
               "",
            };
        final String[] Choibalsan = new String[] {
               "\u010dojbalsansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "\u010dojbalsansk\u00fd letn\u00fd \u010das",
               "",
               "\u010dojbalsansk\u00fd \u010das",
               "",
            };
        final String[] East_Timor = new String[] {
               "v\u00fdchodotimorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tad\u017eick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbeck\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "uzbeck\u00fd letn\u00fd \u010das",
               "",
               "uzbeck\u00fd \u010das",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afgansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "krasnojarsk\u00fd letn\u00fd \u010das",
               "",
               "krasnojarsk\u00fd \u010das",
               "",
            };
        final String[] New_Zealand = new String[] {
               "novoz\u00e9landsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "novoz\u00e9landsk\u00fd letn\u00fd \u010das",
               "",
               "novoz\u00e9landsk\u00fd \u010das",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "novosibirsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "novosibirsk\u00fd letn\u00fd \u010das",
               "",
               "novosibirsk\u00fd \u010das",
               "",
            };
        final String[] Philippines = new String[] {
               "filip\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "filip\u00ednsky letn\u00fd \u010das",
               "",
               "filip\u00ednsky \u010das",
               "",
            };
        final String[] Vladivostok = new String[] {
               "vladivostock\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "vladivostock\u00fd letn\u00fd \u010das",
               "",
               "vladivostock\u00fd \u010das",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indickooce\u00e1nsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u010das Rovn\u00edkov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "newfoundlandsk\u00fd letn\u00fd \u010das",
               "",
               "newfoundlandsk\u00fd \u010das",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "turkm\u00e9nsky \u0161tandardn\u00fd \u010das",
               "",
               "turkm\u00e9nsky letn\u00fd \u010das",
               "",
               "turkm\u00e9nsky \u010das",
               "",
            };
        final String[] French_Guiana = new String[] {
               "franc\u00fazskoguyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "novokaled\u00f3nsky \u0161tandardn\u00fd \u010das",
               "",
               "novokaled\u00f3nsky letn\u00fd \u010das",
               "",
               "novokaled\u00f3nsky \u010das",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u010das Ju\u017enej Georgie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekaterinbursk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "jekaterinbursk\u00fd letn\u00fd \u010das",
               "",
               "jekaterinbursk\u00fd \u010das",
               "",
            };
        final String[] Africa_Central = new String[] {
               "stredoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "v\u00fdchodoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "z\u00e1padoafrick\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padoafrick\u00fd letn\u00fd \u010das",
               "",
               "z\u00e1padoafrick\u00fd \u010das",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "\u010das stanice Dumonta d\u2019Urvillea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "stredoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "SE\u010c",
               "stredoeur\u00f3psky letn\u00fd \u010das",
               "SEL\u010c",
               "stredoeur\u00f3psky \u010das",
               "SE\u010c",
            };
        final String[] Europe_Eastern = new String[] {
               "v\u00fdchodoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "",
               "v\u00fdchodoeur\u00f3psky letn\u00fd \u010das",
               "",
               "v\u00fdchodoeur\u00f3psky \u010das",
               "",
            };
        final String[] Europe_Western = new String[] {
               "z\u00e1padoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padoeur\u00f3psky letn\u00fd \u010das",
               "",
               "z\u00e1padoeur\u00f3psky \u010das",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexick\u00fd tichomorsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "mexick\u00fd tichomorsk\u00fd letn\u00fd \u010das",
               "",
               "mexick\u00fd tichomorsk\u00fd \u010das",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "juhoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "severoamerick\u00fd centr\u00e1lny \u0161tandardn\u00fd \u010das",
               "",
               "severoamerick\u00fd centr\u00e1lny letn\u00fd \u010das",
               "",
               "severoamerick\u00fd centr\u00e1lny \u010das",
               "",
            };
        final String[] America_Eastern = new String[] {
               "severoamerick\u00fd v\u00fdchodn\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "severoamerick\u00fd v\u00fdchodn\u00fd letn\u00fd \u010das",
               "",
               "severoamerick\u00fd v\u00fdchodn\u00fd \u010das",
               "",
            };
        final String[] America_Pacific = new String[] {
               "severoamerick\u00fd tichomorsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "severoamerick\u00fd tichomorsk\u00fd letn\u00fd \u010das",
               "",
               "severoamerick\u00fd tichomorsk\u00fd \u010das",
               "",
            };
        final String[] French_Southern = new String[] {
               "\u010das Franc\u00fazskych ju\u017en\u00fdch a antarktick\u00fdch \u00fazem\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010das Gilbertov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "havajsko-aleutsk\u00fd letn\u00fd \u010das",
               "",
               "havajsko-aleutsk\u00fd \u010das",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010das F\u00e9nixov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "pierre-miquelonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "pierre-miquelonsk\u00fd letn\u00fd \u010das",
               "",
               "pierre-miquelonsk\u00fd \u010das",
               "",
            };
        final String[] America_Mountain = new String[] {
               "severoamerick\u00fd horsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "severoamerick\u00fd horsk\u00fd letn\u00fd \u010das",
               "",
               "severoamerick\u00fd horsk\u00fd \u010das",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010das Marshallov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "severoz\u00e1padn\u00fd mexick\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "severoz\u00e1padn\u00fd mexick\u00fd letn\u00fd \u010das",
               "",
               "severoz\u00e1padn\u00fd mexick\u00fd \u010das",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u010das Papuy-Novej Guiney",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "z\u00e1padoargent\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padoargent\u00ednsky letn\u00fd \u010das",
               "",
               "z\u00e1padoargent\u00ednsky \u010das",
               "",
            };
        final String[] Australia_Central = new String[] {
               "stredoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "stredoaustr\u00e1lsky letn\u00fd \u010das",
               "",
               "stredoaustr\u00e1lsky \u010das",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "v\u00fdchodoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "v\u00fdchodoaustr\u00e1lsky letn\u00fd \u010das",
               "",
               "v\u00fdchodoaustr\u00e1lsky \u010das",
               "",
            };
        final String[] Australia_Western = new String[] {
               "z\u00e1padoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padoaustr\u00e1lsky letn\u00fd \u010das",
               "",
               "z\u00e1padoaustr\u00e1lsky \u010das",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "v\u00fdchodogr\u00f3nsky \u0161tandardn\u00fd \u010das",
               "",
               "v\u00fdchodogr\u00f3nsky letn\u00fd \u010das",
               "",
               "v\u00fdchodogr\u00f3nsky \u010das",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "z\u00e1padogr\u00f3nsky \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padogr\u00f3nsky letn\u00fd \u010das",
               "",
               "z\u00e1padogr\u00f3nsky \u010das",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "stredoindon\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "v\u00fdchodoindon\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "z\u00e1padoindon\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "v\u00fdchodokazachstansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "z\u00e1padokazachstansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "stredoz\u00e1padn\u00fd austr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "stredoz\u00e1padn\u00fd austr\u00e1lsky letn\u00fd \u010das",
               "",
               "stredoz\u00e1padn\u00fd austr\u00e1lsky \u010das",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EST", America_Eastern },
            { "HST",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "JST", Japan },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Eastern },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "",
                    "\u00edrsky \u0161tandardn\u00fd \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "",
                    "britsk\u00fd letn\u00fd \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Pacific },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Pyongyang },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "",
                    "britsk\u00fd letn\u00fd \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", Africa_Western },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Mountain },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Casey },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Pacific },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Chovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Ura\u013esk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Dh\u00e1ka" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Kabul", "K\u00e1bul" },
            { "timezone.excity.Asia/Macau", "Macao" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "timezone.excity.Asia/Beirut", "Bejr\u00fat" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Rij\u00e1d" },
            { "timezone.excity.Asia/Saigon", "Ho\u010diminovo Mesto" },
            { "timezone.excity.Asia/Taipei", "Tchaj-pej" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.Etc/Unknown", "nezn\u00e1me mesto" },
            { "timezone.excity.Europe/Kiev", "Kyjev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "R\u00edm" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Africa/Cairo", "K\u00e1hira" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "timezone.excity.Asia/Karachi", "Kar\u00e1\u010di" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "Nik\u00f3zia" },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Par\u00ed\u017e" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Kokosov\u00e9 ostrovy" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161chabad" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "timezone.excity.Asia/Katmandu", "K\u00e1thmandu" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "\u0160anghaj" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Asia/Ust-Nera", "Us\u0165-Nera" },
            { "timezone.excity.Europe/Athens", "At\u00e9ny" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Europe/London", "Lond\u00fdn" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viede\u0148" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1hreb" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.Africa/Algiers", "Al\u017e\u00edr" },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.America/Cayman", "Kajmanie ostrovy" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "Pchjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vientian" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Europe/Vatican", "Vatik\u00e1n" },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Easter", "Ve\u013ekono\u010dn\u00fd ostrov" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El-Aai\u00fan" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Chart\u00fam" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.Africa/Sao_Tome", "Sv\u00e4t\u00fd Tom\u00e1\u0161" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.America/Managua", "Managua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom P\u00e9nh" },
            { "timezone.excity.Atlantic/Azores", "Azory" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1rske ostrovy" },
            { "timezone.excity.Atlantic/Faeroe", "Faersk\u00e9 ostrovy" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "timezone.excity.Europe/Belgrade", "Belehrad" },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "timezone.excity.Europe/Budapest", "Budape\u0161\u0165" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161i\u0148ov" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017ehorod" },
            { "timezone.excity.Indian/Maldives", "Maldivy" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161o" },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/New_York", "New York" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "timezone.excity.America/St_Lucia", "Sv\u00e4t\u00e1 Lucia" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "\u0160\u00f3wa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanb\u00e1tar" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrach\u00e1n" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161\u0165" },
            { "timezone.excity.Europe/Gibraltar", "Gibralt\u00e1r" },
            { "timezone.excity.Europe/Ljubljana", "\u013dub\u013eana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "\u0160tokholm" },
            { "timezone.excity.Europe/Ulyanovsk", "U\u013ejanovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Indian/Christmas", "Viano\u010dn\u00fd ostrov" },
            { "timezone.excity.Indian/Kerguelen", "Kergueleny" },
            { "timezone.excity.Indian/Mauritius", "Maur\u00edcius" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Sv. Tom\u00e1\u0161" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzneck" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Koda\u0148" },
            { "timezone.excity.Europe/Luxembourg", "Luxembursko" },
            { "timezone.excity.Europe/San_Marino", "San Mar\u00edno" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Europe/Zaporozhye", "Z\u00e1poro\u017eie" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galap\u00e1gy" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Mark\u00e9zy" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "timezone.excity.America/St_Vincent", "Sv. Vincent" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Sv\u00e4t\u00e1 Helena" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrov Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "timezone.excity.America/El_Salvador", "Salv\u00e1dor" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Mexico_City", "M\u00e9xico" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapverdy" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Sv\u00e4t\u00fd Bartolomej" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "timezone.excity.Atlantic/South_Georgia", "Ju\u017en\u00e1 Georgia" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Severn\u00e1 Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Severn\u00e1 Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Severn\u00e1 Dakota" },
        };
        return data;
    }
}
