/*
 * Copyright (c) 2000, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.tools.javadoc;

import java.io.PrintWriter;

import com.sun.tools.javadoc.main.Start;

/**
 * Provides external entry points (tool and programmatic)
 * for the javadoc program.
 *
 *  <p><b>This is NOT part of any supported API.
 *  If you write code that depends on this, you do so at your own risk.
 *  This code and its internal interfaces are subject to change or
 *  deletion without notice.</b>
 *
 * @deprecated
 * This class is now deprecated and may be removed in a future release.
 * See
 * {@code javax.tools.ToolProvider::getSystemDocumentationTool}
 * and
 * {@code javax.tools.DocumentationTool}
 * for replacement functionality.
 *
 * @since 1.4
 */
@Deprecated(since="9", forRemoval=true)
@SuppressWarnings("removal")
public class Main {

    /**
     * Constructor should never be called.
     */
    private Main() {
    }

    /**
     * Command line interface.
     * @param args   The command line parameters.
     */
    public static void main(String... args) {
        System.exit(execute(args));
    }

    /**
     * Programmatic interface.
     * @param args   The command line parameters.
     * @return The return code.
     */
    public static int execute(String... args) {
        Start jdoc = new Start();
        return jdoc.begin(args);
    }

    /**
     * Programmatic interface.
     * @param args   The command line parameters.
     * @param docletParentClassLoader The parent class loader used when
     *  creating the doclet classloader. If null, the class loader used
     *  to instantiate doclets will be created without specifying a parent
     *  class loader.
     * @return The return code.
     * @since 1.7
     */
    public static int execute(ClassLoader docletParentClassLoader, String... args) {
        Start jdoc = new Start(docletParentClassLoader);
        return jdoc.begin(args);
    }

    /**
     * Programmatic interface.
     * @param programName  Name of the program (for error messages).
     * @param args   The command line parameters.
     * @return The return code.
     */
    public static int execute(String programName, String... args) {
        Start jdoc = new Start(programName);
        return jdoc.begin(args);
    }

    /**
     * Programmatic interface.
     * @param programName  Name of the program (for error messages).
     * @param args   The command line parameters.
     * @param docletParentClassLoader The parent class loader used when
     *  creating the doclet classloader. If null, the class loader used
     *  to instantiate doclets will be created without specifying a parent
     *  class loader.
     * @return The return code.
     * @since 1.7
     */
    public static int execute(String programName, ClassLoader docletParentClassLoader, String... args) {
        Start jdoc = new Start(programName, docletParentClassLoader);
        return jdoc.begin(args);
    }

    /**
     * Programmatic interface.
     * @param programName  Name of the program (for error messages).
     * @param defaultDocletClassName  Fully qualified class name.
     * @param args   The command line parameters.
     * @return The return code.
     */
    public static int execute(String programName,
                              String defaultDocletClassName,
                              String... args) {
        Start jdoc = new Start(programName, defaultDocletClassName);
        return jdoc.begin(args);
    }

    /**
     * Programmatic interface.
     * @param programName  Name of the program (for error messages).
     * @param defaultDocletClassName  Fully qualified class name.
     * @param docletParentClassLoader The parent class loader used when
     *  creating the doclet classloader. If null, the class loader used
     *  to instantiate doclets will be created without specifying a parent
     *  class loader.
     * @param args   The command line parameters.
     * @return The return code.
     * @since 1.7
     */
    public static int execute(String programName,
                              String defaultDocletClassName,
                              ClassLoader docletParentClassLoader,
                              String... args) {
        Start jdoc = new Start(programName, defaultDocletClassName, docletParentClassLoader);
        return jdoc.begin(args);
    }

    /**
     * Programmatic interface.
     * @param programName  Name of the program (for error messages).
     * @param errWriter    PrintWriter to receive error messages.
     * @param warnWriter    PrintWriter to receive error messages.
     * @param noticeWriter    PrintWriter to receive error messages.
     * @param defaultDocletClassName  Fully qualified class name.
     * @param args   The command line parameters.
     * @return The return code.
     */
    public static int execute(String programName,
                              PrintWriter errWriter,
                              PrintWriter warnWriter,
                              PrintWriter noticeWriter,
                              String defaultDocletClassName,
                              String... args) {
        Start jdoc = new Start(programName,
                               errWriter, warnWriter, noticeWriter,
                               defaultDocletClassName);
        return jdoc.begin(args);
    }

    /**
     * Programmatic interface.
     * @param programName  Name of the program (for error messages).
     * @param errWriter    PrintWriter to receive error messages.
     * @param warnWriter    PrintWriter to receive error messages.
     * @param noticeWriter    PrintWriter to receive error messages.
     * @param defaultDocletClassName  Fully qualified class name.
     * @param docletParentClassLoader The parent class loader used when
     *  creating the doclet classloader. If null, the class loader used
     *  to instantiate doclets will be created without specifying a parent
     *  class loader.
     * @param args   The command line parameters.
     * @return The return code.
     * @since 1.7
     */
    public static int execute(String programName,
                              PrintWriter errWriter,
                              PrintWriter warnWriter,
                              PrintWriter noticeWriter,
                              String defaultDocletClassName,
                              ClassLoader docletParentClassLoader,
                              String... args) {
        Start jdoc = new Start(programName,
                               errWriter, warnWriter, noticeWriter,
                               defaultDocletClassName,
                               docletParentClassLoader);
        return jdoc.begin(args);
    }
}
