/**
 * Copyright 2007 Adobe Systems Incorporated
 * All Rights Reserved.
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
*/

package coldfusion.print;

import org.jpedal.objects.PrinterOptions;

/**
 * PrintPDFAttributes
 * <p/>
 * Created on Jan 21, 2007
 *
 * @author cframpto
 */
public class PrintPDFAttributes
{

    private boolean autoRotateAndCenter = true;
    private boolean usePdfPageSize = false;
    private int pageScaling = PrinterOptions.PAGE_SCALING_REDUCE_TO_PRINTER_MARGINS;
    
    // these are a bit mask
    private int pageMode = PrinterOptions.ALL_PAGES;
    
    public boolean isAutoRotateAndCenter()
    {
        return autoRotateAndCenter;
    }

    public void setAutoRotateAndCenter(boolean isAutoRotateAndCenter)
    {
        this.autoRotateAndCenter = isAutoRotateAndCenter;
    }

    public boolean isUsePdfPageSize()
    {
        return usePdfPageSize;
    }

    public void setUsePdfPageSize(boolean isUsePdfPaperSize)
    {
        this.usePdfPageSize = isUsePdfPaperSize;
    }
 
    public int getPageScaling()
    {
        return pageScaling;
    }

    final private static String PAGE_SCALING_NONE = "none";
    final private static String PAGE_SCALING_FIT_TO_PRINTER_MARGINS = "fit-to-printer-margins";
    final private static String PAGE_SCALING_REDUCE_TO_PRINTER_MARGINS = "reduce-to-printer-margins";

    public boolean setPageScaling(String pageScaling)
    {
        if (pageScaling != null)
        {
            if (pageScaling.equalsIgnoreCase(PAGE_SCALING_NONE))
            {
                this.pageScaling = PrinterOptions.PAGE_SCALING_NONE;
                return true;
            }
            
            if (pageScaling.equalsIgnoreCase(PAGE_SCALING_FIT_TO_PRINTER_MARGINS))
            {
                this.pageScaling = PrinterOptions.PAGE_SCALING_FIT_TO_PRINTER_MARGINS;
                return true;
            }
            
            if (pageScaling.equalsIgnoreCase(PAGE_SCALING_REDUCE_TO_PRINTER_MARGINS))
            {
                this.pageScaling = PrinterOptions.PAGE_SCALING_REDUCE_TO_PRINTER_MARGINS;
                return true;
            }
        }

        return false;
    }

    public String getPageScalingValues()
    {
        return PAGE_SCALING_NONE + "," + PAGE_SCALING_FIT_TO_PRINTER_MARGINS + "," + PAGE_SCALING_REDUCE_TO_PRINTER_MARGINS;
    }

    public int getPageSubset()
    {
        return pageMode & ~PrinterOptions.PRINT_PAGES_REVERSED;
    }

    final static String ALL_PAGES = "all";	
    final static String ODD_PAGES_ONLY = "odd";	
    final static String EVEN_PAGES_ONLY = "even";
    
    public boolean setPageSubset(String pageSubset)
    {
        if (pageSubset != null)
        {
            if (pageSubset.equalsIgnoreCase(ALL_PAGES))
            {
                this.pageMode = PrinterOptions.ALL_PAGES | (this.pageMode & PrinterOptions.PRINT_PAGES_REVERSED);
                return true;
            }
            
            if (pageSubset.equalsIgnoreCase(ODD_PAGES_ONLY))
            {
                this.pageMode = PrinterOptions.ODD_PAGES_ONLY | (this.pageMode & PrinterOptions.PRINT_PAGES_REVERSED);
                return true;
            }
            
            if (pageSubset.equalsIgnoreCase(EVEN_PAGES_ONLY))
            {
                this.pageMode = PrinterOptions.EVEN_PAGES_ONLY | (this.pageMode & PrinterOptions.PRINT_PAGES_REVERSED);
                return true;
            }
        }

        return false;
    }

    public String getPageSubsetValues()
    {
        return ALL_PAGES + "," + ODD_PAGES_ONLY + "," + EVEN_PAGES_ONLY;
    }

    public boolean isOddPagesOnly()
    {
        return  (this.pageMode & PrinterOptions.ODD_PAGES_ONLY) == PrinterOptions.ODD_PAGES_ONLY;
    }
    
    public boolean isEvenPagesOnly()
    {
        return  (this.pageMode & PrinterOptions.EVEN_PAGES_ONLY) == PrinterOptions.EVEN_PAGES_ONLY;
    }

    public boolean isReversePages()
    {
        return (this.pageMode & PrinterOptions.PRINT_PAGES_REVERSED) == PrinterOptions.PRINT_PAGES_REVERSED;
    }

    public void setReversePages(boolean reversePages)
    {
        this.pageMode |= PrinterOptions.PRINT_PAGES_REVERSED;
    }  
    
    public int getPageMode()
    {
        return this.pageMode;
    }  
}
