package coldfusion.print;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

import coldfusion.osgi.services.PrintService;
import coldfusion.server.felix.FelixConstants;
import coldfusion.server.felix.FelixUtil;


public class PrintServiceActivator implements BundleActivator {
	private ServiceRegistration serviceReg;
	private String bundleName = FelixConstants.PRINT_BUNDLE;

	public void start(BundleContext context) {
		serviceReg = FelixUtil.startBundle(context, bundleName,
				PrintService.class.getName(), new PrintServiceImpl(), null);

	}

	public void stop(BundleContext context) {
		FelixUtil.stopBundle(bundleName, context, serviceReg);
	}

}