var NODE_ELEMENT = 1;
var NODE_TEXT = 2;
function JNode(parent, xmlText) {
    var tempType = NODE_ELEMENT;
    var tempParent = parent;
    var tempName = "";
    var tempAtrMap = {};
    var children = new Array();
    var arr = new Array();
    if (!isEmpty(xmlText)) {
        xmlText = removeComments(xmlText);
        xmlText = removeCDATA(xmlText);
        xmlText = removeDocType(xmlText);
        xmlText = removePI(xmlText);
        xmlText = removeSpaceBetweenNodes(xmlText);
        xmlText = xmlText.trim();
        tempType = xmlText.indexOf("<") === 0 ? NODE_ELEMENT : NODE_TEXT;
        tempName = getNameFromXML(xmlText);
        tempAtrMap = getAttributeMap(xmlText);
        arr = getChildrenArrayFromXML(xmlText);
        for (var z = 0; z < arr.length; z++) {
            children[children.length] = new JNode(this, arr[z]);
        }
        for (var z = 0; z < children.length; z++) {
            var childNode = children[z];
            var childName = childNode.nodeName;
            if (childNode.nodeType === NODE_ELEMENT) {
                if (childName in this) {
                    if (this[childName] instanceof Array) {
                        var cArr = this[childName];
                        cArr[cArr.length] = childNode;
                        Object.defineProperty(this, childName, {
                            value: cArr,
                            writable: true,
                            enumerable: true,
                            configurable: true
                        });
                    } else {
                        var cArr = new Array();
                        cArr[0] = this[childName];
                        cArr[1] = childNode;
                        Object.defineProperty(this, childName, {
                            value: cArr,
                            writable: true,
                            enumerable: true,
                            configurable: true
                        });
                    }
                } else {
                    Object.defineProperty(this, childName, {
                        value: childNode,
                        writable: true,
                        enumerable: true,
                        configurable: true
                    });
                }
            }
        }
    }

    Object.defineProperty(this, "parent", {
        get: function () {
            return tempParent;
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "nodeType", {
        get: function () {
            return tempType;
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "nodeValue", {
        get: function () {
            return xmlText;
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "nodeName", {
        get: function () {
            return tempName;
        }, set: function (newValue) {
            tempName = newValue;
        }, configurable: true, enumerable: true
    });
    //define child methods
    Object.defineProperty(this, "childNodes", {
        get: function () {
            return children;
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "append", {
        value: function (newNode) {
            children[children.length] = newNode;
            if (newNode.nodeType === NODE_ELEMENT) {
                var nn = newNode.nodeName;
                if (nn in this) {
                    var previous = this[nn];
                    if (previous instanceof Array) {
                        previous[previous.length] = newNode;
                    } else {
                        var arr = new Array();
                        arr[0] = previous;
                        arr[1] = newNode;
                        Object.defineProperty(this, nn, {
                            value: arr,
                            writable: true,
                            enumerable: true,
                            configurable: true
                        });
                    }
                } else {
                    Object.defineProperty(this, nn, {
                        value: newNode,
                        writable: true,
                        enumerable: true,
                        configurable: true
                    });
                }
            }
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "remove", {
        value: function (inputNode) {
            var name = inputNode.nodeName;
            if (name in this) {
                if (this[name] instanceof Array) {
                    for (var i = 0; i < this[name].length; i++) {
                        if (this[name][i] === inputNode) {
                            this[name].splice(i, 1);
                        }
                    }
                    if (this[name].length === 0) {
                        delete this[name];
                    }
                    else if (this[name].length === 1) {
                        Object.defineProperty(this, name, {
                            value: this[name][0],
                            writable: true,
                            enumerable: true,
                            configurable: true
                        });
                    }
                } else {
                    delete this[name];
                }
            }
            for (var i = children.length; i--;) {
                if (children[i] === inputNode) {
                    children.splice(i, 1);
                }
            }
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "removeAllChildren", {
        value: function () {
            for (var z = 0; z < children.length; z++) {
                if (children[z].nodeType === NODE_ELEMENT) {
                    delete this[children[z].nodeName];
                }
            }
            children = new Array();
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "clone", {
        value: function (isRecursive) {
            var n = new JNode(this.parent, this.getXML());
            return n;
        }, configurable: true, enumerable: true, writable: true
    });
    //define attribute methods
    Object.defineProperty(this, "getAttribute", {
        value: function (atrName) {
            if (atrName in tempAtrMap) {
                return tempAtrMap[atrName];
            } else {
                return "";
            }
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "getAttributeNames", {
        value: function () {
            var names = "";
            for (var key in tempAtrMap) {
                names = names + key + " ";
            }
            return names;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "getAttributeMap", {
        value: function () {
            return tempAtrMap;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "setAttribute", {
        value: function (atrName, atrValue) {
            if (!isEmpty(atrName) && !isEmpty(atrValue)) {
                tempAtrMap[atrName] = atrValue;
            }
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "removeAttribute", {
        value: function (stringParam) {
            delete tempAtrMap[stringParam];
        }, configurable: true, enumerable: true, writable: true
    });
    //define xml method
    Object.defineProperty(this, "getXML", {
        value: function () {
            return getXMLData(this);
        }, configurable: true, enumerable: true, writable: true
    });
    //list class related properties
    Object.defineProperty(this, "length", {
        get: function () {
            return this.childNodes.length;
        }, configurable: true, enumerable: true
    });
    //list class related methods
    Object.defineProperty(this, "insert", {
        value: function (newNode, beforeNode) {
            //implement later
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "item", {
        value: function (intParam) {
            return this.childNodes[intParam];
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "remove", {
        value: function (objParam) {
            //implement later
        }, configurable: true, enumerable: true, writable: true
    });
    //tree class related properties
    Object.defineProperty(this, "all", {
        get: function () {
            var xNodeArr = new Array();
            var curName = tempName;
            if (this.nodeType === NODE_ELEMENT && curName.length > 0) {
                for (var z = 0; z < this.childNodes.length; z++) {
                    var t = this.childNodes[z];
                    var foundName = t.nodeName;
                    if (foundName === curName) {
                        xNodeArr[xNodeArr.length] = t;
                    }
                }
            }
            return xNodeArr;
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "classAll", {
        get: function () {
            var xNodeArr = new Array();
            var curName = getAttribute("className");
            if (this.nodeType === NODE_ELEMENT && curName.length > 0) {
                for (var z = 0; z < this.childNodes.length; z++) {
                    var t = this.childNodes[z];
                    var classAtr = t.getAttribute("clasName");
                    if (classAtr !== null && classAtr === curName) {
                        xNodeArr[xNodeArr.length] = t;
                    }
                }
            }
            return xNodeArr;
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "classIndex", {
        get: function () {
            return 0; //implement later
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "index", {
        get: function () {
            return this.getAttribute("index"); //implement later
        }, set: function (newValue) {
            setAttribute("index", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "name", {
        get: function () {
            return this.getAttribute("name");
        }, set: function (newValue) {
            this.setAttribute("name", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "nodes", {
        get: function () {
            return this.childNodes;
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "getElementsByTagName", {
        value: function (name) {
            return getElementsByTagName(this, name);
        }, configurable: true, enumerable: true, writable: true
    });
    //tree class related methods
    Object.defineProperty(this, "resolveNode", {
        value: function (stringParam) {
            var strArr = stringParam.split(".");
            var tempNode = this;
            for (var z = 0; z < strArr.length; z++) {
                var val = strArr[z].replace(/[#]+/, '');
                var searchInt = 0;
                if (val.indexOf("[") !== -1) {
                    var searchStr = val.substring(val.indexOf("[") + 1, val.length - 1);
                    val = val.substring(0, val.indexOf("["));
                    searchInt = parseInt(searchStr);
                }
                tempNode = tempNode.getElementsByTagName(val)[searchInt];
            }
            return tempNode;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "resolveNodes", {
        value: function (stringParam) {
            var strArr = stringParam.split(".");
            var tempNode = this;
            for (var z = 0; z < strArr.length; z++) {
                var val = strArr[z].replace(/[#]+/, '');
                var searchInt = 0;
                if (val.indexOf("[") !== -1) {
                    var searchStr = val.substring(val.indexOf("[") + 1, val.length - 1);
                    val = val.substring(0, val.indexOf("["));
                    searchInt = parseInt(searchStr);
                }
                tempNode = tempNode.getElementsByTagName(val)[searchInt];
            }
            return tempNode;
        }, configurable: true, enumerable: true, writable: true
    });
    //nodeClass related properties
    Object.defineProperty(this, "id", {
        get: function () {
            return this.getAttribute("id");
        }, set: function (newValue) {
            this.setAttribute("id", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "isContainer", {
        get: function () {
            var cName = this.getAttribute("className");
            if (cName !== null && cName.length > 0) {
                if (cName === "subform" || cName === "subformSet" || cName === "area" || cName === "exclGroup") {
                    return true;
                }
            }
            return false;
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "isNull", {
        get: function () {
            var rawValue = this.getAttribute("rawValue");
            return (rawValue !== null && rawValue.lenght > 0);
        }, set: function (newValue) {
            this.setAttribute("isNull", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "model", {
        get: function () {
            return this.getAttribute("model");
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "ns", {
        get: function () {
            return this.getAttribute("ns");
        }, set: function (newValue) {
            this.setAttribute("ns", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "oneOfChild", {
        get: function () {
            return this.getAttribute("oneOfChild"); //implement later
        }, set: function (newValue) {
            this.setAttribute("oneOfChild", newValue);
        }, configurable: true, enumerable: true
    });
    //nodeClass related methods
    Object.defineProperty(this, "applyXSL", {
        value: function (stringParam) {
            return stringParam; // implement later
        }, configurable: true, enumerable: true, writable: true
    });
    this.assignNode = arity(function (args) {
        //implement later;
    });
    this.getElement = arity(function (args) {
        //implement later;
    });
    this.isPropertySpecified = arity(function (args) {
        return (this.getAttribute(args[0]).length > 0);
    });
    this.loadXML = arity(function (args) {
        //implement later
    });
    this.saveFilteredXML = arity(function (args) {
        //implement later
    });
    Object.defineProperty(this, "saveXML", {
        value: function () {
            return this.getXML();
        }, configurable: true, enumerable: true, writable: true
    });
    this.setElement = arity(function (args) {
        //implement later;
    });
    //Field related properties
    Object.defineProperty(this, "access", {
        get: function () {
            return this.getAttribute("access");
        }, set: function (newValue) {
            this.setAttribute("access", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "accessKey", {
        get: function () {
            return this.getAttribute("accessKey");
        }, set: function (newValue) {
            this.setAttribute("accessKey", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "anchorType", {
        get: function () {
            return this.getAttribute("anchorType");
        }, set: function (newValue) {
            this.setAttribute("anchorType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "borderColor", {
        get: function () {
            return this.getAttribute("borderColor");
        }, set: function (newValue) {
            this.setAttribute("borderColor", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "borderWidth", {
        get: function () {
            return this.getAttribute("borderWidth");
        }, set: function (newValue) {
            this.setAttribute("borderWidth", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "colSpan", {
        get: function () {
            return this.getAttribute("colSpan");
        }, set: function (newValue) {
            this.setAttribute("colSpan", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "editValue", {
        get: function () {
            return this.getAttribute("editValue");
        }, set: function (newValue) {
            this.setAttribute("editValue", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "fillColor", {
        get: function () {
            return this.getAttribute("fillColor");
        }, set: function (newValue) {
            this.setAttribute("fillColor", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "fontColor", {
        get: function () {
            return this.getAttribute("fontColor");
        }, set: function (newValue) {
            this.setAttribute("fontColor", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "formatMessage", {
        get: function () {
            return this.getAttribute("formatMessage");
        }, set: function (newValue) {
            this.setAttribute("formatMessage", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "formattedValue", {
        get: function () {
            return this.getAttribute("formattedValue");
        }, set: function (newValue) {
            this.setAttribute("formattedValue", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "h", {
        get: function () {
            return this.getAttribute("h");
        }, set: function (newValue) {
            this.setAttribute("h", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "hAlign", {
        get: function () {
            return this.getAttribute("hAlign");
        }, set: function (newValue) {
            this.setAttribute("hAlign", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "locale", {
        get: function () {
            return this.getAttribute("locale");
        }, set: function (newValue) {
            this.setAttribute("locale", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "mandatory", {
        get: function () {
            return this.getAttribute("mandatory");
        }, set: function (newValue) {
            this.setAttribute("mandatory", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "mandatoryMessage", {
        get: function () {
            return this.getAttribute("mandatoryMessage");
        }, set: function (newValue) {
            this.setAttribute("mandatoryMessage", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "maxH", {
        get: function () {
            return this.getAttribute("maxH");
        }, set: function (newValue) {
            this.setAttribute("maxH", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "maxW", {
        get: function () {
            return this.getAttribute("maxW");
        }, set: function (newValue) {
            this.setAttribute("maxW", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "minH", {
        get: function () {
            return this.getAttribute("minH");
        }, set: function (newValue) {
            this.setAttribute("minH", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "minW", {
        get: function () {
            return this.getAttribute("minW");
        }, set: function (newValue) {
            this.setAttribute("minW", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "parentSubform", {
        get: function () {
            return this.getAttribute("parentSubform");
        }, set: function (newValue) {
            this.setAttribute("parentSubform", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "presence", {
        get: function () {
            return this.getAttribute("presence");
        }, set: function (newValue) {
            this.setAttribute("presence", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "rawValue", {
        get: function () {
            return this.getAttribute("rawValue");
        }, set: function (newValue) {
            this.setAttribute("rawValue", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "relevant", {
        get: function () {
            return this.getAttribute("relevant");
        }, set: function (newValue) {
            this.setAttribute("relevant", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "rotate", {
        get: function () {
            return this.getAttribute("rotate");
        }, set: function (newValue) {
            this.setAttribute("rotate", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "selectedIndex", {
        get: function () {
            return this.getAttribute("selectedIndex");
        }, set: function (newValue) {
            this.setAttribute("selectedIndex", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "use", {
        get: function () {
            return this.getAttribute("use");
        }, set: function (newValue) {
            this.setAttribute("use", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "usehref", {
        get: function () {
            return this.getAttribute("usehref");
        }, set: function (newValue) {
            this.setAttribute("usehref", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "validationMessage", {
        get: function () {
            return this.getAttribute("validationMessage");
        }, set: function (newValue) {
            this.setAttribute("validationMessage", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "vAlign", {
        get: function () {
            return this.getAttribute("vAlign");
        }, set: function (newValue) {
            this.setAttribute("vAlign", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "w", {
        get: function () {
            return this.getAttribute("w");
        }, set: function (newValue) {
            this.setAttribute("w", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "x", {
        get: function () {
            return this.getAttribute("x");
        }, set: function (newValue) {
            this.setAttribute("x", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "y", {
        get: function () {
            return this.getAttribute("y");
        }, set: function (newValue) {
            this.setAttribute("y", newValue);
        }, configurable: true, enumerable: true
    });
    //Field related methods

    this.addItem = arity(function (args) {
        var hasItemsNode = false;
        for (var z = 0; z < this.childNodes.length; z++) {
            var child = this.childNodes[z];
            if (child.nodeName === "items" && !hasItemsNode) {
                hasItemsNode = true;
                var t = new JNode(child, "<text>" + args[0] + "</text>");
                child.append(t);
            }
        }
        if (!hasItemsNode) {
            var t = new JNode(this, "<items><text>" + args[0] + "</text></items>");
            this.append(t);
        }

        if (args.length === 2) {
            var firstItemFound = false;
            var secondItemFound = false;
            for (var z = 0; z < this.childNodes.length; z++) {
                var child = this.childNodes[z];
                if (child.nodeName === "items") {
                    if (!firstItemFound) {
                        firstItemFound = true;
                    } else {
                        secondItemFound = true;
                        var t = new JNode(child, "<text>" + args[1] + "</text>");
                        child.append(t);
                    }
                }
            }
            if (!secondItemFound) {
                var t = new JNode(this, "<items><text>" + args[1] + "</text></items>");
                this.append(t);
            }
        }
    });
    Object.defineProperty(this, "boundItem", {
        value: function (stringParam) {
            var itemCount = 0;
            var boundArr = new Array();
            var findPos = -1;
            for (var z = 0; z < this.childNodes.length; z++) {
                var child = this.childNodes[z];
                if (child.nodeName === "items") {
                    if (itemCount === 0) {
                        var counter = 0;
                        for (var i = 0; i < child.childNodes.length; i++) {
                            var itemChild = child.childNodes[i];
                            if (itemChild.nodeType === NODE_ELEMENT) {
                                if (itemChild.getXML() === stringParam) {
                                    findPos = counter;
                                }
                                counter++;
                            }
                        }
                    } else {
                        var temp = 0;
                        for (var i = 0; i < child.childNodes.length; i++) {
                            var itemChild = child.childNodes[i];
                            if (itemChild.nodeType === NODE_ELEMENT) {
                                boundArr[temp] = itemChild.getXML();
                                temp++;
                            }
                        }
                    }
                    itemCount++;
                }
            }
            if (findPos !== -1) {
                return boundArr[findPos];
            }
            return stringParam;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "clearItems", {
        value: function () {
            for (var z = 0; z < this.childNodes.length; z++) {
                var child = this.childNodes[z];
                if (child.nodeName === "items") {
                    child.removeAllChildren();
                }
            }
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "deleteItem", {
        value: function (intParam) {
            for (var z = 0; z < this.childNodes.length; z++) {
                var child = this.childNodes[z];
                if (child.nodeName === "items") {
                    var counter = 0;
                    for (var i = 0; i < child.childNodes.length; i++) {
                        var itemChild = child.childNodes[i];
                        if (itemChild.nodeType === NODE_ELEMENT) {
                            if (counter === intParam) {
                                child.remove(itemChild);
                                return;
                            }
                            counter++;
                        }
                    }
                }
            }
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "execCalculate", {
        value: function () {
            //implement later;
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "execEvent", {
        value: function (stringParam) {
            //implement later
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "execInitialize", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "execValidate", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "getDisplayItem", {
        value: function (intParam) {
            return; //implement later
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "getItemState", {
        value: function (intParam) {
            return false;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "getSaveItem", {
        value: function (intParam) {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "setItemState", {
        value: function (intParam, boolParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    //define object properties
    Object.defineProperty(this, "action", {
        get: function () {
            return this.getAttribute("action");
        }, set: function (newValue) {
            this.setAttribute("action", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "activity", {
        get: function () {
            return this.getAttribute("activity");
        }, set: function (newValue) {
            this.setAttribute("activity", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "addRevocationInfo", {
        get: function () {
            return this.getAttribute("addRevocationInfo");
        }, set: function (newValue) {
            this.setAttribute("addRevocationInfo", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "after", {
        get: function () {
            return this.getAttribute("after");
        }, set: function (newValue) {
            this.setAttribute("after", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "afterTarget", {
        get: function () {
            return this.getAttribute("afterTarget");
        }, set: function (newValue) {
            this.setAttribute("afterTarget", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "aliasNode", {
        get: function () {
            return this.getAttribute("aliasNode");
        }, set: function (newValue) {
            this.setAttribute("aliasNode", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "allowMacro", {
        get: function () {
            return this.getAttribute("allowMacro");
        }, set: function (newValue) {
            this.setAttribute("allowMacro", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "allowNeutral", {
        get: function () {
            return this.getAttribute("allowNeutral");
        }, set: function (newValue) {
            this.setAttribute("allowNeutral", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "allowRichText", {
        get: function () {
            return this.getAttribute("allowRichText");
        }, set: function (newValue) {
            this.setAttribute("allowRichText", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "appType", {
        get: function () {
            return this.getAttribute("appType");
        }, set: function (newValue) {
            this.setAttribute("appType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "archive", {
        get: function () {
            return this.getAttribute("archive");
        }, set: function (newValue) {
            this.setAttribute("archive", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "aspect", {
        get: function () {
            return this.getAttribute("aspect");
        }, set: function (newValue) {
            this.setAttribute("aspect", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "baselineShift", {
        get: function () {
            return this.getAttribute("baselineShift");
        }, set: function (newValue) {
            this.setAttribute("baselineShift", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "before", {
        get: function () {
            return this.getAttribute("before");
        }, set: function (newValue) {
            this.setAttribute("before", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "beforeTarget", {
        get: function () {
            return this.getAttribute("beforeTarget");
        }, set: function (newValue) {
            this.setAttribute("beforeTarget", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "bind", {
        get: function () {
            return this.getAttribute("bind");
        }, set: function (newValue) {
            this.setAttribute("bind", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "binding", {
        get: function () {
            return this.getAttribute("binding");
        }, set: function (newValue) {
            this.setAttribute("binding", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "blank", {
        get: function () {
            return this.getAttribute("blank");
        }, set: function (newValue) {
            this.setAttribute("blank", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "blankOrNotBlank", {
        get: function () {
            return this.getAttribute("blankOrNotBlank");
        }, set: function (newValue) {
            this.setAttribute("blankOrNotBlank", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "bofAction", {
        get: function () {
            return this.getAttribute("bofAction");
        }, set: function (newValue) {
            this.setAttribute("bofAction", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "bookendLeader", {
        get: function () {
            return this.getAttribute("bookendLeader");
        }, set: function (newValue) {
            this.setAttribute("bookendLeader", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "bookendTrailer", {
        get: function () {
            return this.getAttribute("bookendTrailer");
        }, set: function (newValue) {
            this.setAttribute("bookendTrailer", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "bottomInset", {
        get: function () {
            return this.getAttribute("bottomInset");
        }, set: function (newValue) {
            this.setAttribute("bottomInset", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "break", {
        get: function () {
            return this.getAttribute("break");
        }, set: function (newValue) {
            this.setAttribute("break", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "calculationsEnabled", {
        get: function () {
            return this.getAttribute("calculationsEnabled");
        }, set: function (newValue) {
            this.setAttribute("calculationsEnabled", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "cap", {
        get: function () {
            return this.getAttribute("cap");
        }, set: function (newValue) {
            this.setAttribute("cap", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "change", {
        get: function () {
            return this.getAttribute("change");
        }, set: function (newValue) {
            this.setAttribute("change", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "charEncoding", {
        get: function () {
            return this.getAttribute("charEncoding");
        }, set: function (newValue) {
            this.setAttribute("charEncoding", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "checksum", {
        get: function () {
            return this.getAttribute("checksum");
        }, set: function (newValue) {
            this.setAttribute("checksum", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "circular", {
        get: function () {
            return this.getAttribute("circular");
        }, set: function (newValue) {
            this.setAttribute("circular", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "classId", {
        get: function () {
            return this.getAttribute("classId");
        }, set: function (newValue) {
            this.setAttribute("classId", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "className", {
        get: function () {
            return this.getAttribute("className");
        }, set: function (newValue) {
            setAttribute("className", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "codeBase", {
        get: function () {
            return this.getAttribute("codeBase");
        }, set: function (newValue) {
            this.setAttribute("codeBase", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "codeType", {
        get: function () {
            return this.getAttribute("codeType");
        }, set: function (newValue) {
            this.setAttribute("codeType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "columnWidths", {
        get: function () {
            return this.getAttribute("columnWidths");
        }, set: function (newValue) {
            this.setAttribute("columnWidths", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "commandType", {
        get: function () {
            return this.getAttribute("commandType");
        }, set: function (newValue) {
            this.setAttribute("commandType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "commitKey", {
        get: function () {
            return this.getAttribute("commitKey");
        }, set: function (newValue) {
            this.setAttribute("commitKey", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "commitOn", {
        get: function () {
            return this.getAttribute("commitOn");
        }, set: function (newValue) {
            this.setAttribute("commitOn", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "connection", {
        get: function () {
            return this.getAttribute("connection");
        }, set: function (newValue) {
            this.setAttribute("connection", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "contains", {
        get: function () {
            return this.getAttribute("contains");
        }, set: function (newValue) {
            this.setAttribute("contains", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "content", {
        get: function () {
            return this.getAttribute("content");
        }, set: function (newValue) {
            this.setAttribute("content", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "contentType", {
        get: function () {
            return this.getAttribute("contentType");
        }, set: function (newValue) {
            this.setAttribute("contentType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "context", {
        get: function () {
            return this.getAttribute("context");
        }, set: function (newValue) {
            this.setAttribute("context", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "count", {
        get: function () {
            return this.getAttribute("count");
        }, set: function (newValue) {
            this.setAttribute("count", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "credentialServerPolicy", {
        get: function () {
            return this.getAttribute("credentialServerPolicy");
        }, set: function (newValue) {
            this.setAttribute("credentialServerPolicy", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "crlSign", {
        get: function () {
            return this.getAttribute("crlSign");
        }, set: function (newValue) {
            this.setAttribute("crlSign", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "cSpace", {
        get: function () {
            return this.getAttribute("cSpace");
        }, set: function (newValue) {
            this.setAttribute("cSpace", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "currentPage", {
        get: function () {
            return this.getAttribute("currentPage");
        }, set: function (newValue) {
            this.setAttribute("currentPage", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "currentRecordNumber", {
        get: function () {
            return this.getAttribute("currentRecordNumber");
        }, set: function (newValue) {
            this.setAttribute("currentRecordNumber", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "currentValue", {
        get: function () {
            return this.getAttribute("currentValue");
        }, set: function (newValue) {
            this.setAttribute("currentValue", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "cursorLocation", {
        get: function () {
            return this.getAttribute("cursorLocation");
        }, set: function (newValue) {
            this.setAttribute("cursorLocation", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "cursorType", {
        get: function () {
            return this.getAttribute("cursorType");
        }, set: function (newValue) {
            this.setAttribute("cursorType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "data", {
        get: function () {
            return this.getAttribute("data");
        }, set: function (newValue) {
            this.setAttribute("data", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "dataColumnCount", {
        get: function () {
            return this.getAttribute("dataColumnCount");
        }, set: function (newValue) {
            this.setAttribute("dataColumnCount", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "dataDescription", {
        get: function () {
            return this.getAttribute("dataDescription");
        }, set: function (newValue) {
            this.setAttribute("dataDescription", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "dataEncipherment", {
        get: function () {
            return this.getAttribute("dataEncipherment");
        }, set: function (newValue) {
            this.setAttribute("dataEncipherment", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "dataLength", {
        get: function () {
            return this.getAttribute("dataLength");
        }, set: function (newValue) {
            this.setAttribute("dataLength", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "dataPrep", {
        get: function () {
            return this.getAttribute("dataPrep");
        }, set: function (newValue) {
            this.setAttribute("dataPrep", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "dataRowCount", {
        get: function () {
            return this.getAttribute("dataRowCount");
        }, set: function (newValue) {
            this.setAttribute("dataRowCount", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "db", {
        get: function () {
            return this.getAttribute("db");
        }, set: function (newValue) {
            this.setAttribute("db", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "decipherOnly", {
        get: function () {
            return this.getAttribute("decipherOnly");
        }, set: function (newValue) {
            this.setAttribute("decipherOnly", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "delayedOpen", {
        get: function () {
            return this.getAttribute("delayedOpen");
        }, set: function (newValue) {
            this.setAttribute("delayedOpen", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "delimiter", {
        get: function () {
            return this.getAttribute("delimiter");
        }, set: function (newValue) {
            this.setAttribute("delimiter", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "digitalSignature", {
        get: function () {
            return this.getAttribute("digitalSignature");
        }, set: function (newValue) {
            this.setAttribute("digitalSignature", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "disable", {
        get: function () {
            return this.getAttribute("disable");
        }, set: function (newValue) {
            this.setAttribute("disable", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "embedPDF", {
        get: function () {
            return this.getAttribute("embedPDF");
        }, set: function (newValue) {
            this.setAttribute("embedPDF", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "encipherOnly", {
        get: function () {
            return this.getAttribute("encipherOnly");
        }, set: function (newValue) {
            this.setAttribute("encipherOnly", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "endChar", {
        get: function () {
            return this.getAttribute("endChar");
        }, set: function (newValue) {
            this.setAttribute("endChar", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "eofAction", {
        get: function () {
            return this.getAttribute("eofAction");
        }, set: function (newValue) {
            this.setAttribute("eofAction", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "errorCorrectionLevel", {
        get: function () {
            return this.getAttribute("errorCorrectionLevel");
        }, set: function (newValue) {
            this.setAttribute("errorCorrectionLevel", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "executeType", {
        get: function () {
            return this.getAttribute("executeType");
        }, set: function (newValue) {
            this.setAttribute("executeType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "format", {
        get: function () {
            return this.getAttribute("format");
        }, set: function (newValue) {
            this.setAttribute("format", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "formatTest", {
        get: function () {
            return this.getAttribute("formatTest");
        }, set: function (newValue) {
            this.setAttribute("formatTest", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "fracDigits", {
        get: function () {
            return this.getAttribute("fracDigits");
        }, set: function (newValue) {
            this.setAttribute("fracDigits", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "from", {
        get: function () {
            return this.getAttribute("from");
        }, set: function (newValue) {
            this.setAttribute("from", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "fullText", {
        get: function () {
            return this.getAttribute("fullText");
        }, set: function (newValue) {
            this.setAttribute("fullText", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "hand", {
        get: function () {
            return this.getAttribute("hand");
        }, set: function (newValue) {
            this.setAttribute("hand", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "highlight", {
        get: function () {
            return this.getAttribute("highlight");
        }, set: function (newValue) {
            this.setAttribute("highlight", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "href", {
        get: function () {
            return this.getAttribute("href");
        }, set: function (newValue) {
            this.setAttribute("href", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "hScrollPolicy", {
        get: function () {
            return this.getAttribute("hScrollPolicy");
        }, set: function (newValue) {
            this.setAttribute("hScrollPolicy", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "imagingBBox", {
        get: function () {
            return this.getAttribute("imagingBBox");
        }, set: function (newValue) {
            this.setAttribute("imagingBBox", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "initial", {
        get: function () {
            return this.getAttribute("initial");
        }, set: function (newValue) {
            this.setAttribute("initial", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "initialNumber", {
        get: function () {
            return this.getAttribute("initialNumber");
        }, set: function (newValue) {
            this.setAttribute("initialNumber", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "input", {
        get: function () {
            return this.getAttribute("input");
        }, set: function (newValue) {
            this.setAttribute("input", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "instanceIndex", {
        get: function () {
            return this.getAttribute("instanceIndex");
        }, set: function (newValue) {
            this.setAttribute("instanceIndex", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "intact", {
        get: function () {
            return this.getAttribute("intact");
        }, set: function (newValue) {
            this.setAttribute("intact", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "inverted", {
        get: function () {
            return this.getAttribute("inverted");
        }, set: function (newValue) {
            this.setAttribute("inverted", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "isDefined", {
        get: function () {
            return this.getAttribute("isDefined");
        }, set: function (newValue) {
            this.setAttribute("isDefined", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "join", {
        get: function () {
            return this.getAttribute("join");
        }, set: function (newValue) {
            this.setAttribute("join", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "keyAgreement", {
        get: function () {
            return this.getAttribute("keyAgreement");
        }, set: function (newValue) {
            this.setAttribute("keyAgreement", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "keyCertSign", {
        get: function () {
            return this.getAttribute("keyCertSign");
        }, set: function (newValue) {
            this.setAttribute("keyCertSign", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "keyDown", {
        get: function () {
            return this.getAttribute("keyDown");
        }, set: function (newValue) {
            this.setAttribute("keyDown", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "keyEncipherment", {
        get: function () {
            return this.getAttribute("keyEncipherment");
        }, set: function (newValue) {
            this.setAttribute("keyEncipherment", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "labelRef", {
        get: function () {
            return this.getAttribute("labelRef");
        }, set: function (newValue) {
            this.setAttribute("labelRef", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "language", {
        get: function () {
            return this.getAttribute("language");
        }, set: function (newValue) {
            this.setAttribute("language", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "layout", {
        get: function () {
            return this.getAttribute("layout");
        }, set: function (newValue) {
            this.setAttribute("layout", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "leadDigits", {
        get: function () {
            return this.getAttribute("leadDigits");
        }, set: function (newValue) {
            this.setAttribute("leadDigits", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "leader", {
        get: function () {
            return this.getAttribute("leader");
        }, set: function (newValue) {
            this.setAttribute("leader", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "leftInset", {
        get: function () {
            return this.getAttribute("leftInset");
        }, set: function (newValue) {
            this.setAttribute("leftInset", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "lineHeight", {
        get: function () {
            return this.getAttribute("lineHeight");
        }, set: function (newValue) {
            this.setAttribute("lineHeight", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "lineThrough", {
        get: function () {
            return this.getAttribute("lineThrough");
        }, set: function (newValue) {
            this.setAttribute("lineThrough", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "lineThroughPeriod", {
        get: function () {
            return this.getAttribute("lineThroughPeriod");
        }, set: function (newValue) {
            this.setAttribute("lineThroughPeriod", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "lockType", {
        get: function () {
            return this.getAttribute("lockType");
        }, set: function (newValue) {
            this.setAttribute("lockType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "long", {
        get: function () {
            return this.getAttribute("long");
        }, set: function (newValue) {
            this.setAttribute("long", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "marginLeft", {
        get: function () {
            return this.getAttribute("marginLeft");
        }, set: function (newValue) {
            this.setAttribute("marginLeft", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "marginRight", {
        get: function () {
            return this.getAttribute("marginRight");
        }, set: function (newValue) {
            this.setAttribute("marginRight", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "mark", {
        get: function () {
            return this.getAttribute("mark");
        }, set: function (newValue) {
            this.setAttribute("mark", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "match", {
        get: function () {
            return this.getAttribute("match");
        }, set: function (newValue) {
            this.setAttribute("match", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "max", {
        get: function () {
            return this.getAttribute("max");
        }, set: function (newValue) {
            this.setAttribute("max", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "maxChars", {
        get: function () {
            return this.getAttribute("maxChars");
        }, set: function (newValue) {
            this.setAttribute("maxChars", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "maxLength", {
        get: function () {
            return this.getAttribute("maxLength");
        }, set: function (newValue) {
            this.setAttribute("maxLength", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "min", {
        get: function () {
            return this.getAttribute("min");
        }, set: function (newValue) {
            this.setAttribute("min", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "modifier", {
        get: function () {
            return this.getAttribute("modifier");
        }, set: function (newValue) {
            this.setAttribute("modifier", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "moduleHeight", {
        get: function () {
            return this.getAttribute("moduleHeight");
        }, set: function (newValue) {
            this.setAttribute("moduleHeight", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "moduleWidth", {
        get: function () {
            return this.getAttribute("moduleWidth");
        }, set: function (newValue) {
            this.setAttribute("moduleWidth", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "multiLine", {
        get: function () {
            return this.getAttribute("multiLine");
        }, set: function (newValue) {
            this.setAttribute("multiLine", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "newContentType", {
        get: function () {
            return this.getAttribute("newContentType");
        }, set: function (newValue) {
            this.setAttribute("newContentType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "newText", {
        get: function () {
            return this.getAttribute("newText");
        }, set: function (newValue) {
            this.setAttribute("newText", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "next", {
        get: function () {
            return this.getAttribute("next");
        }, set: function (newValue) {
            this.setAttribute("next", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "nonRepudiation", {
        get: function () {
            return this.getAttribute("nonRepudiation");
        }, set: function (newValue) {
            this.setAttribute("nonRepudiation", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "nullTest", {
        get: function () {
            return this.getAttribute("nullTest");
        }, set: function (newValue) {
            this.setAttribute("nullTest", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "numbered", {
        get: function () {
            return this.getAttribute("numbered");
        }, set: function (newValue) {
            this.setAttribute("numbered", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "numberOfCells", {
        get: function () {
            return this.getAttribute("numberOfCells");
        }, set: function (newValue) {
            this.setAttribute("numberOfCells", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "numPages", {
        get: function () {
            return this.getAttribute("numPages");
        }, set: function (newValue) {
            this.setAttribute("numPages", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "oddOrEven", {
        get: function () {
            return this.getAttribute("oddOrEven");
        }, set: function (newValue) {
            this.setAttribute("oddOrEven", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "open", {
        get: function () {
            return this.getAttribute("open");
        }, set: function (newValue) {
            this.setAttribute("open", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "operation", {
        get: function () {
            return this.getAttribute("operation");
        }, set: function (newValue) {
            this.setAttribute("operation", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "orientation", {
        get: function () {
            return this.getAttribute("orientation");
        }, set: function (newValue) {
            this.setAttribute("orientation", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "output", {
        get: function () {
            return this.getAttribute("output");
        }, set: function (newValue) {
            this.setAttribute("output", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "overflowLeader", {
        get: function () {
            return this.getAttribute("overflowLeader");
        }, set: function (newValue) {
            this.setAttribute("overflowLeader", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "overflowTarget", {
        get: function () {
            return this.getAttribute("overflowTarget");
        }, set: function (newValue) {
            this.setAttribute("overflowTarget", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "overflowTrailer", {
        get: function () {
            return this.getAttribute("overflowTrailer");
        }, set: function (newValue) {
            this.setAttribute("overflowTrailer", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "overline", {
        get: function () {
            return this.getAttribute("overline");
        }, set: function (newValue) {
            this.setAttribute("overline", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "overlinePeriod", {
        get: function () {
            return this.getAttribute("overlinePeriod");
        }, set: function (newValue) {
            this.setAttribute("overlinePeriod", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "override", {
        get: function () {
            return this.getAttribute("override");
        }, set: function (newValue) {
            this.setAttribute("override", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "pagePosition", {
        get: function () {
            return this.getAttribute("pagePosition");
        }, set: function (newValue) {
            this.setAttribute("pagePosition", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "passwordChar", {
        get: function () {
            return this.getAttribute("passwordChar");
        }, set: function (newValue) {
            this.setAttribute("passwordChar", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "permissions", {
        get: function () {
            return this.getAttribute("permissions");
        }, set: function (newValue) {
            this.setAttribute("permissions", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "placement", {
        get: function () {
            return this.getAttribute("placement");
        }, set: function (newValue) {
            this.setAttribute("placement", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "platform", {
        get: function () {
            return this.getAttribute("platform");
        }, set: function (newValue) {
            this.setAttribute("platform", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "posture", {
        get: function () {
            return this.getAttribute("posture");
        }, set: function (newValue) {
            this.setAttribute("posture", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "preserve", {
        get: function () {
            return this.getAttribute("preserve");
        }, set: function (newValue) {
            this.setAttribute("preserve", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "prevContentType", {
        get: function () {
            return this.getAttribute("prevContentType");
        }, set: function (newValue) {
            this.setAttribute("prevContentType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "previous", {
        get: function () {
            return this.getAttribute("previous");
        }, set: function (newValue) {
            this.setAttribute("previous", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "prevText", {
        get: function () {
            return this.getAttribute("prevText");
        }, set: function (newValue) {
            this.setAttribute("prevText", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "printCheckDigit", {
        get: function () {
            return this.getAttribute("printCheckDigit");
        }, set: function (newValue) {
            this.setAttribute("printCheckDigit", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "priority", {
        get: function () {
            return this.getAttribute("priority");
        }, set: function (newValue) {
            this.setAttribute("priority", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "radius", {
        get: function () {
            return this.getAttribute("radius");
        }, set: function (newValue) {
            this.setAttribute("radius", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "radixOffset", {
        get: function () {
            return this.getAttribute("radixOffset");
        }, set: function (newValue) {
            this.setAttribute("radixOffset", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "rate", {
        get: function () {
            return this.getAttribute("rate");
        }, set: function (newValue) {
            this.setAttribute("rate", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "ready", {
        get: function () {
            return this.getAttribute("ready");
        }, set: function (newValue) {
            this.setAttribute("ready", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "recordsAfter", {
        get: function () {
            return this.getAttribute("recordsAfter");
        }, set: function (newValue) {
            this.setAttribute("recordsAfter", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "recordsBefore", {
        get: function () {
            return this.getAttribute("recordsBefore");
        }, set: function (newValue) {
            this.setAttribute("recordsBefore", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "reenter", {
        get: function () {
            return this.getAttribute("reenter");
        }, set: function (newValue) {
            this.setAttribute("reenter", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "ref", {
        get: function () {
            return this.getAttribute("ref");
        }, set: function (newValue) {
            this.setAttribute("ref", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "relation", {
        get: function () {
            return this.getAttribute("relation");
        }, set: function (newValue) {
            this.setAttribute("relation", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "reserve", {
        get: function () {
            return this.getAttribute("reserve");
        }, set: function (newValue) {
            this.setAttribute("reserve", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "restoreState", {
        get: function () {
            return this.getAttribute("restoreState");
        }, set: function (newValue) {
            this.setAttribute("restoreState", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "rightInset", {
        get: function () {
            return this.getAttribute("rightInset");
        }, set: function (newValue) {
            this.setAttribute("rightInset", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "role", {
        get: function () {
            return this.getAttribute("role");
        }, set: function (newValue) {
            this.setAttribute("role", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "rowColumnRatio", {
        get: function () {
            return this.getAttribute("rowColumnRatio");
        }, set: function (newValue) {
            this.setAttribute("rowColumnRatio", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "runAt", {
        get: function () {
            return this.getAttribute("runAt");
        }, set: function (newValue) {
            this.setAttribute("runAt", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "save", {
        get: function () {
            return this.getAttribute("save");
        }, set: function (newValue) {
            this.setAttribute("save", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "savedValue", {
        get: function () {
            return this.getAttribute("savedValue");
        }, set: function (newValue) {
            this.setAttribute("savedValue", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "scope", {
        get: function () {
            return this.getAttribute("scope");
        }, set: function (newValue) {
            this.setAttribute("scope", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "scriptTest", {
        get: function () {
            return this.getAttribute("scriptTest");
        }, set: function (newValue) {
            this.setAttribute("scriptTest", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "selEnd", {
        get: function () {
            return this.getAttribute("selEnd");
        }, set: function (newValue) {
            this.setAttribute("selEnd", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "selStart", {
        get: function () {
            return this.getAttribute("selStart");
        }, set: function (newValue) {
            this.setAttribute("selStart", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "server", {
        get: function () {
            return this.getAttribute("server");
        }, set: function (newValue) {
            this.setAttribute("server", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "shape", {
        get: function () {
            return this.getAttribute("shape");
        }, set: function (newValue) {
            this.setAttribute("shape", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "shift", {
        get: function () {
            return this.getAttribute("shift");
        }, set: function (newValue) {
            this.setAttribute("shift", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "short", {
        get: function () {
            return this.getAttribute("short");
        }, set: function (newValue) {
            this.setAttribute("short", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "signatureType", {
        get: function () {
            return this.getAttribute("signatureType");
        }, set: function (newValue) {
            this.setAttribute("signatureType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "size", {
        get: function () {
            return this.getAttribute("size");
        }, set: function (newValue) {
            this.setAttribute("size", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "slope", {
        get: function () {
            return this.getAttribute("slope");
        }, set: function (newValue) {
            this.setAttribute("slope", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "soapFaultCode", {
        get: function () {
            return this.getAttribute("soapFaultCode");
        }, set: function (newValue) {
            this.setAttribute("soapFaultCode", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "soapFaultString", {
        get: function () {
            return this.getAttribute("soapFaultString");
        }, set: function (newValue) {
            this.setAttribute("soapFaultString", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "somExpression", {
        get: function () {
            return this.getAttribute("somExpression");
        }, set: function (newValue) {
            this.setAttribute("somExpression", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "spaceAbove", {
        get: function () {
            return this.getAttribute("spaceAbove");
        }, set: function (newValue) {
            this.setAttribute("spaceAbove", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "spaceBelow", {
        get: function () {
            return this.getAttribute("spaceBelow");
        }, set: function (newValue) {
            this.setAttribute("spaceBelow", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "startAngle", {
        get: function () {
            return this.getAttribute("startAngle");
        }, set: function (newValue) {
            this.setAttribute("startAngle", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "startChar", {
        get: function () {
            return this.getAttribute("startChar");
        }, set: function (newValue) {
            this.setAttribute("startChar", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "startNew", {
        get: function () {
            return this.getAttribute("startNew");
        }, set: function (newValue) {
            this.setAttribute("startNew", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "stateless", {
        get: function () {
            return this.getAttribute("stateless");
        }, set: function (newValue) {
            this.setAttribute("stateless", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "stock", {
        get: function () {
            return this.getAttribute("stock");
        }, set: function (newValue) {
            this.setAttribute("stock", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "stroke", {
        get: function () {
            return this.getAttribute("stroke");
        }, set: function (newValue) {
            this.setAttribute("stroke", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "sweepAngle", {
        get: function () {
            return this.getAttribute("sweepAngle");
        }, set: function (newValue) {
            this.setAttribute("sweepAngle", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "tabDefault", {
        get: function () {
            return this.getAttribute("tabDefault");
        }, set: function (newValue) {
            this.setAttribute("tabDefault", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "tabStops", {
        get: function () {
            return this.getAttribute("tabStops");
        }, set: function (newValue) {
            this.setAttribute("tabStops", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "target", {
        get: function () {
            return this.getAttribute("target");
        }, set: function (newValue) {
            this.setAttribute("target", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "targetType", {
        get: function () {
            return this.getAttribute("targetType");
        }, set: function (newValue) {
            this.setAttribute("targetType", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "textEncoding", {
        get: function () {
            return this.getAttribute("textEncoding");
        }, set: function (newValue) {
            this.setAttribute("textEncoding", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "textEntry", {
        get: function () {
            return this.getAttribute("textEntry");
        }, set: function (newValue) {
            this.setAttribute("textEntry", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "textIndent", {
        get: function () {
            return this.getAttribute("textIndent");
        }, set: function (newValue) {
            this.setAttribute("textIndent", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "textLocation", {
        get: function () {
            return this.getAttribute("textLocation");
        }, set: function (newValue) {
            this.setAttribute("textLocation", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "thickness", {
        get: function () {
            return this.getAttribute("thickness");
        }, set: function (newValue) {
            this.setAttribute("thickness", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "timeout", {
        get: function () {
            return this.getAttribute("timeout");
        }, set: function (newValue) {
            this.setAttribute("timeout", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "timeStamp", {
        get: function () {
            return this.getAttribute("timeStamp");
        }, set: function (newValue) {
            this.setAttribute("timeStamp", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "title", {
        get: function () {
            return this.getAttribute("title");
        }, set: function (newValue) {
            this.setAttribute("title", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "topInset", {
        get: function () {
            return this.getAttribute("topInset");
        }, set: function (newValue) {
            this.setAttribute("topInset", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "trailer", {
        get: function () {
            return this.getAttribute("trailer");
        }, set: function (newValue) {
            this.setAttribute("trailer", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "transferEncoding", {
        get: function () {
            return this.getAttribute("transferEncoding");
        }, set: function (newValue) {
            this.setAttribute("transferEncoding", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "transient", {
        get: function () {
            return this.getAttribute("transient");
        }, set: function (newValue) {
            this.setAttribute("transient", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "truncate", {
        get: function () {
            return this.getAttribute("truncate");
        }, set: function (newValue) {
            this.setAttribute("truncate", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "type", {
        get: function () {
            return this.getAttribute("type");
        }, set: function (newValue) {
            this.setAttribute("type", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "typeface", {
        get: function () {
            return this.getAttribute("typeface");
        }, set: function (newValue) {
            this.setAttribute("typeface", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "underline", {
        get: function () {
            return this.getAttribute("underline");
        }, set: function (newValue) {
            this.setAttribute("underline", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "underlinePeriod", {
        get: function () {
            return this.getAttribute("underlinePeriod");
        }, set: function (newValue) {
            this.setAttribute("underlinePeriod", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "upsMode", {
        get: function () {
            return this.getAttribute("upsMode");
        }, set: function (newValue) {
            this.setAttribute("upsMode", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "url", {
        get: function () {
            return this.getAttribute("url");
        }, set: function (newValue) {
            this.setAttribute("url", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "urlPolicy", {
        get: function () {
            return this.getAttribute("urlPolicy");
        }, set: function (newValue) {
            this.setAttribute("urlPolicy", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "usage", {
        get: function () {
            return this.getAttribute("usage");
        }, set: function (newValue) {
            this.setAttribute("usage", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "uuid", {
        get: function () {
            return this.getAttribute("uuid");
        }, set: function (newValue) {
            this.setAttribute("uuid", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "validationsEnabled", {
        get: function () {
            return this.getAttribute("validationsEnabled");
        }, set: function (newValue) {
            this.setAttribute("validationsEnabled", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "value", {
        get: function () {
            return this.getAttribute("value");
        }, set: function (newValue) {
            this.setAttribute("value", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "valueRef", {
        get: function () {
            return this.getAttribute("valueRef");
        }, set: function (newValue) {
            this.setAttribute("valueRef", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "variation", {
        get: function () {
            return this.getAttribute("variation");
        }, set: function (newValue) {
            this.setAttribute("variation", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "version", {
        get: function () {
            return this.getAttribute("version");
        }, set: function (newValue) {
            this.setAttribute("version", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "vScollPolicy", {
        get: function () {
            return this.getAttribute("vScollPolicy");
        }, set: function (newValue) {
            this.setAttribute("vScollPolicy", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "weight", {
        get: function () {
            return this.getAttribute("weight");
        }, set: function (newValue) {
            this.setAttribute("weight", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "wideNarrowRatio", {
        get: function () {
            return this.getAttribute("wideNarrowRatio");
        }, set: function (newValue) {
            this.setAttribute("wideNarrowRatio", newValue);
        }, configurable: true, enumerable: true
    });
    Object.defineProperty(this, "xdpContent", {
        get: function () {
            return this.getAttribute("xdpContent");
        }, set: function (newValue) {
            this.setAttribute("xdpContent", newValue);
        }, configurable: true, enumerable: true
    });
    //define methods as in xfa specification
    Object.defineProperty(this, "getNode", {
        value: function () {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "absPage", {
        value: function (param) {
            return 1;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "absPageCount ", {
        value: function () {
            return 1;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "absPageCountInBatch ", {
        value: function () {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "absPageInBatch ", {
        value: function (param) {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "absPageSpan", {
        value: function (span) {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "addInstance", {
        value: function (boolParam) {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "addNew", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "beep", {
        value: function (intParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "cancel", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "cancelBatch ", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "clear", {
        value: function () {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "clearErrorList ", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "close", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "createNode ", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "delete", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "documentCountInBatch ", {
        value: function () {
            return 1;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "documentInBatch", {
        value: function () {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "emit", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "enumerate", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "evaluate", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "execute", {
        value: function (boolParam) {
            return false;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "exportData", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "first", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "formNodes", {
        value: function (objParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "getDelta", {
        value: function (stringParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "getDeltas", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "getFocus", {
        value: function () {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "gotoRecord", {
        value: function (intParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "gotoURL", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "h", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "hasDataChanged", {
        value: function () {
            return false;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "importData", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "importData", {
        value: function (stringParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "insertInstance ", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "isBOF", {
        value: function () {
            return false;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "isCompatibleNS ", {
        value: function (stringParam) {
            return false;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "isEOF", {
        value: function () {
            return false;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "isRecordGroup", {
        value: function (objParam) {
            return false;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "last", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "messageBox", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "metadata", {
        value: function (intParam) {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "moveCurrentRecord", {
        value: function (intParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "moveInstance", {
        value: function (formIndex, childIndex) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "namedItem", {
        value: function (stringParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "next", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "open", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "openList", {
        value: function (objParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "page", {
        value: function (objParam) {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "pageContent", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "pageCount", {
        value: function () {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "pageDown", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "pageSpan", {
        value: function (objParam) {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "pageUp", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "previous", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "print", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "recalculate", {
        value: function (boolParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "record", {
        value: function (intParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "relayout", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "relayoutPageArea", {
        value: function (intParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "remerge", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "removeInstance", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "requery", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "reset", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "resetData", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "resetData", {
        value: function (stringParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "response", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "restore", {
        value: function () {
            return null;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "resync", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "selectedMember", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "selectedMember", {
        value: function (stringParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "setFocus", {
        value: function (stringParam) {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "setInstances", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "sheet", {
        value: function (objParam) {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "sheetCount", {
        value: function () {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "sheetCountInBatch", {
        value: function () {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "sheetInBatch", {
        value: function (objParam) {
            return 0;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "sign", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "update", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "updateBatch", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "verify", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "w", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "x", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
    Object.defineProperty(this, "y", {
        value: function () {
            return;
        }, configurable: true, enumerable: true, writable: true
    });
}
;
function getElementsByTagName(lookup, name) {
    var arr = new Array();
    gEBTN(lookup, name, arr);
    return arr;
}

function gEBTN(lookup, name, arr) {
    if (lookup.nodeType === NODE_ELEMENT) {
        for (var z = 0; z < lookup.childNodes.length; z++) {
            var child = lookup.childNodes[z];
            if (child.nodeName === name) {
                arr[arr.length] = child;
            }
            if (child.childNodes.length > 0) {
                gEBTN(child, name, arr);
            }
        }
    }
}

function getXMLData(node) {
    var str = "";
    if (node.nodeType === NODE_ELEMENT) {
        str = "<" + node.nodeName + "";
        var atrMap = node.getAttributeMap();
        for (var key in atrMap) {
            str = str + " " + key + "=" + "\"" + atrMap[key] + "\"";
        }
        if (node.childNodes.length === 0) {
            str = str + "/>";
        }
        else {
            str = str + ">";
            for (var z = 0; z < node.childNodes.length; z++) {
                str = str + getXMLData(node.childNodes[z]);
            }
            str = str + "</" + node.nodeName + ">";
        }
        return str;
    }
    else if (node.nodeType === NODE_TEXT) {
        return node.nodeValue;
    }
}

function getChildrenArrayFromXML(xmlText) {
    var children = new Array();
    var str = getTagWithAtr(xmlText);
    str = str.trim();
    if (str.charAt(str.length - 1).indexOf("/") !== -1) {
        return children; //blank element
    }
    str = xmlText.substring(xmlText.indexOf(">") + 1, xmlText.lastIndexOf("<"));
    while (!isEmpty(str)) {
        if (str.indexOf("<") === 0) {
            var temp = getTagWithAtr(str);
            temp = temp.trim();
            var lastChar = temp.charAt(temp.length - 1);
            if (lastChar.indexOf("/") !== -1) { // empty tag
                children[children.length] = "<" + temp + ">";
                str = str.substring(temp.length + 2, str.length);
            } else {
                var nodeName = getNameFromXML(str);
                var fullAtr = getTagWithAtr(str);
                var justS = "<" + nodeName;
                var endS = "</" + nodeName + ">";
                var emptyS = "<" + nodeName + "/>";
                var curEnd = str.indexOf(endS);
                var ts = str.substring(1, str.length);
                var index = -1;
                var temp1 = ts.indexOf(justS + " ");
                var temp2 = ts.indexOf(justS + ">");
                if (temp1 != -1 && temp2 != -1) {
                    index = Math.min(temp1, temp2);
                } else if (temp1 != -1) {
                    index = temp1;
                } else if (temp2 != -1) {
                    index = temp2;
                }

                if (index != -1 && index < curEnd) {
                    ts = str;
                    var dupCount = 0;
                    while (!isEmpty(ts)) {
                        var sPos = -1;
                        var t1 = ts.indexOf(justS + " ");
                        var t2 = ts.indexOf(justS + ">");
                        if (t1 != -1 && t2 != -1) {
                            sPos = Math.min(t1, t2);
                        } else if (t1 != -1) {
                            sPos = t1;
                        } else if (t2 != -1) {
                            sPos = t2;
                        }
                        var ePos = ts.indexOf(endS);

                        if (ts.trim().indexOf(emptyS) === 0) {
                            ts = ts.substring(ts.indexOf(emptyS) + emptyS.length, ts.length);
                        }
                        else if (sPos != -1 && ePos != -1) {
                            if (sPos < ePos) {
                                dupCount++;
                                ts = ts.substring(sPos, ts.length);
                                ts = ts.substring(ts.indexOf(">") + 1, ts.length);
                            } else {
                                dupCount--;
                                ts = ts.substring(ts.indexOf(endS) + endS.length, ts.length);
                            }
                        }
                        else if (ePos != -1) {
                            dupCount--;
                            ts = ts.substring(ts.indexOf(endS) + endS.length, ts.length);
                        }
                        if (dupCount == 0) {
                            children[children.length] = str.substring(0, str.length - ts.length);
                            str = str.substring(str.length - ts.length, str.length);
                            ts = "";
                        }
                    }
                }
                else {
                    var endPos = curEnd + nodeName.length + 3;
                    children[children.length] = str.substring(0, endPos);
                    str = str.substring(endPos, str.length);
                }
            }
        } else { //text nodes
            var data = "";
            for (var i = 0; i < str.length; i++) {
                var c = str.charAt(i);
                if (c.indexOf("<") === 0) {
                    break;
                } else {
                    data = data + c;
                }
            }
            children[children.length] = data;
            str = str.substring(data.length, str.length);
        }
    }
    return children;
}

function getNameFromXML(xmlText) {
    if (xmlText.indexOf("<") !== 0) {
        return null;
    }
    var temp = getTagWithAtr(xmlText);
    temp = temp.trim();
    if (temp.indexOf("/") === 0) {
        temp = (temp.substring(1, temp.indexOf(">")));
        return temp.trim();
    }
    var whitespace = "\n\r\t ", slash = "/";
    var name = "";
    for (var z = 0; z < temp.length; z++) {
        var c = "" + temp.charAt(z);
        if (whitespace.indexOf(c) !== -1 || slash.indexOf(c) !== -1) {
            return name;
        } else {
            name = name + c;
        }
    }
    return name;
}

function getAttributeMap(xmlText) {
    var full = getTagWithAtr(xmlText);
    var tagName = getNameFromXML(xmlText);
    var atrNames = new Array(), atrValues = new Array();
    if (tagName != null) {
        full = full.substring(full.indexOf(tagName) + tagName.length, full.length);
        full = full.trim();
        var whitespace = "\n\r\t ", slash = "/";
        var isEqualFound = false;
        var valStarted = false;
        var names = "";
        var values = "";
        for (var z = 0; z < full.length; z++) {
            var c = full.charAt(z);
            if (c.indexOf("=") == 0) {
                atrNames[atrNames.length] = names.trim();
                names = "";
                isEqualFound = true;
            }
            else {
                if (isEqualFound) {
                    if (c.indexOf("'") == 0 || c.indexOf("\"") == 0) {
                        if (valStarted) {
                            atrValues[atrValues.length] = values.trim();
                            values = "";
                            isEqualFound = false;
                        }
                        valStarted = !valStarted;
                    } else {
                        values = values + c;
                    }
                } else {
                    if (whitespace.indexOf(c) !== 0 || slash.indexOf(c) !== 0) {
                        names = names + c;
                    }
                }
            }
        }
    }

    var atrMap = {};
    for (var z = 0; z < atrNames.length; z++) {
        atrMap["" + atrNames[z]] = "" + atrValues[z];
    }
    return atrMap;
}

var arity = function (fn) {
    var count = Math.max(fn.length - 1, 0);
    return function () {
        var args = Array.prototype.slice.call(arguments, 0, count);
        // Enforce the array length, in case we don't have enough array padding.
        args.length = count;
        args.push(Array.prototype.slice.call(arguments, count));
        return fn.apply(this, args);
    };
};
var fn = arity(function (args) {
    return args;
});
function getTagWithAtr(xmlText) {
    return xmlText.substring(xmlText.indexOf("<") + 1, xmlText.indexOf(">"));
}

String.prototype.encToText = function () {
    return this.replace(/</g, "&gt;").replace(/>/g, "&lt;").replace(/&/g, "&amp;");
};
String.prototype.encToXML = function () {
    return this.replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&amp;/g, '&');
};
String.prototype.trimLeft = function () {
    return this.replace(/^\s+/g, "");
};
String.prototype.trimRight = function () {
    return this.replace(/\s+$/, "");
};
var isEmpty = function (str) {
    return (str === null || (typeof str === 'undefined') || str.length === 0);
};
var removeComments = function (xmlData) {
    return xmlData.replace(/<!--.*?-->/g, "");
};
var removeDocType = function (xmlData) {
    return xmlData.replace(/<!DOCTYPE.*?>/g, "");
};
var removeCDATA = function (xmlData) {
    return xmlData.replace(/<!\[CDATA\[(.)*?\]\]>/g, "");
};
var removePI = function (xmlData) {
    return xmlData.replace(/<\?.*?\?>/g, "");
};
var removeSpaceBetweenNodes = function (xmlData) {
    return xmlData.replace(/>\s*</g, "><");
};

function alert(data) {
    println(data)
}
