/*
 * Decompiled with CFR 0.152.
 */
package ice.setup.storage;

import ice.util.Defs;
import ice.util.alg.CharKit;
import ice.util.alg.HashArray;
import ice.util.io.DataStorage;
import ice.util.io.IOKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DirectoryStorage
extends DataStorage {
    private String userHomePath;
    private String dataSubdirPath;
    private final HashArray lockMap = new HashArray();
    private File rootDir;

    public static DirectoryStorage inHomeDir(String subdir) {
        String home = Defs.sysProperty((String)"user.home");
        if (home == null || !new File(home).exists()) {
            home = Defs.sysProperty((String)"user.dir");
        }
        return new DirectoryStorage(home, subdir);
    }

    public DirectoryStorage(String userHomePath, String dataSubdirPath) {
        this.userHomePath = userHomePath;
        this.dataSubdirPath = dataSubdirPath;
    }

    private Object getDataLock(String dataName) {
        return this.lockMap.ensureEntry((Object)dataName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String dataName) throws IOException {
        byte[] data;
        Object object = this.getDataLock(dataName);
        synchronized (object) {
            File file = this.fileForName(dataName);
            if (!file.exists()) {
                data = null;
            } else {
                FileInputStream is = new FileInputStream(file);
                try {
                    long length = file.length();
                    int bufferSize = length == 0L ? 4096 : Integer.MAX_VALUE & (int)length;
                    data = IOKit.readAll((InputStream)is, (int)bufferSize);
                }
                finally {
                    is.close();
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String dataName, byte[] array, int offset, int length) throws IOException {
        Object object = this.getDataLock(dataName);
        synchronized (object) {
            File file = this.fileForName(dataName);
            FileOutputStream os = new FileOutputStream(file);
            try {
                os.write(array, offset, length);
            }
            finally {
                os.close();
            }
        }
    }

    private File fileForName(String name) {
        File root = this.rootDir;
        if (root == null) {
            root = new File(this.userHomePath, this.dataSubdirPath);
            if (!root.exists()) {
                root.mkdirs();
            }
            this.rootDir = root;
        }
        File dir = root;
        String[] path = CharKit.split((int)47, (String)name);
        int N = path.length;
        if (N > 1) {
            for (int i = 0; i != N - 1; ++i) {
                if ((dir = new File(dir, path[i])).exists()) continue;
                dir.mkdir();
            }
        }
        return new File(dir, path[N - 1]);
    }
}

