/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class MessagePane
extends Dialog
implements ActionListener,
WindowListener {
    public static final int OK_OPTION = 1;
    private Frame parentFrame;
    private ActionListener listener;
    private Button ok;
    private Label text;
    private Panel buttonPanel;

    public MessagePane(Frame parent, String message) {
        this(parent, null, message, 1);
    }

    public MessagePane(Frame parent, String title, String message, int option) {
        super(parent, true);
        this.parentFrame = parent;
        if (title != null) {
            this.setTitle(title);
        }
        this.text = new Label(message);
        this.text.setAlignment(1);
        this.add((Component)this.text, "Center");
        this.buttonPanel = new Panel(new FlowLayout(1));
        if (option == 1) {
            this.ok = new Button("OK");
            this.ok.addActionListener(this);
            this.buttonPanel.add(this.ok);
        }
        this.add((Component)this.buttonPanel, "South");
        this.addWindowListener(this);
    }

    public void setActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setOKActionCommand(String actionCommand) {
        if (this.ok != null) {
            this.ok.setActionCommand(actionCommand);
        }
    }

    public void setText(String message) {
        this.text.setText(message);
        this.pack();
    }

    public void close() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
        if (this.listener != null) {
            this.listener.actionPerformed(e);
        }
    }

    public void show() {
        this.pack();
        this.center();
        super.show();
    }

    private void center() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameDim = this.parentFrame.getSize();
        int x = this.parentFrame.getLocation().x + (frameDim.width - this.getSize().width) / 2;
        int y = this.parentFrame.getLocation().y + (frameDim.height - this.getSize().height) / 2;
        if (screenDim.width < x + this.getSize().width) {
            x = screenDim.width - this.getSize().width;
        }
        if (screenDim.height < y + this.getSize().height) {
            y = screenDim.height - this.getSize().height;
        }
        this.setLocation(x, y);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

