/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.CallbackImplBase;
import ice.browser.Detour;
import ice.browser.IBModule;
import ice.browser.ParseTreePrinter;
import ice.browser.VisitedLinks;
import ice.debug.Debug;
import ice.setup.storage.DirectoryStorage;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.ViewportCallback;
import ice.util.Defs;
import ice.util.security.SecurityKit;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Vector;

public class Main {
    static final String HOME_URL = "http://www.icesoft.com/";
    static final String helpMsg = "\n    ICEbrowser supports several options which might be useful.\n\n    This list summarises a few of those options:\n\n--help    prints this help\n-p        prints the DOM tree to ice_output.txt in current directory\n-t:XXX    names toolkit to use.  Default is awt, another option is swing\n-nosm     specifies that there should be no security manager\n-hNUM     specifies height of window\n-wNUM     specifies width of window\n-c:XXX    names compatibility mode.  Default is icebrowser. Other options are\n          'ie' for Internet Explorer 5, and 'ns6' for Netscape 6.";
    static Vector modules = new Vector();
    static int reqWidth = 600;
    static int reqHeight = 600;

    public static final void main(String[] args) {
        String cmode = "ib";
        String tname = "awt";
        boolean securityManager = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-t:")) {
                tname = args[i].substring(3);
                continue;
            }
            if (args[i].startsWith("-w")) {
                try {
                    reqWidth = Integer.parseInt(args[i].substring(2));
                }
                catch (Exception ex) {}
                continue;
            }
            if (args[i].startsWith("-h")) {
                try {
                    reqHeight = Integer.parseInt(args[i].substring(2));
                }
                catch (Exception ex) {}
                continue;
            }
            if (args[i].startsWith("-c:")) {
                cmode = args[i].substring(3);
                continue;
            }
            if (args[i].equals("-nosm")) {
                securityManager = false;
                continue;
            }
            if (!args[i].equals("--help")) continue;
            System.out.println(helpMsg);
            return;
        }
        if (securityManager && !SecurityKit.usesJava2Security()) {
            SecurityKit.installDefaultSecurityManager();
        }
        ice.util.net.URLStreamHandlerFactory f = new ice.util.net.URLStreamHandlerFactory();
        ice.util.net.URLStreamHandlerFactory.removeStreamHandler((String)"http");
        ice.util.net.URLStreamHandlerFactory.removeStreamHandler((String)"https");
        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)f);
        if (cmode != null) {
            Defs.setProperty((String)"ice.browser.emulation", (String)cmode);
        }
        if (Defs.sysPropertyBoolean((String)"ice.pilots.html4.viewXmlAsTree", (boolean)true)) {
            Defs.setSystemProperty((String)"ice.pilots.html4.viewXmlAsTree", (String)"true");
        }
        StormBase base = new StormBase();
        DirectoryStorage storage = DirectoryStorage.inHomeDir("ICEsoft/GenericRI");
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-m:")) continue;
            String mname = args[i].substring(3);
            try {
                Class<?> c = Class.forName("ice.browser." + mname);
                IBModule m = (IBModule)c.newInstance();
                m.initModule(base, storage);
                modules.addElement(m);
                continue;
            }
            catch (Exception ex) {
                if (Debug.trace) {
                    Debug.trace((String)("Could not load module \"" + mname + "\""));
                }
                if (!Debug.ex) continue;
                Debug.ex((Throwable)ex);
            }
        }
        if (Defs.sysPropertyBoolean((String)"ice.browser.http.detour", (boolean)false)) {
            Detour.getInstance(base);
        }
        String parseFile = Defs.sysProperty((String)"ice.browser.parseTreeOutput");
        base.addPropertyChangeListener((PropertyChangeListener)new VisitedLinks(), null);
        base.setComponentToolkitName(tname);
        try {
            Class<?> c = Class.forName("ice.browser.MyCallback_" + tname);
            CallbackImplBase cb = (CallbackImplBase)c.newInstance();
            base.setViewportCallback((ViewportCallback)cb);
            base.setScripterCallback((ScripterCallback)cb);
        }
        catch (Exception ex) {
            if (Debug.ex) {
                Debug.ex((Throwable)ex);
            }
            if (Debug.trace) {
                Debug.trace((String)("Could not run browser for toolkit \"" + tname + "\""));
            }
            return;
        }
        int counter = 0;
        for (int i = 0; i < args.length; ++i) {
            String loc;
            block33: {
                if (args[i].startsWith("-p") || parseFile != null) {
                    try {
                        base.addPropertyChangeListener((PropertyChangeListener)new ParseTreePrinter(parseFile), null);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (args[i].startsWith("-")) continue;
                loc = args[i];
                File file = new File(loc);
                if (file.exists()) {
                    try {
                        String path = file.getAbsolutePath();
                        if (File.separatorChar == '\\') {
                            loc = "file://localhost/" + path.replace('\\', '/');
                            break block33;
                        }
                        loc = "file://localhost" + path;
                    }
                    catch (RuntimeException ex) {}
                } else if (loc.indexOf(":") < 0) {
                    loc = "http://" + loc;
                }
            }
            base.renderContent(loc, null, "icemain" + counter);
            ++counter;
        }
        if (counter == 0) {
            base.renderContent(HOME_URL, null, "icemain0");
        }
    }

    static void exit(StormBase base) {
        base.dispose();
        System.exit(0);
    }
}

