/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel.iterable;

import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.runtime.CSVIterable;
import coldfusion.util.RB;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.commons.csv.CSVRecord;

public class CSVRecordIterable
implements CSVIterable<Array>,
Iterator {
    Iterable<CSVRecord> csvRecordIterable;
    Array returnValue = null;
    Iterator<CSVRecord> csvIterator = null;
    Iterator<Array> iterator = null;
    FileReader fileReader = null;

    public CSVRecordIterable(Iterable<CSVRecord> csvIterable, Array value, FileReader fileReader, final Predicate<CSVRecord> isEmptyRecord) {
        this.csvRecordIterable = csvIterable;
        this.csvIterator = csvIterable.iterator();
        this.returnValue = value;
        this.fileReader = fileReader;
        this.iterator = new Iterator<Array>(){

            @Override
            public boolean hasNext() {
                return CSVRecordIterable.this.csvIterator.hasNext();
            }

            @Override
            public Array next() {
                Array array = new Array(1, "STRING");
                CSVRecord record = CSVRecordIterable.this.csvIterator.next();
                if (isEmptyRecord.test(record)) {
                    return array;
                }
                array.addAll(Arrays.asList(record.values()));
                return array;
            }
        };
    }

    public Iterator<Array> iterator() {
        return this.iterator;
    }

    public boolean canGetSize() {
        return false;
    }

    public Object getObject() {
        return this.returnValue;
    }

    public int size() {
        return -1;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            try {
                this.fileReader.close();
            }
            catch (IOException e) {
                CFLogs.APPLICATION_LOG.warn((Object)RB.getString(CSVRecordIterable.class, (String)"FILE_READER_CLOSING_ERROR"), (Throwable)e);
            }
        }
        return hasNext;
    }

    public Array next() {
        return this.iterator.next();
    }

    public boolean close() {
        try {
            this.fileReader.close();
            return true;
        }
        catch (IOException e) {
            CFLogs.APPLICATION_LOG.warn((Object)RB.getString(CSVRecordIterable.class, (String)"FILE_READER_CLOSING_ERROR"), (Throwable)e);
            return false;
        }
    }
}

