/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel.datavalidation;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EnumValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.excel.datavalidation.CellRange;
import coldfusion.excel.datavalidation.CellRangeMetadata;
import coldfusion.excel.datavalidation.SheetDataValidationRule;
import coldfusion.runtime.NonArrayException;
import coldfusion.tagext.lang.SpreadSheetTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.util.CellRangeAddress;

public class SheetDataValidationRuleMetadata {
    static SheetDataValidationRuleMetadata instance = null;
    FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    ConsumerMap<SheetDataValidationRule> consumerMap = new ConsumerMap();
    Set<String> allowedValidationTypes = Set.of("LIST", "INTEGER", "DOUBLE", "TEXT_LENGTH", "DATE");
    Set<String> allowedOperatorTypes = Set.of("BETWEEN", "EQUAL", "GREATER_OR_EQUAL", "GREATER_THAN", "LESS_OR_EQUAL", "LESS_THAN", "NOT_BETWEEN", "NOT_EQUAL");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SheetDataValidationRuleMetadata getInstance() {
        if (instance != null) return instance;
        Class<SheetDataValidationRuleMetadata> clazz = SheetDataValidationRuleMetadata.class;
        synchronized (SheetDataValidationRuleMetadata.class) {
            if (instance != null) return instance;
            instance = new SheetDataValidationRuleMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SheetDataValidationRuleMetadata() {
        this.consumerMap.put((Object)"validationType", new ConsumerValidator((rule, value) -> this.fillRuleType((SheetDataValidationRule)rule, value), Arrays.asList(NotNullValidator.INSTANCE, new EnumValidator(this.allowedValidationTypes, "validationType"))));
        this.consumerMap.put((Object)"operator", new ConsumerValidator((rule, value) -> this.fillOperatorType((SheetDataValidationRule)rule, value), null));
        this.consumerMap.put((Object)"alertText", new ConsumerValidator((rule, value) -> rule.setErrorBoxText(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"alertTitle", new ConsumerValidator((rule, value) -> rule.setErrorBoxTitle(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"cellSelectText", new ConsumerValidator((rule, value) -> rule.setPromptBoxText(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"cellSelectTitle", new ConsumerValidator((rule, value) -> rule.setPromptBoxTitle(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"minValue", new ConsumerValidator((rule, value) -> rule.setMinValue(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"maxValue", new ConsumerValidator((rule, value) -> rule.setMaxValue(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"value", new ConsumerValidator((rule, value) -> rule.setValue(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"allowedValues", new ConsumerValidator((rule, value) -> {
            String[] valuesArray = null;
            try {
                valuesArray = this.cast.getStringArrayProperty(value);
            }
            catch (NonArrayException e) {
                throw new SpreadSheetTag.DataValidationNonListValueException(value);
            }
            if (valuesArray == null || valuesArray.length == 0) {
                throw new SpreadSheetTag.EmptyListNotAllowedException("allowedValues");
            }
            rule.setAllowedValues(valuesArray);
        }, null));
        this.consumerMap.put((Object)"regions", new ConsumerValidator((rule, value) -> rule.setRegions(this.fillRegions((SheetDataValidationRule)rule, value)), Arrays.asList(NotNullValidator.INSTANCE)));
    }

    private List<CellRangeAddress> fillRegions(SheetDataValidationRule rule, Object value) {
        List cellRanges = this.cast.getListProperty(value);
        if (cellRanges.isEmpty()) {
            throw new SpreadSheetTag.DataValidationInvalidRegionException("regions");
        }
        ArrayList<CellRangeAddress> regions = new ArrayList<CellRangeAddress>();
        cellRanges.forEach(range -> {
            Map map = this.cast.getMapProperty(range);
            CellRange cellRangeObject = new CellRange();
            ValidatorFiller.INSTANCE.fillObject((Object)cellRangeObject, map, CellRangeMetadata.getInstance().getConsumerMap());
            regions.add(new CellRangeAddress(cellRangeObject.getStartRow() - 1, cellRangeObject.getEndRow() - 1, cellRangeObject.getStartColumn() - 1, cellRangeObject.getEndColumn() - 1));
        });
        return regions;
    }

    private void fillOperatorType(SheetDataValidationRule rule, Object value) {
        String operatorType = this.cast.getStringProperty(value);
        if (!this.allowedOperatorTypes.contains(operatorType)) {
            throw new SpreadSheetTag.DataValidationIncorrectOperatorException(operatorType);
        }
        switch (operatorType) {
            case "BETWEEN": {
                rule.setOperatorType(0);
                break;
            }
            case "EQUAL": {
                rule.setOperatorType(2);
                break;
            }
            case "GREATER_OR_EQUAL": {
                rule.setOperatorType(6);
                break;
            }
            case "GREATER_THAN": {
                rule.setOperatorType(4);
                break;
            }
            case "LESS_OR_EQUAL": {
                rule.setOperatorType(7);
                break;
            }
            case "LESS_THAN": {
                rule.setOperatorType(5);
                break;
            }
            case "NOT_EQUAL": {
                rule.setOperatorType(3);
                break;
            }
            case "NOT_BETWEEN": {
                rule.setOperatorType(1);
            }
        }
    }

    private void fillRuleType(SheetDataValidationRule rule, Object value) {
        switch (this.cast.getStringProperty(value)) {
            case "LIST": {
                rule.setValidationType(3);
                break;
            }
            case "INTEGER": {
                rule.setValidationType(1);
                break;
            }
            case "DOUBLE": {
                rule.setValidationType(2);
                break;
            }
            case "TEXT_LENGTH": {
                rule.setValidationType(6);
                break;
            }
            case "DATE": {
                rule.setValidationType(4);
            }
        }
    }

    public ConsumerMap<SheetDataValidationRule> getConsumerMap() {
        return this.consumerMap;
    }
}

