/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.document;

import coldfusion.document.DocumentItemInvalidType;
import coldfusion.document.DocumentMissingParentTagException;
import coldfusion.document.DocumentScope;
import coldfusion.document.HeaderFooterContentProviderImpl;
import coldfusion.document.StaticHeaderFooterContentProvider;
import coldfusion.document.spi.HeaderFooterContentProvider;
import coldfusion.runtime.CFOutput;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.FunctionGeneratorTag;
import coldfusion.tagext.document.DocumentSectionTag;
import coldfusion.tagext.document.DocumentTag;
import coldfusion.tagext.lang.DocumentTagException;
import jakarta.servlet.jsp.tagext.Tag;
import java.util.Map;

public class DocumentItemTag
extends ChildTag
implements FunctionGeneratorTag {
    private static final long serialVersionUID = 1L;
    private Tag parentTag = null;
    private String type = null;
    private String funcName;
    private Map extraAttributes = null;
    private boolean evalAtPrint;

    public DocumentItemTag() {
        super(DocumentTag.class);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (!(type.equalsIgnoreCase("pagebreak") || type.equalsIgnoreCase("header") || type.equalsIgnoreCase("footer"))) {
            throw new DocumentItemInvalidType(type);
        }
    }

    public void setAttributecollection(Map map) {
        this.extraAttributes = map;
    }

    public void setAncestor(Tag t) {
        this.parentTag = t;
    }

    public void setEvalAtPrint(boolean evalAtPrint) {
        this.evalAtPrint = evalAtPrint;
    }

    public boolean getEvalAtPrint() {
        return this.evalAtPrint;
    }

    public int doStartTag() throws DocumentTagException {
        this.onTagStart();
        boolean bHasDocParent = false;
        this.parentTag = this.getParent();
        while (this.parentTag != null) {
            if (this.parentTag instanceof DocumentSectionTag || this.parentTag instanceof DocumentTag) {
                bHasDocParent = true;
                break;
            }
            this.parentTag = this.parentTag.getParent();
        }
        if (!bHasDocParent) {
            throw new DocumentMissingParentTagException();
        }
        if (this.type.equalsIgnoreCase("pagebreak")) {
            try {
                if (this.out instanceof CFOutput) {
                    ((CFOutput)this.out).cfoutput(true);
                }
                this.out.write("\n<br><p STYLE=\"page-break-before: always\"></p>\n");
                if (this.out instanceof CFOutput) {
                    ((CFOutput)this.out).cfoutput(false);
                }
            }
            catch (Exception e) {
                throw new DocumentTagException((Throwable)e);
            }
            return 0;
        }
        if (!this.evalAtPrint) {
            DocumentScope docScope = (DocumentScope)((Object)this.fContext.hiddenScope.get((Object)"CFDOCUMENT"));
            docScope.put("CURRENTPAGENUMBER", "{currentpagenumber}");
            docScope.put("TOTALPAGECOUNT", "{totalpagecount}");
            docScope.put("CURRENTSECTIONPAGENUMBER", "{currentsectionpagenumber}");
            docScope.put("TOTALSECTIONPAGECOUNT", "{totalsectionpagecount}");
        }
        return 2;
    }

    public int doAfterBody() throws DocumentTagException {
        return 0;
    }

    public int doEndTag() throws DocumentTagException {
        if (this.funcName != null) {
            HeaderFooterContentProvider contentProvider;
            if (this.evalAtPrint) {
                contentProvider = new HeaderFooterContentProviderImpl(this.pageContext, this.funcName, this.extraAttributes);
            } else {
                try {
                    contentProvider = new StaticHeaderFooterContentProvider(this.pageContext, this.funcName, this.extraAttributes);
                }
                catch (Throwable th) {
                    throw new DocumentTagException(th);
                }
            }
            if (this.parentTag instanceof DocumentSectionTag) {
                if (this.type.equalsIgnoreCase("header")) {
                    ((DocumentSectionTag)this.parentTag).setHeaderContentProvider(contentProvider);
                } else {
                    ((DocumentSectionTag)this.parentTag).setFooterContentProvider(contentProvider);
                }
            } else if (this.parentTag instanceof DocumentTag) {
                if (this.type.equalsIgnoreCase("header")) {
                    ((DocumentTag)this.parentTag).setHeaderContentProvider(contentProvider);
                } else {
                    ((DocumentTag)this.parentTag).setFooterContentProvider(contentProvider);
                }
            } else {
                throw new DocumentMissingParentTagException();
            }
            if (!this.evalAtPrint) {
                DocumentScope docScope = (DocumentScope)((Object)this.fContext.hiddenScope.get((Object)"CFDOCUMENT"));
                docScope.clear();
            }
        }
        this.onTagEnd();
        return 6;
    }

    public void setFunctionName(String funcName) {
        this.funcName = funcName;
    }

    public void release() {
        this.type = null;
        this.funcName = null;
        this.extraAttributes = null;
        this.evalAtPrint = false;
        super.release();
    }
}

