/*
 * Decompiled with CFR 0.152.
 */
package com.zingchart;

import com.zingchart.Utils;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.TreeMap;
import org.mozilla.javascript.ScriptableObject;

public class CanvasGradient
extends ScriptableObject {
    private static final long serialVersionUID = 438270592527335643L;
    private boolean radial;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float r1;
    private float r2;
    private TreeMap<Float, String> stops = new TreeMap();
    private Paint paint;

    @Override
    public String getClassName() {
        return "CanvasGradient";
    }

    public void jsConstructor(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x1 = (float)d;
        this.y1 = (float)d2;
        this.r1 = (float)d3;
        this.x2 = (float)d4;
        this.y2 = (float)d5;
        this.r2 = (float)d6;
        if (this.x1 == this.x2) {
            this.x2 += 1.0f;
        }
        if (this.y1 == this.y2) {
            this.y2 += 1.0f;
        }
        this.radial = d3 != -1.0 || d6 != -1.0;
    }

    public void jsFunction_addColorStop(double d, String string) {
        if (this.radial && this.r1 > 0.0f) {
            if (this.stops.size() == 0 && d == 0.0) {
                this.stops.put(new Float(d), string);
            }
            d = d * (double)(this.r2 - this.r1) / (double)this.r2 + (double)(this.r1 / this.r2);
        }
        if (this.stops.get(new Float(d)) != null) {
            d += d / 1000.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.stops.put(new Float(d), string);
    }

    public Paint getPaint() {
        float[] fArray = new float[this.stops.size()];
        Color[] colorArray = new Color[this.stops.size()];
        int n = 0;
        for (Map.Entry<Float, String> entry : this.stops.entrySet()) {
            fArray[n] = Float.parseFloat(((Object)entry.getKey()).toString());
            colorArray[n] = Utils.parseColor(entry.getValue().toString());
            ++n;
        }
        this.paint = this.radial ? new RadialGradientPaint(new Point2D.Float(this.x1, this.y1), this.r2, fArray, colorArray) : new LinearGradientPaint(this.x1, this.y1, this.x2, this.y2, fArray, colorArray);
        return this.paint;
    }
}

