/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.utils;

import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.request.IAMPolicyBindingRequest;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import com.google.iam.v1.Binding;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class PubSubServiceUtils {
    private static FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isNullOrEmpty(Object value) {
        return value == null || value instanceof String && ((String)value).trim().length() == 0;
    }

    public static List<String> getListOfStringsFromCommaSeparatedString(String input) {
        if (PubSubServiceUtils.isNullOrEmpty(input)) {
            return Collections.emptyList();
        }
        return Arrays.stream(input.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static String toUppercase(String input) {
        if (!PubSubServiceUtils.isNullOrEmpty(input)) {
            input = input.toUpperCase();
        }
        return input;
    }

    public static String getResourceIdFromResourceName(String resourceName) {
        String resourceId = null;
        if (Objects.nonNull(resourceName)) {
            String[] pieces = resourceName.split("/");
            resourceId = pieces[pieces.length - 1];
        }
        return resourceId;
    }

    public static List<String> getResourceIdList(Iterable<String> resourceNames) {
        if (resourceNames == null) {
            Collections.emptyList();
        }
        List<String> resourceIds = StreamSupport.stream(resourceNames.spliterator(), false).collect(Collectors.toList());
        return resourceIds;
    }

    public static OleDateTime getOleDateTimeFromTimestamp(Timestamp timestamp) {
        Instant instant = Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        Date date = Date.from(instant);
        return new OleDateTime(date);
    }

    public static Timestamp getTimestampFromOleDateTime(Date date) {
        Instant instant = date.toInstant();
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public static Struct deserialize(Object object) {
        Struct response = new Struct();
        if (Objects.nonNull(object)) {
            response = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson(object);
        }
        return response;
    }

    public static List<Binding> getPolicyBindings(List<IAMPolicyBindingRequest> bindings) {
        ArrayList<Binding> newBindings = new ArrayList<Binding>();
        if (Objects.nonNull(bindings)) {
            for (IAMPolicyBindingRequest binding : bindings) {
                Binding newBinding = binding.getBindingBuilder().build();
                newBindings.add(newBinding);
            }
        }
        return newBindings;
    }

    public static Map<String, String> getUpdatedLabels(Map<String, String> existingLabels, Map<String, String> newLabels) {
        HashMap<String, String> clonedLabels = new HashMap<String, String>(existingLabels);
        newLabels = cast.getGCPLabelsMapProperty(newLabels, "labels");
        clonedLabels.putAll(newLabels);
        return clonedLabels;
    }

    public static void validateDurationRange(long l, long minRange, long maxRange, String fieldName, String value, String lowerBound, String upperBound) {
        if (l < minRange || l > maxRange) {
            throw new ValidationException(RB.getString(PubSubClientImpl.class, (String)"DURATION_INVALID_RANGE", (Object)fieldName, (Object)value, (Object)lowerBound, (Object)upperBound));
        }
    }

    public static void validateDurationLowerRange(long l, long minRange, String fieldName, String value, String lowerBound) {
        if (l < minRange) {
            throw new ValidationException(RB.getString(PubSubClientImpl.class, (String)"DURATION_INVALID_LOWER_RANGE", (Object)fieldName, (Object)value, (Object)lowerBound));
        }
    }

    public static int getHashcode(int hashCode) {
        if (hashCode < 0) {
            hashCode ^= 0xFFFFFFFF;
        }
        return hashCode;
    }
}

