/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.request;

import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorProviderRequest {
    private Integer threadCount;
    private String threadNamePrefix = "cf-gcppubsub";
    private transient InstantiatingExecutorProvider.Builder executorProviderBuilder = InstantiatingExecutorProvider.newBuilder();

    public Integer getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
        this.executorProviderBuilder.setExecutorThreadCount(this.threadCount.intValue());
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        if (!PubSubServiceUtils.isNullOrEmpty(threadNamePrefix)) {
            this.threadNamePrefix = threadNamePrefix.trim();
        }
        ThreadFactory threadFactory = this.getThreadFactory();
        this.executorProviderBuilder.setThreadFactory(threadFactory);
    }

    private ThreadFactory getThreadFactory() {
        if (!this.threadNamePrefix.endsWith("-")) {
            this.threadNamePrefix = this.threadNamePrefix + "-";
        }
        return new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(ExecutorProviderRequest.this.threadNamePrefix + this.threadCount.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public InstantiatingExecutorProvider.Builder toBuilder() {
        return this.executorProviderBuilder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutorProviderRequest that = (ExecutorProviderRequest)o;
        return Objects.equals(this.getThreadCount(), that.getThreadCount()) && Objects.equals(this.getThreadNamePrefix(), that.getThreadNamePrefix());
    }

    public int hashCode() {
        return Objects.hash(this.getThreadCount(), this.getThreadNamePrefix());
    }
}

