/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.impl;

import coldfusion.cloud.gcp.pubsub.PubSubClient;
import coldfusion.cloud.gcp.pubsub.PubSubSubscription;
import coldfusion.cloud.gcp.pubsub.PubSubTopic;
import coldfusion.cloud.gcp.pubsub.ResourceType;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.request.TopicMetadataSchemaSettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.runtime.Struct;
import coldfusion.runtime.async.Future;
import coldfusion.util.RB;
import com.google.api.client.util.Lists;
import com.google.protobuf.ProtocolStringList;
import com.google.pubsub.v1.Encoding;
import com.google.pubsub.v1.MessageStoragePolicy;
import com.google.pubsub.v1.SchemaSettings;
import com.google.pubsub.v1.Topic;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PubSubTopicImpl
implements PubSubTopic {
    private final PubSubClient pubsubClient;
    private Topic topic;
    private String topicName;
    private String topicId;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public PubSubTopicImpl(PubSubClient pubsubClient, Topic topic) {
        this.pubsubClient = pubsubClient;
        this.topic = topic;
        if (this.topic != null) {
            this.topicName = topic.getName();
            this.topicId = PubSubServiceUtils.getResourceIdFromResourceName(this.topicName);
        }
    }

    @Override
    public String getId() {
        return this.topicId;
    }

    @Override
    public String getName() {
        return this.topicName;
    }

    @Override
    public void setLabels(Map<String, String> labels) {
        Struct topicUpdateOptions = new Struct();
        topicUpdateOptions.put("labels", labels);
        this.updateTopic((Map)topicUpdateOptions);
    }

    @Override
    public void addLabels(Map<String, String> newLabels) {
        if (newLabels == null || newLabels.isEmpty()) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"LABEL_NULL_OR_EMPTY_ERROR"));
        }
        Map<String, String> existingLabels = this.getLabels();
        Map<String, String> updatedLabels = PubSubServiceUtils.getUpdatedLabels(existingLabels, newLabels);
        this.setLabels(updatedLabels);
    }

    @Override
    public Map<String, String> getLabels() {
        return this.topic.getLabelsMap();
    }

    @Override
    public void setKmsKeyName(String keyName) {
        Struct topicUpdateOptions = new Struct();
        topicUpdateOptions.put("kmsKeyName", keyName);
        this.updateTopic((Map)topicUpdateOptions);
    }

    @Override
    public String getKmsKeyName() {
        return this.topic.getKmsKeyName();
    }

    @Override
    public void setMessageRetentionDuration(String duration) {
        Struct topicUpdateOptions = new Struct();
        topicUpdateOptions.put("messageRetentionDuration", duration);
        this.updateTopic((Map)topicUpdateOptions);
    }

    @Override
    public String getMessageRetentionDuration() {
        return FieldTypecastUtil.toDurationString((long)this.topic.getMessageRetentionDuration().getSeconds());
    }

    @Override
    public void setMessageStoragePolicy(List<String> messageStoragePolicy) {
        Struct topicUpdateOptions = new Struct();
        topicUpdateOptions.put("messageStoragePolicy", messageStoragePolicy);
        this.updateTopic((Map)topicUpdateOptions);
    }

    @Override
    public List<String> getMessageStoragePolicy() {
        MessageStoragePolicy messageStoragePolicy = this.topic.getMessageStoragePolicy();
        ProtocolStringList allowedPersistenceRegionsList = messageStoragePolicy.getAllowedPersistenceRegionsList();
        Iterator iterator = allowedPersistenceRegionsList.iterator();
        return Lists.newArrayList((Iterator)iterator);
    }

    @Override
    public Struct getSchemaSettings() {
        TopicMetadataSchemaSettingsRequest schema = null;
        SchemaSettings schemaSettings = this.topic.getSchemaSettings();
        if (schemaSettings.getEncoding() != Encoding.ENCODING_UNSPECIFIED && schemaSettings.getEncoding() != Encoding.UNRECOGNIZED) {
            schema = new TopicMetadataSchemaSettingsRequest();
            schema.setSchemaName(PubSubServiceUtils.getResourceIdFromResourceName(schemaSettings.getSchema()));
            schema.setSchemaEncoding(schemaSettings.getEncoding());
        }
        return PubSubServiceUtils.deserialize(schema);
    }

    @Override
    public void delete() {
        this.pubsubClient.deleteTopic(this.getId());
    }

    @Override
    public Struct getIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.put("resourceName", this.getId());
            policyMap.put("resourceType", ResourceType.TOPIC);
        }
        return this.pubsubClient.getIAMPolicy(policyMap);
    }

    @Override
    public Struct addIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.putIfAbsent("resourceName", this.getId());
            policyMap.putIfAbsent("resourceType", ResourceType.TOPIC);
        }
        return this.pubsubClient.addIAMPolicy(policyMap);
    }

    @Override
    public Struct testIAMPermissions(Map permissionsMap) {
        if (Objects.nonNull(permissionsMap)) {
            permissionsMap.putIfAbsent("resourceName", this.getId());
            permissionsMap.putIfAbsent("resourceType", ResourceType.TOPIC);
        }
        return this.pubsubClient.testIAMPermissions(permissionsMap);
    }

    @Override
    public Struct setIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.putIfAbsent("resourceName", this.getId());
            policyMap.putIfAbsent("resourceType", ResourceType.TOPIC);
        }
        return this.pubsubClient.setIAMPolicy(policyMap);
    }

    @Override
    public Future publish(Map messageMetadata) {
        Map processedMessageMetadata = this.processMessageMetadata(messageMetadata);
        return this.pubsubClient.publish(processedMessageMetadata);
    }

    @Override
    public Struct publishAllOutstanding() {
        return this.pubsubClient.publishAllOutstanding(this.getId());
    }

    @Override
    public Struct resumePublish(String orderingKey) {
        return this.pubsubClient.resumePublish(this.getId(), orderingKey);
    }

    @Override
    public PubSubSubscription subscribe(String subscriptionId) {
        Struct subscriptionMetadata = new Struct();
        subscriptionMetadata.putIfAbsent("subscriptionName", subscriptionId);
        return this.subscribe((Map)subscriptionMetadata);
    }

    @Override
    public PubSubSubscription subscribe(Map subscriptionMetadata) {
        if (Objects.nonNull(subscriptionMetadata)) {
            subscriptionMetadata.putIfAbsent("topicName", this.getId());
        }
        return this.pubsubClient.subscribe(subscriptionMetadata);
    }

    @Override
    public PubSubSubscription getSubscription(String subscriptionId) {
        return this.pubsubClient.getSubscription(subscriptionId);
    }

    @Override
    public Struct deleteSubscription(String subscriptionId) {
        return this.pubsubClient.deleteSubscription(subscriptionId);
    }

    @Override
    public Struct detachSubscription(String subscriptionId) {
        return this.pubsubClient.detachSubscription(subscriptionId);
    }

    @Override
    public PubSubSubscription updateSubscription(Map subscriptionMetadata) {
        PubSubSubscription subscription = null;
        if (Objects.nonNull(subscriptionMetadata)) {
            subscription = this.pubsubClient.updateSubscription(subscriptionMetadata);
        }
        return subscription;
    }

    @Override
    public Struct listSubscriptions() {
        return this.pubsubClient.listTopicSubscriptions(this.getId());
    }

    @Override
    public Struct listSubscriptions(Map listMetadata) {
        return this.pubsubClient.listTopicSubscriptions(this.getId(), listMetadata);
    }

    @Override
    public Struct listSnapshots() {
        return this.pubsubClient.listTopicSnapshots(this.getId());
    }

    @Override
    public Struct listSnapshots(Map listMetadata) {
        return this.pubsubClient.listTopicSnapshots(this.getId(), listMetadata);
    }

    @Override
    public boolean containsLabels(String key) {
        if (PubSubServiceUtils.isNullOrEmpty(key)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"LABEL_KEY_NULL_EMPTY"));
        }
        return this.topic.containsLabels(key);
    }

    @Override
    public Topic getTopic() {
        return this.topic;
    }

    private Map processMessageMetadata(Map messageMetadata) {
        if (Objects.nonNull(messageMetadata)) {
            if (messageMetadata.containsKey("data")) {
                Struct processedMessageMetadata = new Struct();
                processedMessageMetadata.put((Object)"topicName", (Object)this.getId());
                processedMessageMetadata.put((Object)"message", (Object)messageMetadata);
                return processedMessageMetadata;
            }
            messageMetadata.putIfAbsent("topicName", this.getId());
        }
        return messageMetadata;
    }

    private void updateTopic(Map topicUpdateOptions) {
        PubSubTopic pubsubTopic = this.pubsubClient.updateTopic(this.getId(), topicUpdateOptions);
        this.topic = pubsubTopic.getTopic();
    }
}

