/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.impl;

import coldfusion.cloud.gcp.pubsub.PubSubClient;
import coldfusion.cloud.gcp.pubsub.PubSubSnapshot;
import coldfusion.cloud.gcp.pubsub.ResourceType;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.Snapshot;
import java.util.Map;
import java.util.Objects;

public class PubSubSnapshotImpl
implements PubSubSnapshot {
    private final PubSubClient pubsubClient;
    private Snapshot snapshot;
    private String snapshotId;
    private String snapshotName;

    public PubSubSnapshotImpl(PubSubClient pubsubClient, Snapshot snapshot) {
        this.pubsubClient = pubsubClient;
        this.snapshot = snapshot;
        if (snapshot != null) {
            this.snapshotName = snapshot.getName();
            this.snapshotId = PubSubServiceUtils.getResourceIdFromResourceName(this.snapshotName);
        }
    }

    @Override
    public String getId() {
        return this.snapshotId;
    }

    @Override
    public String getName() {
        return this.snapshotName;
    }

    @Override
    public String getTopic() {
        return this.snapshot.getTopic();
    }

    @Override
    public OleDateTime getExpireTime() {
        Timestamp expireTime = this.snapshot.getExpireTime();
        return PubSubServiceUtils.getOleDateTimeFromTimestamp(expireTime);
    }

    @Override
    public boolean hasExpireTime() {
        return this.snapshot.hasExpireTime();
    }

    @Override
    public Map<String, String> getLabels() {
        return this.snapshot.getLabelsMap();
    }

    @Override
    public void setLabels(Map<String, String> labels) {
        Struct snapshotMetadata = new Struct();
        snapshotMetadata.put("snapshotName", this.getId());
        snapshotMetadata.put("labels", labels);
        PubSubSnapshot pubsubSnapshot = this.pubsubClient.updateSnapshot((Map)snapshotMetadata);
        this.snapshot = pubsubSnapshot.getSnapshot();
    }

    @Override
    public void addLabels(Map<String, String> newLabels) {
        if (newLabels == null || newLabels.isEmpty()) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"LABEL_NULL_OR_EMPTY_ERROR"));
        }
        Map<String, String> existingLabels = this.getLabels();
        Map<String, String> updatedLabels = PubSubServiceUtils.getUpdatedLabels(existingLabels, newLabels);
        this.setLabels(updatedLabels);
    }

    @Override
    public boolean containsLabels(String key) {
        if (PubSubServiceUtils.isNullOrEmpty(key)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"LABEL_KEY_NULL_EMPTY"));
        }
        return this.snapshot.containsLabels(key);
    }

    @Override
    public Struct delete() {
        return this.pubsubClient.deleteSnapshot(this.getId());
    }

    @Override
    public Struct getIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.put("resourceName", this.getId());
            policyMap.put("resourceType", ResourceType.SNAPSHOT);
        }
        return this.pubsubClient.getIAMPolicy(policyMap);
    }

    @Override
    public Struct addIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.put("resourceName", this.getId());
            policyMap.put("resourceType", ResourceType.SNAPSHOT);
        }
        return this.pubsubClient.addIAMPolicy(policyMap);
    }

    @Override
    public Struct testIAMPermissions(Map permissionsMap) {
        if (Objects.nonNull(permissionsMap)) {
            permissionsMap.put("resourceName", this.getId());
            permissionsMap.put("resourceType", ResourceType.SNAPSHOT);
        }
        return this.pubsubClient.testIAMPermissions(permissionsMap);
    }

    @Override
    public Struct setIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.put("resourceName", this.getId());
            policyMap.put("resourceType", ResourceType.SNAPSHOT);
        }
        return this.pubsubClient.setIAMPolicy(policyMap);
    }

    @Override
    public Snapshot getSnapshot() {
        return this.snapshot;
    }
}

