/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.impl;

import coldfusion.cloud.gcp.pubsub.PubSubClient;
import coldfusion.cloud.gcp.pubsub.PubSubSchema;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.runtime.Struct;
import com.google.pubsub.v1.Schema;
import java.util.Map;
import java.util.Objects;

public class PubSubSchemaImpl
implements PubSubSchema {
    private final PubSubClient pubsubClient;
    private final Schema schema;
    private String schemaId;
    private String schemaName;

    public PubSubSchemaImpl(PubSubClient pubsubClient, Schema schema) {
        this.pubsubClient = pubsubClient;
        this.schema = schema;
        if (schema != null) {
            this.schemaName = schema.getName();
            this.schemaId = PubSubServiceUtils.getResourceIdFromResourceName(this.schemaName);
        }
    }

    @Override
    public String getId() {
        return this.schemaId;
    }

    @Override
    public String getName() {
        return this.schemaName;
    }

    @Override
    public String getType() {
        return this.schema.getType().toString();
    }

    @Override
    public String getDefinition() {
        return this.schema.getDefinition();
    }

    @Override
    public Struct validateMessage(Map messageSchemaMetadata) {
        if (Objects.nonNull(messageSchemaMetadata)) {
            messageSchemaMetadata.putIfAbsent("schemaName", this.getId());
        }
        return this.pubsubClient.validateMessage(messageSchemaMetadata);
    }

    @Override
    public Struct delete() {
        return this.pubsubClient.deleteSchema(this.getId());
    }
}

