/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataExpirationPolicyRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.CFBooleanValidator;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import com.google.protobuf.util.Durations;
import java.util.Collections;

public enum SubscriptionMetadataExpirationPolicyRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<SubscriptionMetadataExpirationPolicyRequest> consumerMap = new ConsumerMap();

    private SubscriptionMetadataExpirationPolicyRequestConsumer() {
        this.consumerMap.put((Object)"enable", new ConsumerValidator((expirationPolicyRequest, value) -> expirationPolicyRequest.setEnabled(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"ttl", new ConsumerValidator((expirationPolicyRequest, value) -> {
            String val = this.cast.getStringProperty(value);
            if (val == null || val.trim().equalsIgnoreCase("never")) {
                expirationPolicyRequest.setClearTtl(true);
            } else {
                long seconds = this.cast.getDurationProperty(value, "ttl").getSeconds();
                PubSubServiceUtils.validateDurationLowerRange(seconds, 86400L, "ttl", (String)value, "1d");
                expirationPolicyRequest.setTtl(Durations.fromSeconds((long)seconds));
            }
        }, Collections.singletonList(NonEmptyStringValidator.INSTANCE)));
    }

    public ConsumerMap<SubscriptionMetadataExpirationPolicyRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

