/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.DeliveryType;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriptionMetadataBigQueryConfigRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriptionMetadataPushConfigRequestConsumer;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataBigQueryConfigRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataDeliveryConfigRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataPushConfigRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.CFStructValidator;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.cloud.validator.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum SubscriptionMetadataDeliveryConfigRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<SubscriptionMetadataDeliveryConfigRequest> consumerMap = new ConsumerMap();
    private final List<Validator> validators = Arrays.asList(NotNullValidator.INSTANCE, new GenericEnumValidator(DeliveryType.class, "type"));

    private SubscriptionMetadataDeliveryConfigRequestConsumer() {
        this.consumerMap.put((Object)"type", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            String deliveryType = PubSubServiceUtils.toUppercase(this.cast.getStringProperty(value));
            subscriptionMetadataRequest.setType(DeliveryType.valueOf(deliveryType));
        }, this.validators));
        this.consumerMap.put((Object)"pushConfig", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            SubscriptionMetadataPushConfigRequest pushConfig = new SubscriptionMetadataPushConfigRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)pushConfig, this.cast.getMapProperty(value, "pushConfig"), SubscriptionMetadataPushConfigRequestConsumer.INSTANCE.getConsumerMap());
            subscriptionMetadataRequest.setPushConfig(pushConfig);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"bigQueryConfig", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            SubscriptionMetadataBigQueryConfigRequest bigQueryConfig = new SubscriptionMetadataBigQueryConfigRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)bigQueryConfig, this.cast.getMapProperty(value, "bigQueryConfig"), SubscriptionMetadataBigQueryConfigRequestConsumer.INSTANCE.getConsumerMap());
            subscriptionMetadataRequest.setBigQueryConfig(bigQueryConfig);
        }, Collections.emptyList()));
    }

    public ConsumerMap<SubscriptionMetadataDeliveryConfigRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

