/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.request.SchemaMetadataRequest;
import coldfusion.cloud.gcp.validator.GCPResourceNameValidator;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.cloud.validator.Validator;
import com.google.pubsub.v1.Schema;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum SchemaMetadataRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<SchemaMetadataRequest> consumerMap = new ConsumerMap();
    private final List<Validator> typeValidators = Arrays.asList(NotNullValidator.INSTANCE, new GenericEnumValidator(Schema.Type.class, "type"));

    private SchemaMetadataRequestConsumer() {
        this.consumerMap.put((Object)"schemaName", new ConsumerValidator((schemaMetadataRequest, value) -> schemaMetadataRequest.setSchemaId(this.cast.getStringProperty(value)), Arrays.asList(NotNullValidator.INSTANCE, GCPResourceNameValidator.SCHEMA)));
        this.consumerMap.put((Object)"type", new ConsumerValidator((schemaMetadataRequest, value) -> {
            String type = this.cast.getStringProperty(value);
            Schema.Type schemaType = Schema.Type.valueOf((String)type.toUpperCase());
            schemaMetadataRequest.setSchemaType(schemaType);
        }, this.typeValidators));
        this.consumerMap.put((Object)"definition", new ConsumerValidator((schemaMetadataRequest, value) -> schemaMetadataRequest.setSchemaDefinition(this.cast.getStringProperty(value)), Collections.singletonList(NotNullValidator.INSTANCE)));
    }

    public ConsumerMap<SchemaMetadataRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

