/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.request.PaginatedMetadataRequest;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.CFNonNegativeIntegerValidator;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.IntegerRangeValidator;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import com.google.pubsub.v1.SchemaView;
import java.util.Arrays;
import java.util.Collections;

public enum PaginatedMetadataRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<PaginatedMetadataRequest> consumerMap = new ConsumerMap();

    private PaginatedMetadataRequestConsumer() {
        this.consumerMap.put((Object)"pageSize", new ConsumerValidator((paginatedMetadataRequest, value) -> paginatedMetadataRequest.setPageSize(this.cast.getIntegerProperty(value)), Arrays.asList(new CFNonNegativeIntegerValidator("pageSize"), new IntegerRangeValidator("pageSize", Integer.valueOf(0), Integer.valueOf(1000)))));
        this.consumerMap.put((Object)"nextPageToken", new ConsumerValidator((paginatedMetadataRequest, value) -> paginatedMetadataRequest.setNextPageToken(this.cast.getStringProperty(value)), Collections.singletonList(NonEmptyStringValidator.INSTANCE)));
        this.consumerMap.put((Object)"schemaView", new ConsumerValidator((paginatedMetadataRequest, value) -> {
            String schemaView = this.cast.getStringProperty(value);
            SchemaView view = SchemaView.valueOf((String)schemaView.toUpperCase());
            paginatedMetadataRequest.setSchemaView(view);
        }, Collections.singletonList(new GenericEnumValidator(SchemaView.class, "schemaView"))));
    }

    public ConsumerMap<PaginatedMetadataRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

