/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.ResourceType;
import coldfusion.cloud.gcp.pubsub.request.IAMPermissionTestRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.cloud.validator.Validator;
import java.util.Arrays;
import java.util.List;

public enum IAMPermissionTestRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<IAMPermissionTestRequest> consumerMap = new ConsumerMap();
    private final List<Validator> validators = Arrays.asList(NotNullValidator.INSTANCE, new GenericEnumValidator(ResourceType.class, "resourceType"));

    private IAMPermissionTestRequestConsumer() {
        this.consumerMap.put((Object)"resourceName", new ConsumerValidator((iamPolicyRequest, value) -> iamPolicyRequest.setResourceName(this.cast.getStringProperty(value)), Arrays.asList(NotNullValidator.INSTANCE, NonEmptyStringValidator.INSTANCE)));
        this.consumerMap.put((Object)"resourceType", new ConsumerValidator((iamPolicyRequest, value) -> {
            String resourceType = PubSubServiceUtils.toUppercase(this.cast.getStringProperty(value));
            iamPolicyRequest.setResourceType(ResourceType.valueOf(resourceType));
        }, this.validators));
        this.consumerMap.put((Object)"permissions", new ConsumerValidator((testIAMPermissionRequest, values) -> {
            List permissionsList = this.cast.getStringListProperty(values);
            testIAMPermissionRequest.setPermissions(permissionsList);
        }, Arrays.asList(NotNullValidator.INSTANCE, new EmptyListValidator("permissions"))));
    }

    public ConsumerMap<IAMPermissionTestRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

