/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.LimitExceededBehaviorType;
import coldfusion.cloud.gcp.pubsub.request.FlowControlSettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.CFNonNegativeLongValidator;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.NotNullValidator;
import com.google.api.gax.batching.FlowController;
import java.util.Arrays;
import java.util.Collections;

public enum FlowControlSettingsRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<FlowControlSettingsRequest> consumerMap = new ConsumerMap();

    private FlowControlSettingsRequestConsumer() {
        this.consumerMap.put((Object)"limitExceededBehavior", new ConsumerValidator((flowControlSettingsBuilder, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                String limitExceededBehavior = PubSubServiceUtils.toUppercase(this.cast.getStringProperty(value));
                String input = LimitExceededBehaviorType.valueOf(limitExceededBehavior).toString();
                flowControlSettingsBuilder.setLimitExceededBehavior(FlowController.LimitExceededBehavior.valueOf((String)input));
            }
        }, Collections.singletonList(new GenericEnumValidator(FlowController.LimitExceededBehavior.class, "limitExceededBehavior"))));
        this.consumerMap.put((Object)"maxOutstandingElementCount", new ConsumerValidator((flowControlSettingsBuilder, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                flowControlSettingsBuilder.setMaxOutstandingElementCount(this.cast.getLongProperty(value));
            }
        }, Arrays.asList(NotNullValidator.INSTANCE, new CFNonNegativeLongValidator("maxOutstandingElementCount"))));
        this.consumerMap.put((Object)"maxOutstandingRequestBytes", new ConsumerValidator((flowControlSettingsBuilder, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                flowControlSettingsBuilder.setMaxOutstandingRequestBytes(this.cast.getLongProperty(value));
            }
        }, Arrays.asList(NotNullValidator.INSTANCE, new CFNonNegativeLongValidator("maxOutstandingRequestBytes"))));
    }

    public ConsumerMap<FlowControlSettingsRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

