/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.request.ExecutorProviderRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.CFPositiveIntegerValidator;
import java.util.Collections;

public enum ExecutorProviderRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<ExecutorProviderRequest> consumerMap = new ConsumerMap();

    private ExecutorProviderRequestConsumer() {
        this.consumerMap.put((Object)"threadCount", new ConsumerValidator((executorProvider, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                executorProvider.setThreadCount(this.cast.getIntegerProperty(value));
            }
        }, Collections.singletonList(new CFPositiveIntegerValidator("threadCount"))));
        this.consumerMap.put((Object)"threadNamePrefix", new ConsumerValidator((executorProvider, value) -> executorProvider.setThreadNamePrefix(this.cast.getStringProperty(value)), Collections.emptyList()));
    }

    public ConsumerMap<ExecutorProviderRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

