/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.sharepoint;

import coldfusion.sharepoint.SharepointManager;
import coldfusion.sharepoint.SharepointObject;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.net.sharepoint.SharepointExceptions;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharepointTag
extends GenericTag {
    protected String username = null;
    protected String password = null;
    protected String wsdl = null;
    protected String name = null;
    protected String action = null;
    protected String domain = null;
    protected Map login = null;
    protected Map params = new HashMap();
    protected String workstation = null;
    protected String authtype = null;
    protected String ntlmdomain = null;
    protected static final String BASIC_AUTH = "BASIC";
    protected static final String NTLM_AUTH = "NTLM";
    private static final GenericTagPermission tp = new GenericTagPermission("cfsharepoint");

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setLogin(Map login) {
        this.login = login;
    }

    public Map getLogin() {
        return this.login;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public Map getParams() {
        return this.params;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    protected Permission getPermission() {
        return tp;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public String getAuthtype() {
        return this.authtype;
    }

    public void setAuthtype(String authtype) {
        this.authtype = authtype;
    }

    public String getNtlmdomain() {
        return this.ntlmdomain;
    }

    public void setNtlmdomain(String ntlmdomain) {
        this.ntlmdomain = ntlmdomain;
    }

    public int doStartTag() {
        this.onTagStart();
        this.validateParams();
        if (this.login != null) {
            this.username = (String)this.login.get("username");
            this.password = (String)this.login.get("password");
            this.domain = (String)this.login.get("domain");
            this.workstation = (String)this.login.get("workstation");
            this.authtype = (String)this.login.get("authtype");
            this.ntlmdomain = (String)this.login.get("ntlmdomain");
        }
        SharepointObject sp = new SharepointObject(this.username, this.password, this.wsdl, this.action, this.domain, this.params, this.workstation, this.authtype, this.ntlmdomain);
        SharepointManager manager = new SharepointManager(sp, this.pageContext);
        manager.executeAction(this.name);
        List tagAttributes = this.captureAttributes(Arrays.asList("action", "domain", "ntlmdomain", "auth_type"), Arrays.asList(this.convertUpperCase(this.action), this.convertUpperCase(this.domain), this.convertUpperCase(this.ntlmdomain), this.convertUpperCase(this.authtype)));
        this.onTagEnd(tagAttributes);
        return 0;
    }

    private void validateParams() {
        if (this.login == null && this.username == null && this.password == null && this.domain == null) {
            SharepointExceptions.throwInvalidCredentialsException();
        }
        if (this.login != null && (this.login.get("username") == null || this.login.get("password") == null || this.login.get("domain") == null)) {
            SharepointExceptions.throwInvalidLoginKeysException();
        }
        if (this.authtype != null) {
            if (!(this.authtype.equalsIgnoreCase(BASIC_AUTH) || this.authtype.equalsIgnoreCase(NTLM_AUTH) || this.authtype.equalsIgnoreCase("none"))) {
                SharepointExceptions.throwInvalidAuthTypeException();
            } else if (this.authtype != null && BASIC_AUTH.equalsIgnoreCase(this.authtype) && (this.ntlmdomain != null || this.workstation != null)) {
                SharepointExceptions.throwBasicAuthAttributeException();
            }
        }
    }

    public void release() {
        this.login = null;
        this.username = null;
        this.password = null;
        this.name = null;
        this.wsdl = null;
        this.domain = null;
        this.action = null;
        this.params = null;
        this.authtype = null;
        this.ntlmdomain = null;
        this.workstation = null;
    }
}

