/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Properties;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilResource;
import macromedia.slutil.UtilResourceLocator;
import macromedia.slutil.UtilTransliteratorForASCII;
import macromedia.slutil.UtilTransliteratorForUCS2;
import macromedia.slutil.UtilTransliteratorForUTF8;
import macromedia.slutil.UtilTransliteratorUsingICUTable;
import macromedia.slutil.UtilTransliteratorUsingSunIO;
import macromedia.slutil.UtilTransliteratorUsingTable;
import macromedia.slutil.UtilTransliteratorUsingVM;
import macromedia.slutil.UtilTransliteratorWithFixup;

public abstract class UtilTransliterator {
    public boolean supportByteArrayToByteArrayDecode = false;
    protected static String EMPTY_STRING = "";
    protected int streamChunkSize = 256;
    private static int DEFAULT_CACHE_SIZE = 256;
    protected byte[] bytesCache;
    protected char[] charsCache;
    private Reader _r;
    private static Properties CachedProperties;

    public abstract boolean isFixedBytesPerChar();

    public abstract int getMaxBytesPerChar();

    public abstract int getMaxCharsPerByte();

    public abstract byte[] encode(String var1) throws UtilException;

    public abstract byte[] encode(String var1, int[] var2) throws UtilException;

    public abstract void encode(InputStream var1, int var2, OutputStream var3) throws UtilException;

    public abstract void encode(Reader var1, int var2, OutputStream var3) throws UtilException;

    public abstract String decode(byte[] var1, int var2, int var3) throws UtilException;

    public int decode(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws UtilException {
        String[] stringArray = new String[]{"decode(byte[] src, int srcOffset, int srcLength, byte dest [], int destOffset). Check the value of the 'supportByteArrayToByteArrayDecode' flag before calling this method."};
        throw new UtilException(1038, stringArray);
    }

    public abstract int decode(byte[] var1, int var2, int var3, char[] var4) throws UtilException;

    public abstract String decode(byte[] var1, int var2, int var3, int var4) throws UtilException;

    public synchronized InputStream decodeAsAsciiStream(InputStream inputStream) throws UtilException {
        this._r = this.decodeAsReader(inputStream);
        return new InputStream(){
            private Reader r;
            private char[] chars;
            {
                this.r = UtilTransliterator.this._r;
            }

            public int read() throws IOException {
                int n2 = this.r.read();
                if (n2 == -1) {
                    return -1;
                }
                return n2 & 0xFF;
            }

            public int read(byte[] byArray, int n2, int n3) throws IOException {
                int n4;
                if (this.chars == null || this.chars.length < n3) {
                    this.chars = new char[n3];
                }
                if ((n4 = this.r.read(this.chars, 0, n3)) == -1 || n4 == 0) {
                    return n4;
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    byArray[i2 + n2] = (byte)this.chars[i2];
                }
                return n4;
            }

            public void close() throws IOException {
                this.r.close();
            }
        };
    }

    public abstract Reader decodeAsReader(InputStream var1) throws UtilException;

    public void setDefaultCacheSize() {
        this.setCacheSize(DEFAULT_CACHE_SIZE);
    }

    public void setCacheSize(int n2) {
        if (this.charsCache == null || n2 > this.charsCache.length) {
            int n3 = this.getMaxBytesPerChar();
            if (n3 == 0) {
                n3 = 1;
            }
            this.bytesCache = new byte[n3 * n2];
            n3 = this.getMaxCharsPerByte();
            if (n3 == 0) {
                n3 = 1;
            }
            this.charsCache = new char[n3 * n2];
        }
    }

    public byte[] getBytesCache() {
        return this.bytesCache;
    }

    public char[] getCharsCache() {
        return this.charsCache;
    }

    private static String DeComment(String string) {
        int n2 = string.indexOf(32);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if ((n2 = string.indexOf(9)) != -1) {
            string = string.substring(0, n2);
        }
        if ((n2 = string.indexOf(35)) != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    private static boolean IsNumeric(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '0') {
                return false;
            }
            if (c2 <= '9') continue;
            return false;
        }
        return true;
    }

    public static UtilTransliterator GetNewTransliterator(String string) throws UtilException {
        return UtilTransliterator.GetNewTransliterator(string, 0, 0);
    }

    public static UtilTransliterator GetNewTransliterator(String string, int n2, int n3) throws UtilException {
        Object object;
        if (CachedProperties == null) {
            object = new UtilResource(new UtilResourceLocator().getClass(), "transliteration.properties");
            CachedProperties = ((UtilResource)object).getAsProperties();
        }
        if (string.equalsIgnoreCase("VMMS932")) {
            try {
                return new UtilTransliteratorUsingVM("MS932");
            }
            catch (UtilException utilException) {
                string = "932";
            }
        }
        object = (object = CachedProperties.getProperty("translit.alias." + string.toUpperCase())) != null ? UtilTransliterator.DeComment((String)object) : (string.startsWith("CP") ? "Cp" + string.substring(2) : (UtilTransliterator.IsNumeric(string) ? "Cp" + string : string));
        if (n2 != 0 || n3 != 0) {
            return new UtilTransliteratorWithFixup((String)object, n2, n3);
        }
        String string2 = "VM";
        boolean bl2 = true;
        if (((String)object).equals("ASCII")) {
            string2 = "ASCII";
        } else if (((String)object).equals("UTF-8")) {
            string2 = "UTF8";
        } else if (((String)object).equals("UTF-16BE")) {
            string2 = "UCS2";
        } else if (((String)object).equals("UTF-16LE")) {
            string2 = "UCS2";
            bl2 = false;
        } else if (((String)object).equals("UCS2")) {
            string2 = "UCS2";
        }
        Object object2 = CachedProperties.getProperty("translit.name." + (String)object);
        String string3 = CachedProperties.getProperty("translit.type." + (String)object);
        if (object2 == null) {
            object2 = object;
        }
        if (string3 == null) {
            string3 = string2;
        }
        if ("TABLE".equals(string3)) {
            String string4 = (String)object2 + ".t";
            return new UtilTransliteratorUsingTable(string4);
        }
        if ("ICU_TABLE".equals(string3)) {
            String string5 = (String)object2 + ".t";
            return new UtilTransliteratorUsingICUTable(string5);
        }
        if ("CLASS".equals(string3)) {
            try {
                Class<?> clazz = Class.forName((String)object2);
                return (UtilTransliterator)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UtilException(1006, (String)object2);
            }
            catch (Exception exception) {
                throw new UtilException(1010, (String)object2);
            }
        }
        if ("FORCEVM".equalsIgnoreCase(string3)) {
            return new UtilTransliteratorUsingVM((String)object2);
        }
        if ("VM".equals(string3)) {
            String string6 = CachedProperties.getProperty("AllowVMasSUNIO");
            if (string6 == null || "TRUE".equalsIgnoreCase(string6)) {
                return UtilTransliterator.OptimizeNewTransliteratorUsingVM((String)object2, CachedProperties);
            }
            return new UtilTransliteratorUsingVM((String)object2);
        }
        if ("SUNIO".equals(string3)) {
            String string7 = CachedProperties.getProperty("AllowSUNIOasTABLE");
            if (string7 == null || "TRUE".equalsIgnoreCase(string7)) {
                return UtilTransliterator.OptimizeNewTransliteratorUsingSunIO((String)object2, CachedProperties);
            }
            return new UtilTransliteratorUsingSunIO((String)object2);
        }
        if ("ASCII".equals(string3)) {
            return new UtilTransliteratorForASCII();
        }
        if ("UCS2".equals(string3)) {
            UtilTransliteratorForUCS2 utilTransliteratorForUCS2 = new UtilTransliteratorForUCS2();
            if (!bl2) {
                utilTransliteratorForUCS2.setToLittleEndian();
            }
            return utilTransliteratorForUCS2;
        }
        if ("UTF8".equals(string3)) {
            return new UtilTransliteratorForUTF8();
        }
        throw new UtilException(1004);
    }

    private static UtilTransliterator OptimizeNewTransliteratorUsingVM(String string, Properties properties) throws UtilException {
        try {
            return UtilTransliterator.OptimizeNewTransliteratorUsingSunIO(string, properties);
        }
        catch (Exception exception) {
            return new UtilTransliteratorUsingVM(string);
        }
    }

    private static UtilTransliterator OptimizeNewTransliteratorUsingSunIO(String string, Properties properties) throws UtilException {
        UtilTransliteratorUsingTable utilTransliteratorUsingTable = UtilTransliteratorUsingTable.GetIfLoaded(string);
        if (utilTransliteratorUsingTable != null) {
            return utilTransliteratorUsingTable;
        }
        UtilTransliteratorUsingSunIO utilTransliteratorUsingSunIO = new UtilTransliteratorUsingSunIO(string);
        String string2 = properties.getProperty("AllowSUNIOasTABLE");
        if ((string2 == null || "TRUE".equalsIgnoreCase(string2)) && ((UtilTransliterator)utilTransliteratorUsingSunIO).getMaxBytesPerChar() == 1) {
            byte[] byArray = new byte[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                byArray[i2] = (byte)i2;
            }
            String string3 = ((UtilTransliterator)utilTransliteratorUsingSunIO).decode(byArray, 0, byArray.length);
            char[] cArray = string3.toCharArray();
            string3 = "?";
            byte[] byArray2 = ((UtilTransliterator)utilTransliteratorUsingSunIO).encode(string3);
            byte by2 = byArray2[0];
            return new UtilTransliteratorUsingTable(string, cArray, by2);
        }
        return utilTransliteratorUsingSunIO;
    }
}

