/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class UtilDataConversions {
    private static final char[] Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] CharsToBytes(String string, char[] cArray) throws UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        byte[] byArray = null;
        try {
            bufferedWriter.write(cArray, 0, cArray.length);
            bufferedWriter.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new UnsupportedEncodingException(iOException.getMessage());
        }
        return byArray;
    }

    public static String BytesToChars(String string, byte[] byArray) throws UnsupportedEncodingException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        while (bl2) {
            object = new char[300];
            try {
                int n2 = bufferedReader.read((char[])object, 0, ((char[])object).length);
                if (n2 > 0) {
                    stringBuffer.append((char[])object, 0, n2);
                    continue;
                }
                bl2 = false;
            }
            catch (IOException iOException) {
                throw new UnsupportedEncodingException(iOException.getMessage());
            }
        }
        object = stringBuffer.toString();
        return object;
    }

    public static String ASCIIBytesToString(byte[] byArray, int n2) {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)(byArray[i2] & 0xFF);
        }
        return new String(cArray);
    }

    public static String UCS2BytesToString(byte[] byArray, int n2) {
        char[] cArray = new char[n2 / 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            cArray[n4] = (char)((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF);
            n3 += 2;
            ++n4;
        }
        return new String(cArray);
    }

    public static String bytesToString(byte[] byArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(Digits[byArray[i2] >> 4 & 0xF]);
            stringBuffer.append(Digits[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static final String byteToHex(byte by2) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[by2 >> 4 & 0xF], cArray[by2 & 0xF]};
        return new String(cArray2);
    }

    public static final InputStream stringToASCIIInputStream(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        if (string != null) {
            char[] cArray = string.toCharArray();
            byte[] byArray = new byte[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                byArray[i2] = (byte)cArray[i2];
            }
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        return byteArrayInputStream;
    }
}

