/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseLongData;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilPagedTempBuffer;

public class BaseInputStreamWrapper
extends InputStream
implements BaseLongData {
    BaseConnection connection;
    Object synchronizer;
    InputStream is;
    long markPosition;
    boolean closed = false;
    long numTotalBytesInStream;
    long numBytesReturned = 0L;
    long maxBytesToReturn = Long.MAX_VALUE;
    boolean isOutputStream = true;
    UtilPagedTempBuffer cachedData;
    BaseExceptions exceptions;

    public BaseInputStreamWrapper(InputStream inputStream, long l2, BaseConnection baseConnection, BaseExceptions baseExceptions) {
        this.is = inputStream;
        this.exceptions = baseExceptions;
        this.numTotalBytesInStream = l2;
        this.connection = baseConnection;
        this.markPosition = 0L;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    void setIsInputStream() {
        this.isOutputStream = false;
    }

    void validateClosedState() throws IOException {
        if (this.closed || this.connection != null && this.connection.implConnection == null) {
            throw new IOException(this.exceptions.getException(6009).getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            return this.is.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.is.close();
                this.closed = true;
                if (this.cachedData != null) {
                    try {
                        this.cachedData.truncate(true);
                        this.cachedData = null;
                    }
                    catch (UtilException utilException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mark(int n2) {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.is.mark(n2);
                this.markPosition = this.numBytesReturned;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                return this.is.markSupported();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numBytesReturned == this.maxBytesToReturn) {
                return -1;
            }
            int n2 = this.is.read();
            if (this.numTotalBytesInStream != -1L) {
                boolean bl2 = false;
                if (n2 != -1) {
                    ++this.numBytesReturned;
                    if (this.numBytesReturned > this.numTotalBytesInStream) {
                        bl2 = true;
                    }
                } else if (this.numBytesReturned != this.numTotalBytesInStream) {
                    bl2 = true;
                }
                if (bl2) {
                    throw new IOException(this.exceptions.baseMessages.getMessage(6031, null, false));
                }
            } else if (n2 > -1) {
                ++this.numBytesReturned;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.read(byArray, 0, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numBytesReturned >= this.maxBytesToReturn) {
                return -1;
            }
            if (byArray.length - n2 < n3) {
                throw new IOException(this.exceptions.getException(6065).getMessage());
            }
            if (this.numBytesReturned + (long)n3 > this.maxBytesToReturn) {
                n3 = new Long(this.maxBytesToReturn - this.numBytesReturned).intValue();
            }
            int n4 = this.is.read(byArray, n2, n3);
            if (this.numTotalBytesInStream != -1L) {
                boolean bl2 = false;
                if (n4 != -1) {
                    this.numBytesReturned += (long)n4;
                    if (this.numBytesReturned > this.numTotalBytesInStream) {
                        bl2 = true;
                    }
                } else if (this.numBytesReturned != this.numTotalBytesInStream) {
                    bl2 = true;
                }
                if (bl2) {
                    throw new IOException(this.exceptions.baseMessages.getMessage(6031, null, false));
                }
            } else if (n4 > -1) {
                this.numBytesReturned += (long)n4;
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.is.reset();
            this.numBytesReturned = this.markPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.numBytesReturned += l2;
            return this.is.skip(l2);
        }
    }

    public long length() {
        return this.numTotalBytesInStream;
    }

    public long determineLength() throws SQLException {
        if (this.numTotalBytesInStream == -1L) {
            this.cache();
        }
        return this.numTotalBytesInStream;
    }

    public long cache() throws SQLException {
        try {
            this.cachedData = new UtilPagedTempBuffer(2048);
            this.numTotalBytesInStream = 0L;
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while (n2 != -1) {
                n2 = this.is.read(byArray);
                if (n2 == -1) continue;
                this.cachedData.write(this.numTotalBytesInStream, byArray, 0, n2);
                this.numTotalBytesInStream += (long)n2;
            }
            this.is.close();
            this.is = this.cachedData.getInputStream();
        }
        catch (IOException iOException) {
            throw this.exceptions.getException(iOException);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
        return this.numTotalBytesInStream;
    }
}

