/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.columns;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.columns.SequeLinkColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import macromedia.jdbc.sequelink.utilities.ObjectArray;
import macromedia.jdbc.slbase.BaseData;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.slutil.UtilException;

public class SequeLinkNumericColumn
extends SequeLinkColumn {
    private ObjectArray array = new ObjectArray();

    public SequeLinkNumericColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n2) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n2, 8);
    }

    protected void setBindInfo() {
        this.sqlnkType = 11;
        this.sqlnkSize = this.precision;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.array.add(sspInputStream.readSSPBcdType(this.scale));
    }

    protected void readNull() {
        this.array.add(null);
    }

    private String getValueString(int n2, String string, int n3) {
        StringBuffer stringBuffer;
        int n4 = string.length() - n3;
        if (n4 == 0) {
            return (n2 < 0 ? "-0." : "0.") + string;
        }
        if (n4 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n4, '.');
            if (n2 < 0) {
                stringBuffer.insert(0, '-');
            }
        } else {
            stringBuffer = new StringBuffer(3 - n4 + string.length());
            stringBuffer.append(n2 < 0 ? "-0." : "0.");
            for (int i2 = 0; i2 < -n4; ++i2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public BaseData getData(int n2, int n3, DiagnosticList diagnosticList) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.array.get(n3);
        if (bigDecimal != null && n2 == 10) {
            BigInteger bigInteger = bigDecimal.unscaledValue();
            String string = bigDecimal.scale() == 0 ? bigInteger.toString() : this.getValueString(bigDecimal.signum(), bigInteger.abs().toString(), bigDecimal.scale());
            this.myBaseData.setString(string);
        } else {
            this.myBaseData.setBigDecimal((BigDecimal)this.array.get(n3));
        }
        return this.myBaseData;
    }

    public void clearData() {
        this.array.reset();
    }
}

