/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import macromedia.jdbc.sequelink.SequeLinkConnection;
import macromedia.jdbc.sequelink.SequeLinkImplDatabaseMetaData;
import macromedia.jdbc.sequelink.SequeLinkImplStatement;
import macromedia.jdbc.slbase.BaseImplConnection;
import macromedia.jdbc.slbase.BaseImplStatement;
import macromedia.sequelink.ctxt.PidList;
import macromedia.sequelink.ctxt.conn.ConnectionContext;
import macromedia.sequelink.jdbc.ConnectAttributes;
import macromedia.sequelink.jdbc.Utils;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SlXid;
import macromedia.sequelink.ssp.SspLob;
import macromedia.sequelink.util.SlXaException;
import macromedia.sequelink.util.UnSyncVector;

public final class SequeLinkImplConnection
extends BaseImplConnection {
    ConnectionContext conCtxt;
    SequeLinkConnection con;
    private DiagnosticList diagnosticList;
    private boolean _rowidRetrieved;
    private String _rowidValue;
    private String[] _aggregateFunctions;
    private Boolean _supportsRowId;
    private Boolean _supportsLobsNatively;

    SequeLinkImplConnection(SequeLinkConnection sequeLinkConnection) {
        this.con = sequeLinkConnection;
        this.diagnosticList = new DiagnosticList();
    }

    private void addWarnings() {
        SQLWarning sQLWarning = this.diagnosticList.getSQLWarning();
        if (sQLWarning != null) {
            String[] stringArray = new String[]{sQLWarning.getMessage()};
            do {
                this.warnings.add(6001, stringArray, sQLWarning.getSQLState(), sQLWarning.getErrorCode());
            } while ((sQLWarning = sQLWarning.getNextWarning()) != null);
            this.diagnosticList.clear();
        }
    }

    public SequeLinkConnection getConnection() {
        return this.con;
    }

    public void open() throws SQLException {
        ConnectAttributes connectAttributes = this.getConnectAttributes();
        DriverPropertyInfo[] driverPropertyInfoArray = this.getDpis();
        for (int i2 = 0; i2 < driverPropertyInfoArray.length; ++i2) {
            String string = driverPropertyInfoArray[i2].name;
            String string2 = this.connectProps.get(string);
            if (string2 == null) continue;
            connectAttributes.setAttribute(string, string2);
        }
        this.conCtxt = new ConnectionContext(connectAttributes, null);
        this.conCtxt.connect(this.isXAConnection, this.diagnosticList);
        this.addWarnings();
        if (this.con.implDmd == null) {
            this.con.implDmd = new SequeLinkImplDatabaseMetaData(this);
        }
    }

    void doUnlock() throws SQLException {
        this.conCtxt.doUnlock(this.diagnosticList);
    }

    public void reset() throws SQLException {
        this.conCtxt.testAlive(this.diagnosticList);
    }

    protected void commitTransaction() throws SQLException {
        this.conCtxt.commit(this.diagnosticList);
        this.addWarnings();
    }

    protected void rollbackTransaction() throws SQLException {
        this.conCtxt.rollback(this.diagnosticList);
        this.addWarnings();
    }

    protected BaseImplStatement createImplStatement(int n2, int n3) throws SQLException {
        return new SequeLinkImplStatement(this);
    }

    public void close() throws SQLException {
        this.conCtxt.deactivate(this.diagnosticList);
        this.addWarnings();
        this.con.implDmd = null;
        this.con.implCon = null;
        this.con.ca = null;
        this.con.dpis = null;
    }

    protected void startManualTransactionMode() throws SQLException {
        this.conCtxt.setAutoCommit(false, this.diagnosticList);
        this.addWarnings();
    }

    protected void stopManualTransactionMode() throws SQLException {
        this.conCtxt.setAutoCommit(true, this.diagnosticList);
        this.addWarnings();
    }

    protected String getCatalog() throws SQLException {
        return this.conCtxt.getCatalog(this.diagnosticList);
    }

    protected void setCatalog(String string) throws SQLException {
        this.conCtxt.setCatalog(string, this.diagnosticList);
    }

    protected int getTransactionIsolation() throws SQLException {
        int n2 = this.conCtxt.getTransactionIsolation(this.diagnosticList);
        return Utils.NativeToJdbcTxnIsolation(n2);
    }

    protected void setTransactionIsolation(int n2) throws SQLException {
        int n3 = Utils.JdbcToNativeTxnIsolation(n2);
        int n4 = n2;
        if (n4 == 1 && !this.conCtxt.supportsTransactionIsolation(n3, this.diagnosticList)) {
            n4 = 2;
            n3 = Utils.JdbcToNativeTxnIsolation(2);
        }
        if (n4 == 2 && !this.conCtxt.supportsTransactionIsolation(n3, this.diagnosticList)) {
            n4 = 4;
            n3 = Utils.JdbcToNativeTxnIsolation(4);
        }
        if (n4 == 4 && !this.conCtxt.supportsTransactionIsolation(n3, this.diagnosticList)) {
            n4 = 8;
            n3 = Utils.JdbcToNativeTxnIsolation(8);
        }
        if (n4 == 8 && !this.conCtxt.supportsTransactionIsolation(n3, this.diagnosticList)) {
            throw Message.Gen.getSqlException(7391, "Connection.setTransactionIsolation(" + n2 + ")");
        }
        this.conCtxt.setTransactionIsolation(n3, this.diagnosticList);
    }

    SequeLinkImplDatabaseMetaData createImplDatabaseMetaData() throws SQLException {
        return new SequeLinkImplDatabaseMetaData(this);
    }

    PidList getPidList() {
        return this.conCtxt.getPidList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRowIdColumnName(DiagnosticList diagnosticList) {
        if (this._rowidRetrieved) {
            return this._rowidValue;
        }
        String string = null;
        try {
            string = this.getPidList().getPidString(11027, diagnosticList);
            if (string == null) {
                String string2 = null;
                return string2;
            }
            int n2 = string.length();
            if (n2 == 0) {
                String string3 = null;
                return string3;
            }
            char c2 = string.charAt(n2 - 1);
            while (c2 == '\u0000') {
                string = string.substring(0, n2 - 1);
                n2 = string.length();
                c2 = string.charAt(n2 - 1);
            }
            String string4 = string;
            return string4;
        }
        catch (SQLException sQLException) {
            String string5 = null;
            return string5;
        }
        finally {
            this._rowidRetrieved = true;
            this._rowidValue = string;
        }
    }

    protected String[] getAggregateFunctions() {
        if (!this.supportsRowId()) {
            return null;
        }
        if (this._aggregateFunctions != null) {
            return this._aggregateFunctions;
        }
        try {
            int n2 = this.getPidList().getPidInt(11251, this.diagnosticList);
            int n3 = 0;
            if ((n2 & 1) != 0) {
                ++n3;
            }
            if ((n2 & 2) != 0) {
                ++n3;
            }
            if ((n2 & 4) != 0) {
                ++n3;
            }
            if ((n2 & 8) != 0) {
                ++n3;
            }
            if ((n2 & 0x10) != 0) {
                ++n3;
            }
            if ((n2 & 0x20) != 0) {
                ++n3;
            }
            this._aggregateFunctions = new String[n3];
            n3 = 0;
            if ((n2 & 1) != 0) {
                this._aggregateFunctions[n3++] = "AVG";
            }
            if ((n2 & 2) != 0) {
                this._aggregateFunctions[n3++] = "COUNT";
            }
            if ((n2 & 4) != 0) {
                this._aggregateFunctions[n3++] = "MAX";
            }
            if ((n2 & 8) != 0) {
                this._aggregateFunctions[n3++] = "MIN";
            }
            if ((n2 & 0x10) != 0) {
                this._aggregateFunctions[n3++] = "SUM";
            }
            if ((n2 & 0x20) != 0) {
                this._aggregateFunctions[n3++] = "DISTINCT";
            }
            return this._aggregateFunctions;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public int getEmptyRowInsertSyntax() {
        try {
            return this.getPidList().getPidInt(11401, DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int[] executeBatch(UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws SQLException {
        return this.conCtxt.executeBatch(unSyncVector, diagnosticList);
    }

    public void getLobLength(SspLob sspLob) throws SQLException {
        this.conCtxt.getLobLength(sspLob, this.diagnosticList);
    }

    public int getLobData(SspLob sspLob, byte[] byArray, int n2, long l2, int n3) throws SQLException {
        return this.conCtxt.getLobData(sspLob, byArray, n2, l2, n3, this.diagnosticList);
    }

    public int setLobData(SspLob sspLob, byte[] byArray, int n2, long l2, int n3) throws SQLException {
        return this.conCtxt.setLobData(sspLob, byArray, n2, l2, n3, this.diagnosticList);
    }

    public long getLobPosition(SspLob sspLob, byte[] byArray, long l2) throws SQLException {
        return this.conCtxt.getLobPosition(sspLob, byArray, l2, this.diagnosticList);
    }

    public void lobTruncate(SspLob sspLob, long l2) throws SQLException {
        this.conCtxt.lobTruncate(sspLob, l2, this.diagnosticList);
    }

    public void xa_open() throws SQLException {
        this.conCtxt.xa_open(this.diagnosticList);
    }

    public void xa_close() throws SQLException {
        this.conCtxt.xa_close(this.diagnosticList);
    }

    public void xa_start(SlXid slXid, int n2) throws SlXaException {
        this.conCtxt.xa_start(slXid, n2);
    }

    public void xa_end(SlXid slXid, int n2) throws SlXaException {
        this.conCtxt.xa_end(slXid, n2);
    }

    public int xa_prepare(SlXid slXid) throws SlXaException {
        return this.conCtxt.xa_prepare(slXid);
    }

    public void xa_commit(SlXid slXid, boolean bl2) throws SlXaException {
        this.conCtxt.xa_commit(slXid, bl2);
    }

    public void xa_rollback(SlXid slXid) throws SlXaException {
        this.conCtxt.xa_rollback(slXid);
    }

    public SlXid[] xa_recover(int n2) throws SlXaException {
        return this.conCtxt.xa_recover(n2);
    }

    public void xa_forget(SlXid slXid) throws SlXaException {
        this.conCtxt.xa_forget(slXid);
    }

    public int getXaTransactionTimeout() throws SlXaException {
        return this.conCtxt.getXaTransactionTimeout(this.diagnosticList);
    }

    public boolean setXATransactionTimeout(int n2) throws SlXaException {
        return false;
    }

    public String getRmIdentification() throws SlXaException {
        return this.getAttributeValue("SERVERNAME") + "-" + this.getAttributeValue("PORTNUMBER") + "-" + this.getAttributeValue("DATABASENAME") + "-" + this.getAttributeValue("SERVERDATASOURCE");
    }

    private String getAttributeValue(String string) {
        String string2 = this.getConnectAttributes().getAttribute(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private ConnectAttributes getConnectAttributes() {
        return this.con.ca;
    }

    private DriverPropertyInfo[] getDpis() {
        return this.con.dpis;
    }

    public boolean supportsCancel() {
        return this.conCtxt.supportsCancel();
    }

    public boolean supportsQueryTimeout() {
        try {
            boolean bl2 = this.conCtxt.supportsQueryTimeout(DiagnosticList.GetADummyList());
            return bl2;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean supportsSelectStarCommaColumn() {
        try {
            int n2 = this.conCtxt.getRowIdOptions(DiagnosticList.GetADummyList());
            return (n2 & 1) == 0;
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    protected boolean shouldExposeGetSetUnicodeStream() {
        return true;
    }

    protected int getMaxLongDataFieldCacheSize() {
        return this.conCtxt.getSLKStaticCursorLongColBuffLen();
    }

    protected boolean exposeEmptyDBMDResultSetOnExecutionError() {
        return false;
    }

    protected boolean supportsRowId() {
        if (this._supportsRowId == null) {
            String string = this.getRowIdColumnName(DiagnosticList.GetADummyList());
            this._supportsRowId = string == null || string.length() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return this._supportsRowId;
    }

    public boolean supportsLobsNatively() {
        if (this._supportsLobsNatively == null) {
            try {
                int n2 = this.conCtxt.supportsLobs(DiagnosticList.GetADummyList());
                this._supportsLobsNatively = new Boolean(n2 != 0);
            }
            catch (SQLException sQLException) {
                this._supportsLobsNatively = new Boolean(false);
            }
        }
        return this._supportsLobsNatively;
    }

    public boolean supportsLobs() {
        return true;
    }

    protected boolean enableXlobOnLongVarX() {
        return !this.supportsLobsNatively();
    }

    protected void setSavepoint(String string) throws SQLException {
        this.conCtxt.setSavepoint(string, this.diagnosticList);
    }

    protected void releaseSavepoint(String string) throws SQLException {
        this.conCtxt.releaseSavepoint(string, this.diagnosticList);
    }

    protected void rollbackTransaction(String string) throws SQLException {
        this.conCtxt.rollbackToSavepoint(string, this.diagnosticList);
    }

    public void setOemId(String string) throws SQLException {
        this.conCtxt.setOemId(string, this.diagnosticList);
    }

    public void setApplicationId(String string) throws SQLException {
        this.conCtxt.setApplicationId(string, this.diagnosticList);
    }

    public boolean requiresUserId() {
        return false;
    }
}

