/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.LocaleData;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public final class VersionInfo
implements Comparable<VersionInfo> {
    public static final VersionInfo UNICODE_1_0;
    public static final VersionInfo UNICODE_1_0_1;
    public static final VersionInfo UNICODE_1_1_0;
    public static final VersionInfo UNICODE_1_1_5;
    public static final VersionInfo UNICODE_2_0;
    public static final VersionInfo UNICODE_2_1_2;
    public static final VersionInfo UNICODE_2_1_5;
    public static final VersionInfo UNICODE_2_1_8;
    public static final VersionInfo UNICODE_2_1_9;
    public static final VersionInfo UNICODE_3_0;
    public static final VersionInfo UNICODE_3_0_1;
    public static final VersionInfo UNICODE_3_1_0;
    public static final VersionInfo UNICODE_3_1_1;
    public static final VersionInfo UNICODE_3_2;
    public static final VersionInfo UNICODE_4_0;
    public static final VersionInfo UNICODE_4_0_1;
    public static final VersionInfo UNICODE_4_1;
    public static final VersionInfo UNICODE_5_0;
    public static final VersionInfo UNICODE_5_1;
    public static final VersionInfo UNICODE_5_2;
    public static final VersionInfo UNICODE_6_0;
    public static final VersionInfo UNICODE_6_1;
    public static final VersionInfo UNICODE_6_2;
    public static final VersionInfo UNICODE_6_3;
    public static final VersionInfo UNICODE_7_0;
    public static final VersionInfo UNICODE_8_0;
    public static final VersionInfo UNICODE_9_0;
    public static final VersionInfo UNICODE_10_0;
    public static final VersionInfo UNICODE_11_0;
    public static final VersionInfo UNICODE_12_0;
    public static final VersionInfo UNICODE_12_1;
    public static final VersionInfo UNICODE_13_0;
    public static final VersionInfo UNICODE_14_0;
    public static final VersionInfo UNICODE_15_0;
    public static final VersionInfo UNICODE_15_1;
    public static final VersionInfo ICU_VERSION;
    @Deprecated
    public static final String ICU_DATA_VERSION_PATH = "75b";
    @Deprecated
    public static final VersionInfo ICU_DATA_VERSION;
    public static final VersionInfo UCOL_RUNTIME_VERSION;
    public static final VersionInfo UCOL_BUILDER_VERSION;
    @Deprecated
    public static final VersionInfo UCOL_TAILORINGS_VERSION;
    private static final VersionInfo UNICODE_VERSION;
    private int m_version_;
    private static final ConcurrentHashMap<Integer, VersionInfo> MAP_;
    private static final int LAST_BYTE_MASK_ = 255;
    private static final String INVALID_VERSION_NUMBER_ = "Invalid version number: Version number may be negative or greater than 255";
    private static volatile String TZDATA_VERSION;

    public static VersionInfo getInstance(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        int[] nArray = new int[]{0, 0, 0, 0};
        int n5 = 0;
        for (n3 = 0; n5 < 4 && n3 < n4; ++n3) {
            n2 = string.charAt(n3);
            if (n2 == 46) {
                ++n5;
                continue;
            }
            if ((n2 = (char)(n2 - 48)) < 0 || n2 > 9) {
                throw new IllegalArgumentException(INVALID_VERSION_NUMBER_);
            }
            int n6 = n5;
            nArray[n6] = nArray[n6] * 10;
            int n7 = n5;
            nArray[n7] = nArray[n7] + n2;
        }
        if (n3 != n4) {
            throw new IllegalArgumentException("Invalid version number: String '" + string + "' exceeds version format");
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] <= 255) continue;
            throw new IllegalArgumentException(INVALID_VERSION_NUMBER_);
        }
        return VersionInfo.getInstance(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static VersionInfo getInstance(int n2, int n3, int n4, int n5) {
        VersionInfo versionInfo;
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255 || n5 < 0 || n5 > 255) {
            throw new IllegalArgumentException(INVALID_VERSION_NUMBER_);
        }
        int n6 = VersionInfo.getInt(n2, n3, n4, n5);
        Integer n7 = n6;
        VersionInfo versionInfo2 = MAP_.get(n7);
        if (versionInfo2 == null && (versionInfo = MAP_.putIfAbsent(n7, versionInfo2 = new VersionInfo(n6))) != null) {
            versionInfo2 = versionInfo;
        }
        return versionInfo2;
    }

    public static VersionInfo getInstance(int n2, int n3, int n4) {
        return VersionInfo.getInstance(n2, n3, n4, 0);
    }

    public static VersionInfo getInstance(int n2, int n3) {
        return VersionInfo.getInstance(n2, n3, 0, 0);
    }

    public static VersionInfo getInstance(int n2) {
        return VersionInfo.getInstance(n2, 0, 0, 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(7);
        stringBuilder.append(this.getMajor());
        stringBuilder.append('.');
        stringBuilder.append(this.getMinor());
        stringBuilder.append('.');
        stringBuilder.append(this.getMilli());
        stringBuilder.append('.');
        stringBuilder.append(this.getMicro());
        return stringBuilder.toString();
    }

    public int getMajor() {
        return this.m_version_ >> 24 & 0xFF;
    }

    public int getMinor() {
        return this.m_version_ >> 16 & 0xFF;
    }

    public int getMilli() {
        return this.m_version_ >> 8 & 0xFF;
    }

    public int getMicro() {
        return this.m_version_ & 0xFF;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return this.m_version_;
    }

    @Override
    public int compareTo(VersionInfo versionInfo) {
        int n2 = (this.m_version_ >>> 1) - (versionInfo.m_version_ >>> 1);
        if (n2 != 0) {
            return n2;
        }
        return (this.m_version_ & 1) - (versionInfo.m_version_ & 1);
    }

    private VersionInfo(int n2) {
        this.m_version_ = n2;
    }

    private static int getInt(int n2, int n3, int n4, int n5) {
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static void main(String[] stringArray) {
        String string;
        if (ICU_VERSION.getMajor() <= 4) {
            if (ICU_VERSION.getMinor() % 2 != 0) {
                int n2 = ICU_VERSION.getMajor();
                int n3 = ICU_VERSION.getMinor() + 1;
                if (n3 >= 10) {
                    n3 -= 10;
                    ++n2;
                }
                string = "" + n2 + "." + n3 + "M" + ICU_VERSION.getMilli();
            } else {
                string = ICU_VERSION.getVersionString(2, 2);
            }
        } else {
            string = ICU_VERSION.getMinor() == 0 ? "" + ICU_VERSION.getMajor() + "M" + ICU_VERSION.getMilli() : ICU_VERSION.getVersionString(2, 2);
        }
        System.out.println("International Components for Unicode for Java " + string);
        System.out.println("");
        System.out.println("Implementation Version: " + ICU_VERSION.getVersionString(2, 4));
        System.out.println("Unicode Data Version:   " + UNICODE_VERSION.getVersionString(2, 4));
        System.out.println("CLDR Data Version:      " + LocaleData.getCLDRVersion().getVersionString(2, 4));
        System.out.println("Time Zone Data Version: " + VersionInfo.getTZDataVersion());
    }

    @Deprecated
    public String getVersionString(int n2, int n3) {
        int n4;
        if (n2 < 1 || n3 < 1 || n2 > 4 || n3 > 4 || n2 > n3) {
            throw new IllegalArgumentException("Invalid min/maxDigits range");
        }
        int[] nArray = new int[]{this.getMajor(), this.getMinor(), this.getMilli(), this.getMicro()};
        for (n4 = n3; n4 > n2 && nArray[n4 - 1] == 0; --n4) {
        }
        StringBuilder stringBuilder = new StringBuilder(7);
        stringBuilder.append(nArray[0]);
        for (int i2 = 1; i2 < n4; ++i2) {
            stringBuilder.append(".");
            stringBuilder.append(nArray[i2]);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getTZDataVersion() {
        if (TZDATA_VERSION != null) return TZDATA_VERSION;
        Class<VersionInfo> clazz = VersionInfo.class;
        synchronized (VersionInfo.class) {
            if (TZDATA_VERSION != null) return TZDATA_VERSION;
            UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "zoneinfo64");
            TZDATA_VERSION = uResourceBundle.getString("TZVersion");
            // ** MonitorExit[var0] (shouldn't be in output)
            return TZDATA_VERSION;
        }
    }

    static {
        MAP_ = new ConcurrentHashMap();
        UNICODE_1_0 = VersionInfo.getInstance(1, 0, 0, 0);
        UNICODE_1_0_1 = VersionInfo.getInstance(1, 0, 1, 0);
        UNICODE_1_1_0 = VersionInfo.getInstance(1, 1, 0, 0);
        UNICODE_1_1_5 = VersionInfo.getInstance(1, 1, 5, 0);
        UNICODE_2_0 = VersionInfo.getInstance(2, 0, 0, 0);
        UNICODE_2_1_2 = VersionInfo.getInstance(2, 1, 2, 0);
        UNICODE_2_1_5 = VersionInfo.getInstance(2, 1, 5, 0);
        UNICODE_2_1_8 = VersionInfo.getInstance(2, 1, 8, 0);
        UNICODE_2_1_9 = VersionInfo.getInstance(2, 1, 9, 0);
        UNICODE_3_0 = VersionInfo.getInstance(3, 0, 0, 0);
        UNICODE_3_0_1 = VersionInfo.getInstance(3, 0, 1, 0);
        UNICODE_3_1_0 = VersionInfo.getInstance(3, 1, 0, 0);
        UNICODE_3_1_1 = VersionInfo.getInstance(3, 1, 1, 0);
        UNICODE_3_2 = VersionInfo.getInstance(3, 2, 0, 0);
        UNICODE_4_0 = VersionInfo.getInstance(4, 0, 0, 0);
        UNICODE_4_0_1 = VersionInfo.getInstance(4, 0, 1, 0);
        UNICODE_4_1 = VersionInfo.getInstance(4, 1, 0, 0);
        UNICODE_5_0 = VersionInfo.getInstance(5, 0, 0, 0);
        UNICODE_5_1 = VersionInfo.getInstance(5, 1, 0, 0);
        UNICODE_5_2 = VersionInfo.getInstance(5, 2, 0, 0);
        UNICODE_6_0 = VersionInfo.getInstance(6, 0, 0, 0);
        UNICODE_6_1 = VersionInfo.getInstance(6, 1, 0, 0);
        UNICODE_6_2 = VersionInfo.getInstance(6, 2, 0, 0);
        UNICODE_6_3 = VersionInfo.getInstance(6, 3, 0, 0);
        UNICODE_7_0 = VersionInfo.getInstance(7, 0, 0, 0);
        UNICODE_8_0 = VersionInfo.getInstance(8, 0, 0, 0);
        UNICODE_9_0 = VersionInfo.getInstance(9, 0, 0, 0);
        UNICODE_10_0 = VersionInfo.getInstance(10, 0, 0, 0);
        UNICODE_11_0 = VersionInfo.getInstance(11, 0, 0, 0);
        UNICODE_12_0 = VersionInfo.getInstance(12, 0, 0, 0);
        UNICODE_12_1 = VersionInfo.getInstance(12, 1, 0, 0);
        UNICODE_13_0 = VersionInfo.getInstance(13, 0, 0, 0);
        UNICODE_14_0 = VersionInfo.getInstance(14, 0, 0, 0);
        UNICODE_15_0 = VersionInfo.getInstance(15, 0, 0, 0);
        UNICODE_15_1 = VersionInfo.getInstance(15, 1, 0, 0);
        ICU_DATA_VERSION = ICU_VERSION = VersionInfo.getInstance(75, 1, 0, 0);
        UNICODE_VERSION = UNICODE_15_1;
        UCOL_RUNTIME_VERSION = VersionInfo.getInstance(9);
        UCOL_BUILDER_VERSION = VersionInfo.getInstance(9);
        UCOL_TAILORINGS_VERSION = VersionInfo.getInstance(1);
        TZDATA_VERSION = null;
    }
}

