/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CacheBase;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceTableAccess;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.LocaleIDParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.LocaleIDs;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.AsciiUtil;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.BaseLocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.Extension;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.InternalLocaleBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.KeyTypeData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LSR;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LanguageTag;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LikelySubtags;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LocaleExtensions;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LocaleSyntaxException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.ParseStatus;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.UnicodeLocaleExtension;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.LocaleDisplayNames;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.IllformedLocaleException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.LocaleMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.LocalePriorityList;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public final class ULocale
implements Serializable,
Comparable<ULocale> {
    private static final long serialVersionUID = 3715177670352309217L;
    private static CacheBase<String, String, Void> nameCache = new SoftCache<String, String, Void>(){

        @Override
        protected String createInstance(String string, Void void_) {
            return new LocaleIDParser(string).getName();
        }
    };
    public static final ULocale ENGLISH = new ULocale("en", Locale.ENGLISH);
    public static final ULocale FRENCH = new ULocale("fr", Locale.FRENCH);
    public static final ULocale GERMAN = new ULocale("de", Locale.GERMAN);
    public static final ULocale ITALIAN = new ULocale("it", Locale.ITALIAN);
    public static final ULocale JAPANESE = new ULocale("ja", Locale.JAPANESE);
    public static final ULocale KOREAN = new ULocale("ko", Locale.KOREAN);
    public static final ULocale CHINESE = new ULocale("zh", Locale.CHINESE);
    public static final ULocale SIMPLIFIED_CHINESE = new ULocale("zh_Hans");
    public static final ULocale TRADITIONAL_CHINESE = new ULocale("zh_Hant");
    public static final ULocale FRANCE = new ULocale("fr_FR", Locale.FRANCE);
    public static final ULocale GERMANY = new ULocale("de_DE", Locale.GERMANY);
    public static final ULocale ITALY = new ULocale("it_IT", Locale.ITALY);
    public static final ULocale JAPAN = new ULocale("ja_JP", Locale.JAPAN);
    public static final ULocale KOREA = new ULocale("ko_KR", Locale.KOREA);
    public static final ULocale CHINA;
    public static final ULocale PRC;
    public static final ULocale TAIWAN;
    public static final ULocale UK;
    public static final ULocale US;
    public static final ULocale CANADA;
    public static final ULocale CANADA_FRENCH;
    private static final String EMPTY_STRING = "";
    private static final char UNDERSCORE = '_';
    private static final Locale EMPTY_LOCALE;
    private static final String LOCALE_ATTRIBUTE_KEY = "attribute";
    public static final ULocale ROOT;
    private static final SoftCache<Locale, ULocale, Void> CACHE;
    private volatile transient Locale locale;
    private String localeID;
    private volatile transient BaseLocale baseLocale;
    private volatile transient LocaleExtensions extensions;
    private static String[][] CANONICALIZE_MAP;
    private static volatile ULocale defaultULocale;
    private static Locale[] defaultCategoryLocales;
    private static ULocale[] defaultCategoryULocales;
    private static Set<String> gKnownCanonicalizedCases;
    private static final String LANG_DIR_STRING = "root-en-es-pt-zh-ja-ko-de-fr-it-ar+he+fa+ru-nl-pl-th-tr-";
    public static Type ACTUAL_LOCALE;
    public static Type VALID_LOCALE;
    private static final String UNDEFINED_LANGUAGE = "und";
    private static final String UNDEFINED_SCRIPT = "Zzzz";
    private static final String UNDEFINED_REGION = "ZZ";
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';

    private ULocale(String string, Locale locale) {
        this.localeID = string;
        this.locale = locale;
    }

    public static ULocale forLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        return CACHE.getInstance(locale, null);
    }

    public ULocale(String string) {
        this.localeID = ULocale.getName(string);
    }

    public ULocale(String string, String string2) {
        this(string, string2, null);
    }

    public ULocale(String string, String string2, String string3) {
        this.localeID = ULocale.getName(ULocale.lscvToID(string, string2, string3, EMPTY_STRING));
    }

    public static ULocale createCanonical(String string) {
        return new ULocale(ULocale.canonicalize(string), (Locale)null);
    }

    public static ULocale createCanonical(ULocale uLocale) {
        return ULocale.createCanonical(uLocale.getName());
    }

    private static String lscvToID(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append('_');
            stringBuilder.append(string2);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append('_');
            stringBuilder.append(string3);
        }
        if (string4 != null && string4.length() > 0) {
            if (string3 == null || string3.length() == 0) {
                stringBuilder.append('_');
            }
            stringBuilder.append('_');
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    public Locale toLocale() {
        if (this.locale == null) {
            this.locale = JDKLocaleHelper.toLocale(this);
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ULocale getDefault() {
        ULocale uLocale = defaultULocale;
        if (uLocale == null) {
            return ROOT;
        }
        if (uLocale.locale.equals(Locale.getDefault())) {
            return uLocale;
        }
        Class<ULocale> clazz = ULocale.class;
        synchronized (ULocale.class) {
            Locale locale = Locale.getDefault();
            assert (locale != null);
            uLocale = defaultULocale;
            assert (uLocale != null);
            if (uLocale.locale.equals(locale)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return uLocale;
            }
            ULocale uLocale2 = ULocale.forLocale(locale);
            assert (uLocale2 != null);
            if (!JDKLocaleHelper.hasLocaleCategories()) {
                for (Category category : Category.values()) {
                    int n2 = category.ordinal();
                    ULocale.defaultCategoryLocales[n2] = locale;
                    ULocale.defaultCategoryULocales[n2] = uLocale2;
                }
            }
            defaultULocale = uLocale2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultULocale;
        }
    }

    public static synchronized void setDefault(ULocale uLocale) {
        Locale.setDefault(uLocale.toLocale());
        defaultULocale = uLocale;
        for (Category category : Category.values()) {
            ULocale.setDefault(category, uLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ULocale getDefault(Category category) {
        Class<ULocale> clazz = ULocale.class;
        synchronized (ULocale.class) {
            int n2 = category.ordinal();
            if (defaultCategoryULocales[n2] == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ROOT;
            }
            if (JDKLocaleHelper.hasLocaleCategories()) {
                Locale locale = JDKLocaleHelper.getDefault(category);
                if (!defaultCategoryLocales[n2].equals(locale)) {
                    ULocale.defaultCategoryLocales[n2] = locale;
                    ULocale.defaultCategoryULocales[n2] = ULocale.forLocale(locale);
                }
            } else {
                Locale locale = Locale.getDefault();
                if (!ULocale.defaultULocale.locale.equals(locale)) {
                    defaultULocale = ULocale.forLocale(locale);
                    for (Category category2 : Category.values()) {
                        int n3 = category2.ordinal();
                        ULocale.defaultCategoryLocales[n3] = locale;
                        ULocale.defaultCategoryULocales[n3] = ULocale.forLocale(locale);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultCategoryULocales[n2];
        }
    }

    public static synchronized void setDefault(Category category, ULocale uLocale) {
        Locale locale = uLocale.toLocale();
        int n2 = category.ordinal();
        ULocale.defaultCategoryULocales[n2] = uLocale;
        ULocale.defaultCategoryLocales[n2] = locale;
        JDKLocaleHelper.setDefault(category, locale);
    }

    public Object clone() {
        return this;
    }

    public int hashCode() {
        return this.localeID.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ULocale) {
            return this.localeID.equals(((ULocale)object).localeID);
        }
        return false;
    }

    @Override
    public int compareTo(ULocale uLocale) {
        if (this == uLocale) {
            return 0;
        }
        int n2 = 0;
        n2 = this.getLanguage().compareTo(uLocale.getLanguage());
        if (n2 == 0 && (n2 = this.getScript().compareTo(uLocale.getScript())) == 0 && (n2 = this.getCountry().compareTo(uLocale.getCountry())) == 0 && (n2 = this.getVariant().compareTo(uLocale.getVariant())) == 0) {
            Iterator<String> iterator = this.getKeywords();
            Iterator<String> iterator2 = uLocale.getKeywords();
            if (iterator == null) {
                n2 = iterator2 == null ? 0 : -1;
            } else if (iterator2 == null) {
                n2 = 1;
            } else {
                while (n2 == 0 && iterator.hasNext()) {
                    String string;
                    if (!iterator2.hasNext()) {
                        n2 = 1;
                        break;
                    }
                    String string2 = iterator.next();
                    n2 = string2.compareTo(string = iterator2.next());
                    if (n2 != 0) continue;
                    String string3 = this.getKeywordValue(string2);
                    String string4 = uLocale.getKeywordValue(string);
                    if (string3 == null) {
                        n2 = string4 == null ? 0 : -1;
                        continue;
                    }
                    if (string4 == null) {
                        n2 = 1;
                        continue;
                    }
                    n2 = string3.compareTo(string4);
                }
                if (n2 == 0 && iterator2.hasNext()) {
                    n2 = -1;
                }
            }
        }
        return n2 < 0 ? -1 : (n2 > 0 ? 1 : 0);
    }

    public static ULocale[] getAvailableLocales() {
        return (ULocale[])ICUResourceBundle.getAvailableULocales().clone();
    }

    public static Collection<ULocale> getAvailableLocalesByType(AvailableType availableType) {
        List<Object> list;
        if (availableType == null) {
            throw new IllegalArgumentException();
        }
        if (availableType == AvailableType.WITH_LEGACY_ALIASES) {
            list = new ArrayList();
            Collections.addAll(list, ICUResourceBundle.getAvailableULocales(AvailableType.DEFAULT));
            Collections.addAll(list, ICUResourceBundle.getAvailableULocales(AvailableType.ONLY_LEGACY_ALIASES));
        } else {
            list = Arrays.asList(ICUResourceBundle.getAvailableULocales(availableType));
        }
        return Collections.unmodifiableList(list);
    }

    public static String[] getISOCountries() {
        return LocaleIDs.getISOCountries();
    }

    public static String[] getISOLanguages() {
        return LocaleIDs.getISOLanguages();
    }

    public String getLanguage() {
        return this.base().getLanguage();
    }

    public static String getLanguage(String string) {
        return new LocaleIDParser(string).getLanguage();
    }

    public String getScript() {
        return this.base().getScript();
    }

    public static String getScript(String string) {
        return new LocaleIDParser(string).getScript();
    }

    public String getCountry() {
        return this.base().getRegion();
    }

    public static String getCountry(String string) {
        return new LocaleIDParser(string).getCountry();
    }

    private static String getRegionFromKey(ULocale uLocale, String string) {
        String string2 = uLocale.getKeywordValue(string);
        if (string2 != null && string2.length() >= 3 && string2.length() <= 7) {
            if (Character.isLetter(string2.charAt(0))) {
                return AsciiUtil.toUpperString(string2.substring(0, 2));
            }
            return string2.substring(0, 3);
        }
        return null;
    }

    @Deprecated
    public static String getRegionForSupplementalData(ULocale uLocale, boolean bl2) {
        String string = ULocale.getRegionFromKey(uLocale, "rg");
        if (string != null) {
            return string;
        }
        string = uLocale.getCountry();
        if (string.length() == 0 && bl2) {
            string = ULocale.getRegionFromKey(uLocale, "sd");
            if (string != null) {
                return string;
            }
            ULocale uLocale2 = ULocale.addLikelySubtags(uLocale);
            string = uLocale2.getCountry();
        }
        return string;
    }

    public String getVariant() {
        return this.base().getVariant();
    }

    public static String getVariant(String string) {
        return new LocaleIDParser(string).getVariant();
    }

    public static String getFallback(String string) {
        return ULocale.getFallbackString(ULocale.getName(string));
    }

    public ULocale getFallback() {
        if (this.localeID.length() == 0 || this.localeID.charAt(0) == '@') {
            return null;
        }
        return new ULocale(ULocale.getFallbackString(this.localeID), (Locale)null);
    }

    private static String getFallbackString(String string) {
        int n2;
        int n3 = string.indexOf(64);
        if (n3 == -1) {
            n3 = string.length();
        }
        if ((n2 = string.lastIndexOf(95, n3)) == -1) {
            n2 = 0;
        } else {
            while (n2 > 0 && string.charAt(n2 - 1) == '_') {
                --n2;
            }
        }
        return string.substring(0, n2) + string.substring(n3);
    }

    public String getBaseName() {
        return ULocale.getBaseName(this.localeID);
    }

    public static String getBaseName(String string) {
        if (string.indexOf(64) == -1) {
            return string;
        }
        return new LocaleIDParser(string).getBaseName();
    }

    public String getName() {
        return this.localeID;
    }

    private static int getShortestSubtagLength(String string) {
        int n2;
        int n3 = n2 = string.length();
        boolean bl2 = true;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) != '_' && string.charAt(i2) != '-') {
                if (bl2) {
                    bl2 = false;
                    n4 = 0;
                }
                ++n4;
                continue;
            }
            if (n4 != 0 && n4 < n3) {
                n3 = n4;
            }
            bl2 = true;
        }
        return n3;
    }

    public static String getName(String string) {
        String string2 = string;
        if (string != null && !string.contains("@") && ULocale.getShortestSubtagLength(string) == 1) {
            if (string.indexOf(95) >= 0 && string.charAt(1) != '_' && string.charAt(1) != '-') {
                string2 = string.replace('_', '-');
            }
            if ((string2 = ULocale.forLanguageTag(string2).getName()).length() == 0) {
                string2 = string;
            }
        } else {
            string2 = "root".equalsIgnoreCase(string) ? EMPTY_STRING : ULocale.stripLeadingUnd(string);
        }
        return nameCache.getInstance(string2, null);
    }

    private static String stripLeadingUnd(String string) {
        int n2 = string.length();
        if (n2 < 3) {
            return string;
        }
        if (!string.regionMatches(true, 0, UNDEFINED_LANGUAGE, 0, 3)) {
            return string;
        }
        if (n2 == 3) {
            return EMPTY_STRING;
        }
        char c2 = string.charAt(3);
        if (c2 == '-' || c2 == '_') {
            return string.substring(3);
        }
        return string;
    }

    public String toString() {
        return this.localeID;
    }

    public Iterator<String> getKeywords() {
        return ULocale.getKeywords(this.localeID);
    }

    public static Iterator<String> getKeywords(String string) {
        return new LocaleIDParser(string).getKeywords();
    }

    public String getKeywordValue(String string) {
        return ULocale.getKeywordValue(this.localeID, string);
    }

    public static String getKeywordValue(String string, String string2) {
        return new LocaleIDParser(string).getKeywordValue(string2);
    }

    public static String canonicalize(String string) {
        String string2;
        String string3;
        Object object;
        LocaleIDParser localeIDParser = new LocaleIDParser(string, true);
        String string4 = localeIDParser.getBaseName();
        boolean bl2 = false;
        if (string.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        for (int i2 = 0; i2 < CANONICALIZE_MAP.length; ++i2) {
            object = CANONICALIZE_MAP[i2];
            if (!object[0].equals(string4)) continue;
            bl2 = true;
            localeIDParser.setBaseName(object[1]);
            break;
        }
        if (!bl2 && localeIDParser.getLanguage().equals("nb") && localeIDParser.getVariant().equals("NY")) {
            localeIDParser.setBaseName(ULocale.lscvToID("nn", localeIDParser.getScript(), localeIDParser.getCountry(), null));
        }
        if (!ULocale.isKnownCanonicalizedLocale(string3 = localeIDParser.getName()) && (string2 = ((AliasReplacer)(object = new AliasReplacer(localeIDParser.getLanguage(), localeIDParser.getScript(), localeIDParser.getCountry(), AsciiUtil.toLowerString(localeIDParser.getVariant()), localeIDParser.getName().substring(localeIDParser.getBaseName().length())))).replace()) != null) {
            localeIDParser = new LocaleIDParser(string2);
        }
        return localeIDParser.getName();
    }

    private static synchronized boolean isKnownCanonicalizedLocale(String string) {
        if (string.equals("c") || string.equals("en") || string.equals("en_US")) {
            return true;
        }
        if (gKnownCanonicalizedCases == null) {
            List<String> list = Arrays.asList("af", "af_ZA", "am", "am_ET", "ar", "ar_001", "as", "as_IN", "az", "az_AZ", "be", "be_BY", "bg", "bg_BG", "bn", "bn_IN", "bs", "bs_BA", "ca", "ca_ES", "cs", "cs_CZ", "cy", "cy_GB", "da", "da_DK", "de", "de_DE", "el", "el_GR", "en", "en_GB", "en_US", "es", "es_419", "es_ES", "et", "et_EE", "eu", "eu_ES", "fa", "fa_IR", "fi", "fi_FI", "fil", "fil_PH", "fr", "fr_FR", "ga", "ga_IE", "gl", "gl_ES", "gu", "gu_IN", "he", "he_IL", "hi", "hi_IN", "hr", "hr_HR", "hu", "hu_HU", "hy", "hy_AM", "id", "id_ID", "is", "is_IS", "it", "it_IT", "ja", "ja_JP", "jv", "jv_ID", "ka", "ka_GE", "kk", "kk_KZ", "km", "km_KH", "kn", "kn_IN", "ko", "ko_KR", "ky", "ky_KG", "lo", "lo_LA", "lt", "lt_LT", "lv", "lv_LV", "mk", "mk_MK", "ml", "ml_IN", "mn", "mn_MN", "mr", "mr_IN", "ms", "ms_MY", "my", "my_MM", "nb", "nb_NO", "ne", "ne_NP", "nl", "nl_NL", "no", "or", "or_IN", "pa", "pa_IN", "pl", "pl_PL", "ps", "ps_AF", "pt", "pt_BR", "pt_PT", "ro", "ro_RO", "ru", "ru_RU", "sd", "sd_IN", "si", "si_LK", "sk", "sk_SK", "sl", "sl_SI", "so", "so_SO", "sq", "sq_AL", "sr", "sr_Cyrl_RS", "sr_Latn", "sr_RS", "sv", "sv_SE", "sw", "sw_TZ", "ta", "ta_IN", "te", "te_IN", "th", "th_TH", "tk", "tk_TM", "tr", "tr_TR", "uk", "uk_UA", "ur", "ur_PK", "uz", "uz_UZ", "vi", "vi_VN", "yue", "yue_Hant", "yue_Hant_HK", "yue_HK", "zh", "zh_CN", "zh_Hans", "zh_Hans_CN", "zh_Hant", "zh_Hant_TW", "zh_TW", "zu", "zu_ZA");
            gKnownCanonicalizedCases = new HashSet<String>(list);
        }
        return gKnownCanonicalizedCases.contains(string);
    }

    public ULocale setKeywordValue(String string, String string2) {
        return new ULocale(ULocale.setKeywordValue(this.localeID, string, string2), (Locale)null);
    }

    public static String setKeywordValue(String string, String string2, String string3) {
        LocaleIDParser localeIDParser = new LocaleIDParser(string);
        localeIDParser.setKeywordValue(string2, string3);
        return localeIDParser.getName();
    }

    public String getISO3Language() {
        return ULocale.getISO3Language(this.localeID);
    }

    public static String getISO3Language(String string) {
        return LocaleIDs.getISO3Language(ULocale.getLanguage(string));
    }

    public String getISO3Country() {
        return ULocale.getISO3Country(this.localeID);
    }

    public static String getISO3Country(String string) {
        return LocaleIDs.getISO3Country(ULocale.getCountry(string));
    }

    public boolean isRightToLeft() {
        String string = this.getScript();
        if (string.length() == 0) {
            ULocale uLocale;
            int n2;
            String string2 = this.getLanguage();
            if (!string2.isEmpty() && (n2 = LANG_DIR_STRING.indexOf(string2)) >= 0) {
                switch (LANG_DIR_STRING.charAt(n2 + string2.length())) {
                    case '-': {
                        return false;
                    }
                    case '+': {
                        return true;
                    }
                }
            }
            if ((string = (uLocale = ULocale.addLikelySubtags(this)).getScript()).length() == 0) {
                return false;
            }
        }
        int n3 = UScript.getCodeFromName(string);
        return UScript.isRightToLeft(n3);
    }

    public String getDisplayLanguage() {
        return ULocale.getDisplayLanguageInternal(this, ULocale.getDefault(Category.DISPLAY), false);
    }

    public String getDisplayLanguage(ULocale uLocale) {
        return ULocale.getDisplayLanguageInternal(this, uLocale, false);
    }

    public static String getDisplayLanguage(String string, String string2) {
        return ULocale.getDisplayLanguageInternal(new ULocale(string), new ULocale(string2), false);
    }

    public static String getDisplayLanguage(String string, ULocale uLocale) {
        return ULocale.getDisplayLanguageInternal(new ULocale(string), uLocale, false);
    }

    public String getDisplayLanguageWithDialect() {
        return ULocale.getDisplayLanguageInternal(this, ULocale.getDefault(Category.DISPLAY), true);
    }

    public String getDisplayLanguageWithDialect(ULocale uLocale) {
        return ULocale.getDisplayLanguageInternal(this, uLocale, true);
    }

    public static String getDisplayLanguageWithDialect(String string, String string2) {
        return ULocale.getDisplayLanguageInternal(new ULocale(string), new ULocale(string2), true);
    }

    public static String getDisplayLanguageWithDialect(String string, ULocale uLocale) {
        return ULocale.getDisplayLanguageInternal(new ULocale(string), uLocale, true);
    }

    private static String getDisplayLanguageInternal(ULocale uLocale, ULocale uLocale2, boolean bl2) {
        String string = bl2 ? uLocale.getBaseName() : uLocale.getLanguage();
        return LocaleDisplayNames.getInstance(uLocale2).languageDisplayName(string);
    }

    public String getDisplayScript() {
        return ULocale.getDisplayScriptInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    @Deprecated
    public String getDisplayScriptInContext() {
        return ULocale.getDisplayScriptInContextInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    public String getDisplayScript(ULocale uLocale) {
        return ULocale.getDisplayScriptInternal(this, uLocale);
    }

    @Deprecated
    public String getDisplayScriptInContext(ULocale uLocale) {
        return ULocale.getDisplayScriptInContextInternal(this, uLocale);
    }

    public static String getDisplayScript(String string, String string2) {
        return ULocale.getDisplayScriptInternal(new ULocale(string), new ULocale(string2));
    }

    @Deprecated
    public static String getDisplayScriptInContext(String string, String string2) {
        return ULocale.getDisplayScriptInContextInternal(new ULocale(string), new ULocale(string2));
    }

    public static String getDisplayScript(String string, ULocale uLocale) {
        return ULocale.getDisplayScriptInternal(new ULocale(string), uLocale);
    }

    @Deprecated
    public static String getDisplayScriptInContext(String string, ULocale uLocale) {
        return ULocale.getDisplayScriptInContextInternal(new ULocale(string), uLocale);
    }

    private static String getDisplayScriptInternal(ULocale uLocale, ULocale uLocale2) {
        return LocaleDisplayNames.getInstance(uLocale2).scriptDisplayName(uLocale.getScript());
    }

    private static String getDisplayScriptInContextInternal(ULocale uLocale, ULocale uLocale2) {
        return LocaleDisplayNames.getInstance(uLocale2).scriptDisplayNameInContext(uLocale.getScript());
    }

    public String getDisplayCountry() {
        return ULocale.getDisplayCountryInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    public String getDisplayCountry(ULocale uLocale) {
        return ULocale.getDisplayCountryInternal(this, uLocale);
    }

    public static String getDisplayCountry(String string, String string2) {
        return ULocale.getDisplayCountryInternal(new ULocale(string), new ULocale(string2));
    }

    public static String getDisplayCountry(String string, ULocale uLocale) {
        return ULocale.getDisplayCountryInternal(new ULocale(string), uLocale);
    }

    private static String getDisplayCountryInternal(ULocale uLocale, ULocale uLocale2) {
        return LocaleDisplayNames.getInstance(uLocale2).regionDisplayName(uLocale.getCountry());
    }

    public String getDisplayVariant() {
        return ULocale.getDisplayVariantInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    public String getDisplayVariant(ULocale uLocale) {
        return ULocale.getDisplayVariantInternal(this, uLocale);
    }

    public static String getDisplayVariant(String string, String string2) {
        return ULocale.getDisplayVariantInternal(new ULocale(string), new ULocale(string2));
    }

    public static String getDisplayVariant(String string, ULocale uLocale) {
        return ULocale.getDisplayVariantInternal(new ULocale(string), uLocale);
    }

    private static String getDisplayVariantInternal(ULocale uLocale, ULocale uLocale2) {
        return LocaleDisplayNames.getInstance(uLocale2).variantDisplayName(uLocale.getVariant());
    }

    public static String getDisplayKeyword(String string) {
        return ULocale.getDisplayKeywordInternal(string, ULocale.getDefault(Category.DISPLAY));
    }

    public static String getDisplayKeyword(String string, String string2) {
        return ULocale.getDisplayKeywordInternal(string, new ULocale(string2));
    }

    public static String getDisplayKeyword(String string, ULocale uLocale) {
        return ULocale.getDisplayKeywordInternal(string, uLocale);
    }

    private static String getDisplayKeywordInternal(String string, ULocale uLocale) {
        return LocaleDisplayNames.getInstance(uLocale).keyDisplayName(string);
    }

    public String getDisplayKeywordValue(String string) {
        return ULocale.getDisplayKeywordValueInternal(this, string, ULocale.getDefault(Category.DISPLAY));
    }

    public String getDisplayKeywordValue(String string, ULocale uLocale) {
        return ULocale.getDisplayKeywordValueInternal(this, string, uLocale);
    }

    public static String getDisplayKeywordValue(String string, String string2, String string3) {
        return ULocale.getDisplayKeywordValueInternal(new ULocale(string), string2, new ULocale(string3));
    }

    public static String getDisplayKeywordValue(String string, String string2, ULocale uLocale) {
        return ULocale.getDisplayKeywordValueInternal(new ULocale(string), string2, uLocale);
    }

    private static String getDisplayKeywordValueInternal(ULocale uLocale, String string, ULocale uLocale2) {
        string = AsciiUtil.toLowerString(string.trim());
        String string2 = uLocale.getKeywordValue(string);
        return LocaleDisplayNames.getInstance(uLocale2).keyValueDisplayName(string, string2);
    }

    public String getDisplayName() {
        return ULocale.getDisplayNameInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    public String getDisplayName(ULocale uLocale) {
        return ULocale.getDisplayNameInternal(this, uLocale);
    }

    public static String getDisplayName(String string, String string2) {
        return ULocale.getDisplayNameInternal(new ULocale(string), new ULocale(string2));
    }

    public static String getDisplayName(String string, ULocale uLocale) {
        return ULocale.getDisplayNameInternal(new ULocale(string), uLocale);
    }

    private static String getDisplayNameInternal(ULocale uLocale, ULocale uLocale2) {
        return LocaleDisplayNames.getInstance(uLocale2).localeDisplayName(uLocale);
    }

    public String getDisplayNameWithDialect() {
        return ULocale.getDisplayNameWithDialectInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    public String getDisplayNameWithDialect(ULocale uLocale) {
        return ULocale.getDisplayNameWithDialectInternal(this, uLocale);
    }

    public static String getDisplayNameWithDialect(String string, String string2) {
        return ULocale.getDisplayNameWithDialectInternal(new ULocale(string), new ULocale(string2));
    }

    public static String getDisplayNameWithDialect(String string, ULocale uLocale) {
        return ULocale.getDisplayNameWithDialectInternal(new ULocale(string), uLocale);
    }

    private static String getDisplayNameWithDialectInternal(ULocale uLocale, ULocale uLocale2) {
        return LocaleDisplayNames.getInstance(uLocale2, LocaleDisplayNames.DialectHandling.DIALECT_NAMES).localeDisplayName(uLocale);
    }

    public String getCharacterOrientation() {
        return ICUResourceTableAccess.getTableString("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", this, "layout", "characters", "characters");
    }

    public String getLineOrientation() {
        return ICUResourceTableAccess.getTableString("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", this, "layout", "lines", "lines");
    }

    public static ULocale acceptLanguage(String string, ULocale[] uLocaleArray, boolean[] blArray) {
        LocalePriorityList localePriorityList;
        if (blArray != null) {
            blArray[0] = true;
        }
        try {
            localePriorityList = LocalePriorityList.add(string).build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        LocaleMatcher.Builder builder = LocaleMatcher.builder();
        for (ULocale uLocale : uLocaleArray) {
            builder.addSupportedULocale(uLocale);
        }
        LocaleMatcher localeMatcher = builder.build();
        LocaleMatcher.Result result = localeMatcher.getBestMatchResult(localePriorityList);
        if (result.getDesiredIndex() >= 0) {
            if (blArray != null && result.getDesiredULocale().equals(result.getSupportedULocale())) {
                blArray[0] = false;
            }
            return result.getSupportedULocale();
        }
        return null;
    }

    public static ULocale acceptLanguage(ULocale[] uLocaleArray, ULocale[] uLocaleArray2, boolean[] blArray) {
        if (blArray != null) {
            blArray[0] = true;
        }
        LocaleMatcher.Builder builder = LocaleMatcher.builder();
        for (ULocale uLocale : uLocaleArray2) {
            builder.addSupportedULocale(uLocale);
        }
        LocaleMatcher localeMatcher = builder.build();
        LocaleMatcher.Result result = uLocaleArray.length == 1 ? localeMatcher.getBestMatchResult(uLocaleArray[0]) : localeMatcher.getBestMatchResult(Arrays.asList(uLocaleArray));
        if (result.getDesiredIndex() >= 0) {
            if (blArray != null && result.getDesiredULocale().equals(result.getSupportedULocale())) {
                blArray[0] = false;
            }
            return result.getSupportedULocale();
        }
        return null;
    }

    public static ULocale acceptLanguage(String string, boolean[] blArray) {
        return ULocale.acceptLanguage(string, ULocale.getAvailableLocales(), blArray);
    }

    public static ULocale acceptLanguage(ULocale[] uLocaleArray, boolean[] blArray) {
        return ULocale.acceptLanguage(uLocaleArray, ULocale.getAvailableLocales(), blArray);
    }

    public static ULocale addLikelySubtags(ULocale uLocale) {
        String[] stringArray = new String[3];
        String string = null;
        int n2 = ULocale.parseTagString(uLocale.localeID, stringArray);
        if (n2 < uLocale.localeID.length()) {
            string = uLocale.localeID.substring(n2);
        }
        LSR lSR = LikelySubtags.INSTANCE.makeMaximizedLsrFrom(new ULocale(uLocale.getLanguage(), uLocale.getScript(), uLocale.getCountry()), true);
        String string2 = ULocale.createTagString(lSR.language, lSR.script, lSR.region, string);
        return string2 == null ? uLocale : new ULocale(string2);
    }

    public static ULocale minimizeSubtags(ULocale uLocale) {
        return ULocale.minimizeSubtags(uLocale, Minimize.FAVOR_REGION);
    }

    @Deprecated
    public static ULocale minimizeSubtags(ULocale uLocale, Minimize minimize) {
        String[] stringArray = new String[3];
        String string = null;
        int n2 = ULocale.parseTagString(uLocale.localeID, stringArray);
        if (n2 < uLocale.localeID.length()) {
            string = uLocale.localeID.substring(n2);
        }
        LSR lSR = LikelySubtags.INSTANCE.minimizeSubtags(uLocale.getLanguage(), uLocale.getScript(), uLocale.getCountry(), minimize);
        String string2 = ULocale.createTagString(lSR.language, lSR.script, lSR.region, string);
        return string2 == null ? uLocale : new ULocale(string2);
    }

    private static boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    private static void appendTag(String string, StringBuilder stringBuilder) {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('_');
        }
        stringBuilder.append(string);
    }

    private static String createTagString(String string, String string2, String string3, String string4) {
        Object var4_4 = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (!ULocale.isEmptyString(string)) {
            ULocale.appendTag(string, stringBuilder);
        } else {
            ULocale.appendTag(UNDEFINED_LANGUAGE, stringBuilder);
        }
        if (!ULocale.isEmptyString(string2)) {
            ULocale.appendTag(string2, stringBuilder);
        }
        if (!ULocale.isEmptyString(string3)) {
            ULocale.appendTag(string3, stringBuilder);
        }
        if (string4 != null && string4.length() > 1) {
            int n2 = 0;
            if (string4.charAt(0) == '_') {
                if (string4.charAt(1) == '_') {
                    n2 = 2;
                }
            } else {
                n2 = 1;
            }
            if (!ULocale.isEmptyString(string3)) {
                if (n2 == 2) {
                    stringBuilder.append(string4.substring(1));
                } else {
                    stringBuilder.append(string4);
                }
            } else {
                if (n2 == 1) {
                    stringBuilder.append('_');
                }
                stringBuilder.append(string4);
            }
        }
        return stringBuilder.toString();
    }

    private static int parseTagString(String string, String[] stringArray) {
        LocaleIDParser localeIDParser = new LocaleIDParser(string);
        String string2 = localeIDParser.getLanguage();
        String string3 = localeIDParser.getScript();
        String string4 = localeIDParser.getCountry();
        stringArray[0] = ULocale.isEmptyString(string2) ? UNDEFINED_LANGUAGE : string2;
        stringArray[1] = string3.equals(UNDEFINED_SCRIPT) ? EMPTY_STRING : string3;
        stringArray[2] = string4.equals(UNDEFINED_REGION) ? EMPTY_STRING : string4;
        String string5 = localeIDParser.getVariant();
        if (!ULocale.isEmptyString(string5)) {
            int n2 = string.indexOf(string5);
            return n2 > 0 ? n2 - 1 : n2;
        }
        int n3 = string.indexOf(64);
        return n3 == -1 ? string.length() : n3;
    }

    public String getExtension(char c2) {
        if (!LocaleExtensions.isValidKey(c2)) {
            throw new IllegalArgumentException("Invalid extension key: " + c2);
        }
        return this.extensions().getExtensionValue(Character.valueOf(c2));
    }

    public Set<Character> getExtensionKeys() {
        return this.extensions().getKeys();
    }

    public Set<String> getUnicodeLocaleAttributes() {
        return this.extensions().getUnicodeLocaleAttributes();
    }

    public String getUnicodeLocaleType(String string) {
        if (!LocaleExtensions.isValidUnicodeLocaleKey(string)) {
            throw new IllegalArgumentException("Invalid Unicode locale key: " + string);
        }
        return this.extensions().getUnicodeLocaleType(string);
    }

    public Set<String> getUnicodeLocaleKeys() {
        return this.extensions().getUnicodeLocaleKeys();
    }

    public String toLanguageTag() {
        Object object;
        BaseLocale baseLocale = this.base();
        LocaleExtensions localeExtensions = this.extensions();
        if (baseLocale.getVariant().equalsIgnoreCase("POSIX")) {
            baseLocale = BaseLocale.getInstance(baseLocale.getLanguage(), baseLocale.getScript(), baseLocale.getRegion(), EMPTY_STRING);
            if (localeExtensions.getUnicodeLocaleType("va") == null) {
                object = new InternalLocaleBuilder();
                try {
                    ((InternalLocaleBuilder)object).setLocale(BaseLocale.ROOT, localeExtensions);
                    ((InternalLocaleBuilder)object).setUnicodeLocaleKeyword("va", "posix");
                    localeExtensions = ((InternalLocaleBuilder)object).getLocaleExtensions();
                }
                catch (LocaleSyntaxException localeSyntaxException) {
                    throw new RuntimeException(localeSyntaxException);
                }
            }
        }
        object = LanguageTag.parseLocale(baseLocale, localeExtensions);
        StringBuilder stringBuilder = new StringBuilder();
        String string = ((LanguageTag)object).getLanguage();
        if (string.length() > 0) {
            stringBuilder.append(LanguageTag.canonicalizeLanguage(string));
        }
        if ((string = ((LanguageTag)object).getScript()).length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeScript(string));
        }
        if ((string = ((LanguageTag)object).getRegion()).length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeRegion(string));
        }
        List<String> list = ((LanguageTag)object).getVariants();
        ArrayList<String> arrayList = new ArrayList<String>(list);
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeVariant(string2));
        }
        list = ((LanguageTag)object).getExtensions();
        for (String string2 : list) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeExtension(string2));
        }
        string = ((LanguageTag)object).getPrivateuse();
        if (string.length() > 0) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(UNDEFINED_LANGUAGE);
            }
            stringBuilder.append("-");
            stringBuilder.append("x").append("-");
            stringBuilder.append(LanguageTag.canonicalizePrivateuse(string));
        }
        return stringBuilder.toString();
    }

    public static ULocale forLanguageTag(String string) {
        LanguageTag languageTag = LanguageTag.parse(string, null);
        InternalLocaleBuilder internalLocaleBuilder = new InternalLocaleBuilder();
        internalLocaleBuilder.setLanguageTag(languageTag);
        return ULocale.getInstance(internalLocaleBuilder.getBaseLocale(), internalLocaleBuilder.getLocaleExtensions());
    }

    public static String toUnicodeLocaleKey(String string) {
        String string2 = KeyTypeData.toBcpKey(string);
        if (string2 == null && UnicodeLocaleExtension.isKey(string)) {
            string2 = AsciiUtil.toLowerString(string);
        }
        return string2;
    }

    public static String toUnicodeLocaleType(String string, String string2) {
        String string3 = KeyTypeData.toBcpType(string, string2, null, null);
        if (string3 == null && UnicodeLocaleExtension.isType(string2)) {
            string3 = AsciiUtil.toLowerString(string2);
        }
        return string3;
    }

    public static String toLegacyKey(String string) {
        String string2 = KeyTypeData.toLegacyKey(string);
        if (string2 == null && string.matches("[0-9a-zA-Z]+")) {
            string2 = AsciiUtil.toLowerString(string);
        }
        return string2;
    }

    public static String toLegacyType(String string, String string2) {
        String string3 = KeyTypeData.toLegacyType(string, string2, null, null);
        if (string3 == null && string2.matches("[0-9a-zA-Z]+([_/\\-][0-9a-zA-Z]+)*")) {
            string3 = AsciiUtil.toLowerString(string2);
        }
        return string3;
    }

    private static ULocale getInstance(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        String string = ULocale.lscvToID(baseLocale.getLanguage(), baseLocale.getScript(), baseLocale.getRegion(), baseLocale.getVariant());
        Set<Character> set = localeExtensions.getKeys();
        if (!set.isEmpty()) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (Character object3 : set) {
                Extension bl2 = localeExtensions.getExtension(object3);
                if (bl2 instanceof UnicodeLocaleExtension) {
                    CharSequence charSequence;
                    UnicodeLocaleExtension unicodeLocaleExtension = (UnicodeLocaleExtension)bl2;
                    Object object = unicodeLocaleExtension.getUnicodeLocaleKeys();
                    Set<String> set2 = object.iterator();
                    while (set2.hasNext()) {
                        charSequence = set2.next();
                        String string2 = unicodeLocaleExtension.getUnicodeLocaleType((String)charSequence);
                        String string3 = ULocale.toLegacyKey((String)charSequence);
                        String string4 = ULocale.toLegacyType((String)charSequence, (String)(string2.length() == 0 ? "yes" : string2));
                        if (string3.equals("va") && string4.equals("posix") && baseLocale.getVariant().length() == 0) {
                            string = string + "_POSIX";
                            continue;
                        }
                        treeMap.put(string3, string4);
                    }
                    set2 = unicodeLocaleExtension.getUnicodeLocaleAttributes();
                    if (set2.size() <= 0) continue;
                    charSequence = new StringBuilder();
                    for (String string3 : set2) {
                        if (((StringBuilder)charSequence).length() > 0) {
                            ((StringBuilder)charSequence).append('-');
                        }
                        ((StringBuilder)charSequence).append(string3);
                    }
                    treeMap.put(LOCALE_ATTRIBUTE_KEY, ((StringBuilder)charSequence).toString());
                    continue;
                }
                treeMap.put(String.valueOf(object3), bl2.getValue());
            }
            if (!treeMap.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.append("@");
                Set set3 = treeMap.entrySet();
                boolean bl2 = false;
                for (Object object : set3) {
                    if (bl2) {
                        stringBuilder.append(";");
                    } else {
                        bl2 = true;
                    }
                    stringBuilder.append((String)object.getKey());
                    stringBuilder.append("=");
                    stringBuilder.append((String)object.getValue());
                }
                string = stringBuilder.toString();
            }
        }
        return new ULocale(string);
    }

    private BaseLocale base() {
        if (this.baseLocale == null) {
            String string = EMPTY_STRING;
            String string2 = EMPTY_STRING;
            String string3 = EMPTY_STRING;
            String string4 = EMPTY_STRING;
            if (!this.equals(ROOT)) {
                LocaleIDParser localeIDParser = new LocaleIDParser(this.localeID);
                string4 = localeIDParser.getLanguage();
                string3 = localeIDParser.getScript();
                string2 = localeIDParser.getCountry();
                string = localeIDParser.getVariant();
            }
            this.baseLocale = BaseLocale.getInstance(string4, string3, string2, string);
        }
        return this.baseLocale;
    }

    private LocaleExtensions extensions() {
        if (this.extensions == null) {
            Iterator<String> iterator = this.getKeywords();
            if (iterator == null) {
                this.extensions = LocaleExtensions.EMPTY_EXTENSIONS;
            } else {
                InternalLocaleBuilder internalLocaleBuilder = new InternalLocaleBuilder();
                while (iterator.hasNext()) {
                    Object object;
                    String string = iterator.next();
                    if (string.equals(LOCALE_ATTRIBUTE_KEY)) {
                        for (String string2 : object = this.getKeywordValue(string).split("[-_]")) {
                            try {
                                internalLocaleBuilder.addUnicodeLocaleAttribute(string2);
                            }
                            catch (LocaleSyntaxException localeSyntaxException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (string.length() >= 2) {
                        object = ULocale.toUnicodeLocaleKey(string);
                        String string3 = ULocale.toUnicodeLocaleType(string, this.getKeywordValue(string));
                        if (object == null || string3 == null) continue;
                        try {
                            internalLocaleBuilder.setUnicodeLocaleKeyword((String)object, string3);
                        }
                        catch (LocaleSyntaxException localeSyntaxException) {}
                        continue;
                    }
                    if (string.length() != 1 || string.charAt(0) == 'u') continue;
                    try {
                        internalLocaleBuilder.setExtension(string.charAt(0), this.getKeywordValue(string).replace("_", "-"));
                    }
                    catch (LocaleSyntaxException localeSyntaxException) {
                    }
                }
                this.extensions = internalLocaleBuilder.getLocaleExtensions();
            }
        }
        return this.extensions;
    }

    static {
        PRC = CHINA = new ULocale("zh_Hans_CN");
        TAIWAN = new ULocale("zh_Hant_TW");
        UK = new ULocale("en_GB", Locale.UK);
        US = new ULocale("en_US", Locale.US);
        CANADA = new ULocale("en_CA", Locale.CANADA);
        CANADA_FRENCH = new ULocale("fr_CA", Locale.CANADA_FRENCH);
        EMPTY_LOCALE = new Locale(EMPTY_STRING, EMPTY_STRING);
        ROOT = new ULocale(EMPTY_STRING, EMPTY_LOCALE);
        CACHE = new SoftCache<Locale, ULocale, Void>(){

            @Override
            protected ULocale createInstance(Locale locale, Void void_) {
                return JDKLocaleHelper.toULocale(locale);
            }
        };
        CANONICALIZE_MAP = new String[][]{{"art__LOJBAN", "jbo"}, {"cel__GAULISH", "cel__GAULISH"}, {"de__1901", "de__1901"}, {"de__1906", "de__1906"}, {"en__BOONT", "en__BOONT"}, {"en__SCOUSE", "en__SCOUSE"}, {"hy__AREVELA", "hy", null, null}, {"hy__AREVMDA", "hyw", null, null}, {"sl__ROZAJ", "sl__ROZAJ"}, {"zh__GUOYU", "zh"}, {"zh__HAKKA", "hak"}, {"zh__XIANG", "hsn"}, {"zh_GAN", "gan"}, {"zh_MIN", "zh__MIN"}, {"zh_MIN_NAN", "nan"}, {"zh_WUU", "wuu"}, {"zh_YUE", "yue"}};
        defaultCategoryLocales = new Locale[Category.values().length];
        defaultCategoryULocales = new ULocale[Category.values().length];
        Locale locale = Locale.getDefault();
        defaultULocale = ULocale.forLocale(locale);
        if (JDKLocaleHelper.hasLocaleCategories()) {
            for (Category category : Category.values()) {
                int n2 = category.ordinal();
                ULocale.defaultCategoryLocales[n2] = JDKLocaleHelper.getDefault(category);
                ULocale.defaultCategoryULocales[n2] = ULocale.forLocale(defaultCategoryLocales[n2]);
            }
        } else {
            for (Category category : Category.values()) {
                int n3 = category.ordinal();
                ULocale.defaultCategoryLocales[n3] = locale;
                ULocale.defaultCategoryULocales[n3] = defaultULocale;
            }
        }
        gKnownCanonicalizedCases = null;
        ACTUAL_LOCALE = new Type();
        VALID_LOCALE = new Type();
    }

    private static final class JDKLocaleHelper {
        private static boolean hasLocaleCategories = false;
        private static Method mGetDefault;
        private static Method mSetDefault;
        private static Object eDISPLAY;
        private static Object eFORMAT;

        private JDKLocaleHelper() {
        }

        public static boolean hasLocaleCategories() {
            return hasLocaleCategories;
        }

        public static ULocale toULocale(Locale locale) {
            Object object;
            String string2 = locale.getLanguage();
            String string3 = ULocale.EMPTY_STRING;
            String string4 = locale.getCountry();
            String string5 = locale.getVariant();
            TreeSet<Object> treeSet = null;
            TreeMap treeMap = null;
            string3 = locale.getScript();
            Set<Character> set = locale.getExtensionKeys();
            if (!set.isEmpty()) {
                for (Character comparable : set) {
                    Object object2;
                    if (comparable.charValue() == 'u') {
                        object2 = locale.getUnicodeLocaleAttributes();
                        if (!object2.isEmpty()) {
                            treeSet = new TreeSet<Object>();
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                object = (String)iterator.next();
                                treeSet.add(object);
                            }
                        }
                        Set<String> set2 = locale.getUnicodeLocaleKeys();
                        for (String string : set2) {
                            String string6 = locale.getUnicodeLocaleType(string);
                            if (string6 == null) continue;
                            if (string.equals("va")) {
                                string5 = string5.length() == 0 ? string6 : string6 + "_" + string5;
                                continue;
                            }
                            if (treeMap == null) {
                                treeMap = new TreeMap();
                            }
                            treeMap.put(string, string6);
                        }
                        continue;
                    }
                    object2 = locale.getExtension(comparable.charValue());
                    if (object2 == null) continue;
                    if (treeMap == null) {
                        treeMap = new TreeMap();
                    }
                    treeMap.put(String.valueOf(comparable), object2);
                }
            }
            if (string2.equals("no") && string4.equals("NO") && string5.equals("NY")) {
                string2 = "nn";
                string5 = ULocale.EMPTY_STRING;
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (string3.length() > 0) {
                stringBuilder.append('_');
                stringBuilder.append(string3);
            }
            if (string4.length() > 0) {
                stringBuilder.append('_');
                stringBuilder.append(string4);
            }
            if (string5.length() > 0) {
                if (string4.length() == 0) {
                    stringBuilder.append('_');
                }
                stringBuilder.append('_');
                stringBuilder.append(string5);
            }
            if (treeSet != null) {
                StringBuilder bl2 = new StringBuilder();
                for (String string : treeSet) {
                    if (bl2.length() != 0) {
                        bl2.append('-');
                    }
                    bl2.append(string);
                }
                if (treeMap == null) {
                    treeMap = new TreeMap();
                }
                treeMap.put(ULocale.LOCALE_ATTRIBUTE_KEY, bl2.toString());
            }
            if (treeMap != null) {
                stringBuilder.append('@');
                boolean bl2 = false;
                for (Map.Entry entry : treeMap.entrySet()) {
                    boolean bl3;
                    String string;
                    object = (String)entry.getKey();
                    string = (String)entry.getValue();
                    if (((String)object).length() != 1) {
                        object = ULocale.toLegacyKey((String)object);
                        string = ULocale.toLegacyType((String)object, string.length() == 0 ? "yes" : string);
                    }
                    if (bl3) {
                        stringBuilder.append(';');
                    } else {
                        bl3 = true;
                    }
                    stringBuilder.append((String)object);
                    stringBuilder.append('=');
                    stringBuilder.append(string);
                }
            }
            return new ULocale(ULocale.getName(stringBuilder.toString()), locale);
        }

        public static Locale toLocale(ULocale uLocale) {
            Locale locale = null;
            String string = uLocale.getName();
            if (uLocale.getScript().length() > 0 || string.contains("@")) {
                String string2 = uLocale.toLanguageTag();
                string2 = AsciiUtil.toUpperString(string2);
                locale = Locale.forLanguageTag(string2);
            }
            if (locale == null) {
                locale = new Locale(uLocale.getLanguage(), uLocale.getCountry(), uLocale.getVariant());
            }
            return locale;
        }

        public static Locale getDefault(Category category) {
            if (hasLocaleCategories) {
                Object object = null;
                switch (category) {
                    case DISPLAY: {
                        object = eDISPLAY;
                        break;
                    }
                    case FORMAT: {
                        object = eFORMAT;
                    }
                }
                if (object != null) {
                    try {
                        return (Locale)mGetDefault.invoke(null, object);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
            return Locale.getDefault();
        }

        public static void setDefault(Category category, Locale locale) {
            if (hasLocaleCategories) {
                Object object = null;
                switch (category) {
                    case DISPLAY: {
                        object = eDISPLAY;
                        break;
                    }
                    case FORMAT: {
                        object = eFORMAT;
                    }
                }
                if (object != null) {
                    try {
                        mSetDefault.invoke(null, object, locale);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }

        static {
            try {
                Class<?> clazz = null;
                Class<?>[] classArray = Locale.class.getDeclaredClasses();
                for (Class<?> clazz2 : classArray) {
                    if (!clazz2.getName().equals("java.util.Locale$Category")) continue;
                    clazz = clazz2;
                    break;
                }
                if (clazz != null) {
                    ?[] objArray;
                    mGetDefault = Locale.class.getDeclaredMethod("getDefault", clazz);
                    mSetDefault = Locale.class.getDeclaredMethod("setDefault", clazz, Locale.class);
                    Method method = clazz.getMethod("name", null);
                    for (Object obj : objArray = clazz.getEnumConstants()) {
                        String string = (String)method.invoke(obj, (Object[])null);
                        if (string.equals("DISPLAY")) {
                            eDISPLAY = obj;
                            continue;
                        }
                        if (!string.equals("FORMAT")) continue;
                        eFORMAT = obj;
                    }
                    if (eDISPLAY != null && eFORMAT != null) {
                        hasLocaleCategories = true;
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static final class Builder {
        private final InternalLocaleBuilder _locbld = new InternalLocaleBuilder();

        public Builder setLocale(ULocale uLocale) {
            try {
                this._locbld.setLocale(uLocale.base(), uLocale.extensions());
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setLanguageTag(String string) {
            ParseStatus parseStatus = new ParseStatus();
            LanguageTag languageTag = LanguageTag.parse(string, parseStatus);
            if (parseStatus.isError()) {
                throw new IllformedLocaleException(parseStatus.getErrorMessage(), parseStatus.getErrorIndex());
            }
            this._locbld.setLanguageTag(languageTag);
            return this;
        }

        public Builder setLanguage(String string) {
            try {
                this._locbld.setLanguage(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setScript(String string) {
            try {
                this._locbld.setScript(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setRegion(String string) {
            try {
                this._locbld.setRegion(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setVariant(String string) {
            try {
                this._locbld.setVariant(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setExtension(char c2, String string) {
            try {
                this._locbld.setExtension(c2, string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setUnicodeLocaleKeyword(String string, String string2) {
            try {
                this._locbld.setUnicodeLocaleKeyword(string, string2);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder addUnicodeLocaleAttribute(String string) {
            try {
                this._locbld.addUnicodeLocaleAttribute(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder removeUnicodeLocaleAttribute(String string) {
            try {
                this._locbld.removeUnicodeLocaleAttribute(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder clear() {
            this._locbld.clear();
            return this;
        }

        public Builder clearExtensions() {
            this._locbld.clearExtensions();
            return this;
        }

        public ULocale build() {
            return ULocale.getInstance(this._locbld.getBaseLocale(), this._locbld.getLocaleExtensions());
        }
    }

    @Deprecated
    public static enum Minimize {
        FAVOR_SCRIPT,
        FAVOR_REGION;

    }

    public static final class Type {
        private Type() {
        }
    }

    private static class AliasReplacer {
        private String language;
        private String script;
        private String region;
        private List<String> variants;
        private String extensions;
        private static boolean aliasDataIsLoaded = false;
        private static Map<String, String> languageAliasMap = null;
        private static Map<String, String> scriptAliasMap = null;
        private static Map<String, List<String>> territoryAliasMap = null;
        private static Map<String, String> variantAliasMap = null;
        private static Map<String, String> subdivisionAliasMap = null;

        public AliasReplacer(String string, String string2, String string3, String string4, String string5) {
            assert (string != null);
            assert (string2 != null);
            assert (string3 != null);
            assert (string4 != null);
            assert (string5 != null);
            this.language = string;
            this.script = string2;
            this.region = string3;
            if (!string4.isEmpty()) {
                this.variants = new ArrayList<String>(Arrays.asList(string4.split("_")));
            }
            this.extensions = string5;
        }

        public String replace() {
            boolean bl2 = false;
            AliasReplacer.loadAliasData();
            int n2 = 0;
            while (true) {
                if (n2++ > 10) {
                    throw new IllegalArgumentException("Have problem to resolve locale alias of " + ULocale.lscvToID(this.language, this.script, this.region, this.variants == null ? ULocale.EMPTY_STRING : Utility.joinStrings("_", this.variants)) + this.extensions);
                }
                if (!this.replaceLanguage(true, true, true) && !this.replaceLanguage(true, true, false) && !this.replaceLanguage(true, false, true) && !this.replaceLanguage(true, false, false) && !this.replaceLanguage(false, false, true) && !this.replaceRegion() && !this.replaceScript() && !this.replaceVariant()) break;
                bl2 = true;
            }
            if (this.extensions == null && !bl2) {
                return null;
            }
            String string = ULocale.lscvToID(this.language, this.script, this.region, this.variants == null ? ULocale.EMPTY_STRING : Utility.joinStrings("_", this.variants));
            if (this.extensions != null) {
                boolean bl3 = false;
                ULocale uLocale = new ULocale(string + this.extensions);
                Iterator<String> iterator = uLocale.getKeywords();
                while (iterator != null && iterator.hasNext()) {
                    String string2 = iterator.next();
                    if (!string2.equals("rg") && !string2.equals("sd") && !string2.equals("t")) continue;
                    String string3 = uLocale.getKeywordValue(string2);
                    String string4 = string2.equals("t") ? this.replaceTransformedExtensions(string3) : this.replaceSubdivision(string3);
                    if (string4 == null) continue;
                    uLocale = uLocale.setKeywordValue(string2, string4);
                    bl3 = true;
                }
                if (bl3) {
                    this.extensions = uLocale.getName().substring(uLocale.getBaseName().length());
                    bl2 = true;
                }
                string = string + this.extensions;
            }
            if (bl2) {
                return string;
            }
            return null;
        }

        private static synchronized void loadAliasData() {
            String string;
            String string2;
            UResourceBundle uResourceBundle;
            int n2;
            if (aliasDataIsLoaded) {
                return;
            }
            languageAliasMap = new HashMap<String, String>();
            scriptAliasMap = new HashMap<String, String>();
            territoryAliasMap = new HashMap<String, List<String>>();
            variantAliasMap = new HashMap<String, String>();
            subdivisionAliasMap = new HashMap<String, String>();
            UResourceBundle uResourceBundle2 = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "metadata", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle uResourceBundle3 = uResourceBundle2.get("alias");
            UResourceBundle uResourceBundle4 = uResourceBundle3.get("language");
            UResourceBundle uResourceBundle5 = uResourceBundle3.get("script");
            UResourceBundle uResourceBundle6 = uResourceBundle3.get("territory");
            UResourceBundle uResourceBundle7 = uResourceBundle3.get("variant");
            UResourceBundle uResourceBundle8 = uResourceBundle3.get("subdivision");
            for (n2 = 0; n2 < uResourceBundle4.getSize(); ++n2) {
                uResourceBundle = uResourceBundle4.get(n2);
                string2 = uResourceBundle.getKey();
                string = uResourceBundle.get("replacement").getString();
                Locale locale = new Locale(string2);
                if (!locale.getScript().isEmpty() || string2.startsWith(ULocale.UNDEFINED_LANGUAGE) && !locale.getCountry().isEmpty()) {
                    throw new IllegalArgumentException("key [" + string2 + "] in alias:language contains unsupported fields combination.");
                }
                languageAliasMap.put(string2, string);
            }
            for (n2 = 0; n2 < uResourceBundle5.getSize(); ++n2) {
                uResourceBundle = uResourceBundle5.get(n2);
                string2 = uResourceBundle.getKey();
                string = uResourceBundle.get("replacement").getString();
                if (string2.length() != 4) {
                    throw new IllegalArgumentException("Incorrect key [" + string2 + "] in alias:script.");
                }
                scriptAliasMap.put(string2, string);
            }
            for (n2 = 0; n2 < uResourceBundle6.getSize(); ++n2) {
                uResourceBundle = uResourceBundle6.get(n2);
                string2 = uResourceBundle.getKey();
                string = uResourceBundle.get("replacement").getString();
                if (string2.length() < 2 || string2.length() > 3) {
                    throw new IllegalArgumentException("Incorrect key [" + string2 + "] in alias:territory.");
                }
                territoryAliasMap.put(string2, new ArrayList<String>(Arrays.asList(string.split(" "))));
            }
            for (n2 = 0; n2 < uResourceBundle7.getSize(); ++n2) {
                uResourceBundle = uResourceBundle7.get(n2);
                string2 = uResourceBundle.getKey();
                string = uResourceBundle.get("replacement").getString();
                if (string2.length() < 4 || string2.length() > 8 || string2.length() == 4 && (string2.charAt(0) < '0' || string2.charAt(0) > '9')) {
                    throw new IllegalArgumentException("Incorrect key [" + string2 + "] in alias:variant.");
                }
                if (string.length() < 4 || string.length() > 8 || string.length() == 4 && (string.charAt(0) < '0' || string.charAt(0) > '9')) {
                    throw new IllegalArgumentException("Incorrect variant [" + string + "] for the key [" + string2 + "] in alias:variant.");
                }
                variantAliasMap.put(string2, string);
            }
            for (n2 = 0; n2 < uResourceBundle8.getSize(); ++n2) {
                uResourceBundle = uResourceBundle8.get(n2);
                string2 = uResourceBundle.getKey();
                string = uResourceBundle.get("replacement").getString().split(" ")[0];
                if (string2.length() < 3 || string2.length() > 8) {
                    throw new IllegalArgumentException("Incorrect key [" + string2 + "] in alias:territory.");
                }
                if (string.length() == 2) {
                    string = string + "zzzz";
                } else if (string.length() < 2 || string.length() > 8) {
                    throw new IllegalArgumentException("Incorrect value [" + string + "] in alias:territory.");
                }
                subdivisionAliasMap.put(string2, string);
            }
            aliasDataIsLoaded = true;
        }

        private static String generateKey(String string, String string2, String string3) {
            assert (string3 == null || string3.length() >= 4);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append('_');
                stringBuilder.append(string2);
            }
            if (string3 != null && !string3.isEmpty()) {
                stringBuilder.append('_');
                stringBuilder.append(string3);
            }
            return stringBuilder.toString();
        }

        private static String deleteOrReplace(String string, String string2, String string3) {
            return string3 != null && !string3.isEmpty() ? (string == null || string.isEmpty() ? string3 : string) : (string2 == null || string2.isEmpty() ? string : null);
        }

        private boolean replaceLanguage(boolean bl2, boolean bl3, boolean bl4) {
            if (bl3 && (this.region == null || this.region.isEmpty()) || bl4 && this.variants == null) {
                return false;
            }
            int n2 = bl4 ? this.variants.size() : 1;
            String string = bl2 ? this.language : ULocale.UNDEFINED_LANGUAGE;
            String string2 = bl3 ? this.region : null;
            String string3 = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4;
                String string5;
                if (bl4) {
                    string3 = this.variants.get(i2);
                }
                if (string3 != null && string3.length() < 4) {
                    string3 = null;
                }
                if ((string5 = languageAliasMap.get(string4 = AliasReplacer.generateKey(string, string2, string3))) == null) continue;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                if (string5.indexOf(95) < 0) {
                    string10 = string5.equals(ULocale.UNDEFINED_LANGUAGE) ? this.language : string5;
                } else {
                    String[] stringArray = string5.split("_");
                    string10 = stringArray[0];
                    int n3 = 1;
                    if (string10.equals(ULocale.UNDEFINED_LANGUAGE)) {
                        string10 = this.language;
                    }
                    int n4 = stringArray[0].length() + 1;
                    while (stringArray.length > n3) {
                        String string11 = stringArray[n3];
                        int n5 = string11.length();
                        if (1 == n5) {
                            string9 = string5.substring(n4);
                            break;
                        }
                        if (n5 >= 2 && n5 <= 3) {
                            assert (string7 == null);
                            string7 = string11;
                        } else if (n5 >= 5 && n5 <= 8) {
                            assert (string8 == null);
                            string8 = string11;
                        } else if (n5 == 4) {
                            if (string11.charAt(0) >= '0' && string11.charAt(0) <= '9') {
                                assert (string8 == null);
                                string8 = string11;
                            } else {
                                assert (string6 == null);
                                string6 = string11;
                            }
                        }
                        ++n3;
                        n4 += n5 + 1;
                    }
                }
                string6 = AliasReplacer.deleteOrReplace(this.script, null, string6);
                string7 = AliasReplacer.deleteOrReplace(this.region, string2, string7);
                string8 = AliasReplacer.deleteOrReplace(string3, string3, string8);
                if (this.language.equals(string10) && this.script.equals(string6) && this.region.equals(string7) && Objects.equals(string3, string8) && string9 == null) continue;
                this.language = string10;
                this.script = string6;
                this.region = string7;
                if (string3 != null && !string3.isEmpty()) {
                    if (string8 != null && !string8.isEmpty()) {
                        this.variants.set(i2, string8);
                    } else {
                        this.variants.remove(i2);
                        if (this.variants.isEmpty()) {
                            this.variants = null;
                        }
                    }
                }
                if (string9 == null || !string9.isEmpty()) {
                    // empty if block
                }
                return true;
            }
            return false;
        }

        private boolean replaceRegion() {
            String string;
            if (this.region == null || this.region.isEmpty()) {
                return false;
            }
            List<String> list = territoryAliasMap.get(this.region);
            if (list == null) {
                return false;
            }
            String string2 = list.size() > 1 ? (list.contains(string = ULocale.addLikelySubtags(new ULocale(this.language, this.script, null)).getCountry()) ? string : list.get(0)) : list.get(0);
            assert (!this.region.equals(string2));
            this.region = string2;
            return true;
        }

        private boolean replaceScript() {
            if (this.script == null || this.script.isEmpty()) {
                return false;
            }
            String string = scriptAliasMap.get(this.script);
            if (string == null) {
                return false;
            }
            assert (!this.script.equals(string));
            this.script = string;
            return true;
        }

        private boolean replaceVariant() {
            if (this.variants == null) {
                return false;
            }
            for (int i2 = 0; i2 < this.variants.size(); ++i2) {
                String string = this.variants.get(i2);
                String string2 = variantAliasMap.get(string);
                if (string2 == null) continue;
                assert (string2.length() >= 4);
                assert (string2.length() <= 8);
                assert (string2.length() != 4 || string2.charAt(0) >= '0' && string2.charAt(0) <= '9');
                if (string.equals(string2)) continue;
                this.variants.set(i2, string2);
                if (string.equals("heploc")) {
                    this.variants.remove("hepburn");
                    if (this.variants.isEmpty()) {
                        this.variants = null;
                    }
                }
                return true;
            }
            return false;
        }

        private String replaceSubdivision(String string) {
            return subdivisionAliasMap.get(string);
        }

        private String replaceTransformedExtensions(String string) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split("-")));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n2 = 0;
            int n3 = 0;
            String string3 = ULocale.EMPTY_STRING;
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                if (LanguageTag.isTKey(string2)) {
                    if (n3 == 0) {
                        n3 = n2 - 1;
                    }
                    if (stringBuilder.length() > 0) {
                        arrayList2.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    string3 = string2;
                    stringBuilder.append(string2);
                } else if (n3 != 0) {
                    stringBuilder.append("-").append(ULocale.toUnicodeLocaleType(string3, string2));
                }
                n2 += string2.length() + 1;
            }
            if (stringBuilder.length() > 0) {
                arrayList2.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            Object object2 = n3 > 0 ? string.substring(0, n3) : (object = arrayList2.size() == 0 ? string : ULocale.EMPTY_STRING);
            if (((String)object).length() > 0) {
                string2 = ULocale.createCanonical(ULocale.forLanguageTag(string)).toLanguageTag();
                stringBuilder.append(AsciiUtil.toLowerString(string2));
            }
            if (arrayList2.size() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("-");
                }
                Collections.sort(arrayList2);
                stringBuilder.append(Utility.joinStrings("-", arrayList2));
            }
            return stringBuilder.toString();
        }
    }

    public static enum Category {
        DISPLAY,
        FORMAT;

    }

    public static enum AvailableType {
        DEFAULT,
        ONLY_LEGACY_ALIASES,
        WITH_LEGACY_ALIASES;

    }
}

