/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Logger;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Grego;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUConfig;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.JavaTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.OlsonTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TimeZoneAdapter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ZoneMeta;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeZoneFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeZoneNames;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BasicTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Output;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundleIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public abstract class TimeZone
implements Freezable<TimeZone>,
Serializable,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone");
    private static final long serialVersionUID = -744942128318337471L;
    public static final int TIMEZONE_ICU = 0;
    public static final int TIMEZONE_JDK = 1;
    public static final int SHORT = 0;
    public static final int LONG = 1;
    public static final int SHORT_GENERIC = 2;
    public static final int LONG_GENERIC = 3;
    public static final int SHORT_GMT = 4;
    public static final int LONG_GMT = 5;
    public static final int SHORT_COMMONLY_USED = 6;
    public static final int GENERIC_LOCATION = 7;
    public static final String UNKNOWN_ZONE_ID = "Etc/Unknown";
    static final String GMT_ZONE_ID = "Etc/GMT";
    public static final TimeZone UNKNOWN_ZONE = new ConstantZone(0, "Etc/Unknown").freeze();
    public static final TimeZone GMT_ZONE = new ConstantZone(0, "Etc/GMT").freeze();
    private String ID;
    private static volatile TimeZone defaultZone = null;
    private static int TZ_IMPL = 0;
    private static final String TZIMPL_CONFIG_KEY = "macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone.DefaultTimeZoneType";
    private static final String TZIMPL_CONFIG_ICU = "ICU";
    private static final String TZIMPL_CONFIG_JDK = "JDK";

    public TimeZone() {
    }

    @Deprecated
    protected TimeZone(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ID = string;
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long l2) {
        int[] nArray = new int[2];
        this.getOffset(l2, false, nArray);
        return nArray[0] + nArray[1];
    }

    public void getOffset(long l2, boolean bl2, int[] nArray) {
        nArray[0] = this.getRawOffset();
        if (!bl2) {
            l2 += (long)nArray[0];
        }
        int[] nArray2 = new int[6];
        int n2 = 0;
        while (true) {
            Grego.timeToFields(l2, nArray2);
            nArray[1] = this.getOffset(1, nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray2[5]) - nArray[0];
            if (n2 != 0 || !bl2 || nArray[1] == 0) break;
            l2 -= (long)nArray[1];
            ++n2;
        }
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen TimeZone instance.");
        }
        this.ID = string;
    }

    public final String getDisplayName() {
        return this._getDisplayName(3, false, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public final String getDisplayName(Locale locale) {
        return this._getDisplayName(3, false, ULocale.forLocale(locale));
    }

    public final String getDisplayName(ULocale uLocale) {
        return this._getDisplayName(3, false, uLocale);
    }

    public final String getDisplayName(boolean bl2, int n2) {
        return this.getDisplayName(bl2, n2, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public String getDisplayName(boolean bl2, int n2, Locale locale) {
        return this.getDisplayName(bl2, n2, ULocale.forLocale(locale));
    }

    public String getDisplayName(boolean bl2, int n2, ULocale uLocale) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Illegal style: " + n2);
        }
        return this._getDisplayName(n2, bl2, uLocale);
    }

    private String _getDisplayName(int n2, boolean bl2, ULocale uLocale) {
        if (uLocale == null) {
            throw new NullPointerException("locale is null");
        }
        String string = null;
        if (n2 == 7 || n2 == 3 || n2 == 2) {
            TimeZoneFormat timeZoneFormat = TimeZoneFormat.getInstance(uLocale);
            long l2 = System.currentTimeMillis();
            Output<TimeZoneFormat.TimeType> output = new Output<TimeZoneFormat.TimeType>(TimeZoneFormat.TimeType.UNKNOWN);
            switch (n2) {
                case 7: {
                    string = timeZoneFormat.format(TimeZoneFormat.Style.GENERIC_LOCATION, this, l2, output);
                    break;
                }
                case 3: {
                    string = timeZoneFormat.format(TimeZoneFormat.Style.GENERIC_LONG, this, l2, output);
                    break;
                }
                case 2: {
                    string = timeZoneFormat.format(TimeZoneFormat.Style.GENERIC_SHORT, this, l2, output);
                }
            }
            if (bl2 && output.value == TimeZoneFormat.TimeType.STANDARD || !bl2 && output.value == TimeZoneFormat.TimeType.DAYLIGHT) {
                int n3 = bl2 ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
                string = n2 == 2 ? timeZoneFormat.formatOffsetShortLocalizedGMT(n3) : timeZoneFormat.formatOffsetLocalizedGMT(n3);
            }
        } else if (n2 == 5 || n2 == 4) {
            TimeZoneFormat timeZoneFormat = TimeZoneFormat.getInstance(uLocale);
            int n4 = bl2 && this.useDaylightTime() ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
            switch (n2) {
                case 5: {
                    string = timeZoneFormat.formatOffsetLocalizedGMT(n4);
                    break;
                }
                case 4: {
                    string = timeZoneFormat.formatOffsetISO8601Basic(n4, false, false, false);
                }
            }
        } else {
            assert (n2 == 1 || n2 == 0 || n2 == 6);
            long l3 = System.currentTimeMillis();
            TimeZoneNames timeZoneNames = TimeZoneNames.getInstance(uLocale);
            TimeZoneNames.NameType nameType = null;
            switch (n2) {
                case 1: {
                    nameType = bl2 ? TimeZoneNames.NameType.LONG_DAYLIGHT : TimeZoneNames.NameType.LONG_STANDARD;
                    break;
                }
                case 0: 
                case 6: {
                    nameType = bl2 ? TimeZoneNames.NameType.SHORT_DAYLIGHT : TimeZoneNames.NameType.SHORT_STANDARD;
                }
            }
            string = timeZoneNames.getDisplayName(ZoneMeta.getCanonicalCLDRID(this), nameType, l3);
            if (string == null) {
                TimeZoneFormat timeZoneFormat = TimeZoneFormat.getInstance(uLocale);
                int n5 = bl2 && this.useDaylightTime() ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
                String string2 = string = n2 == 1 ? timeZoneFormat.formatOffsetLocalizedGMT(n5) : timeZoneFormat.formatOffsetShortLocalizedGMT(n5);
            }
        }
        assert (string != null);
        return string;
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public boolean observesDaylightTime() {
        return this.useDaylightTime() || this.inDaylightTime(new Date());
    }

    public abstract boolean inDaylightTime(Date var1);

    public static TimeZone getTimeZone(String string) {
        return TimeZone.getTimeZone(string, TZ_IMPL, false);
    }

    public static TimeZone getFrozenTimeZone(String string) {
        return TimeZone.getTimeZone(string, TZ_IMPL, true);
    }

    public static TimeZone getTimeZone(String string, int n2) {
        return TimeZone.getTimeZone(string, n2, false);
    }

    private static TimeZone getTimeZone(String string, int n2, boolean bl2) {
        TimeZone timeZone;
        if (n2 == 1) {
            timeZone = JavaTimeZone.createTimeZone(string);
            if (timeZone != null) {
                return bl2 ? timeZone.freeze() : timeZone;
            }
            timeZone = TimeZone.getFrozenICUTimeZone(string, false);
        } else {
            timeZone = TimeZone.getFrozenICUTimeZone(string, true);
        }
        if (timeZone == null) {
            LOGGER.fine("\"" + string + "\" is a bogus id so timezone is falling back to Etc/Unknown(GMT).");
            timeZone = UNKNOWN_ZONE;
        }
        return bl2 ? timeZone : timeZone.cloneAsThawed();
    }

    static BasicTimeZone getFrozenICUTimeZone(String string, boolean bl2) {
        BasicTimeZone basicTimeZone = null;
        if (bl2) {
            basicTimeZone = ZoneMeta.getSystemTimeZone(string);
        }
        if (basicTimeZone == null) {
            basicTimeZone = ZoneMeta.getCustomTimeZone(string);
        }
        return basicTimeZone;
    }

    public static synchronized void setDefaultTimeZoneType(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Invalid timezone type");
        }
        TZ_IMPL = n2;
    }

    public static int getDefaultTimeZoneType() {
        return TZ_IMPL;
    }

    public static Set<String> getAvailableIDs(SystemTimeZoneType systemTimeZoneType, String string, Integer n2) {
        return ZoneMeta.getAvailableIDs(systemTimeZoneType, string, n2);
    }

    public static String[] getAvailableIDs(int n2) {
        Set<String> set = TimeZone.getAvailableIDs(SystemTimeZoneType.ANY, null, n2);
        return set.toArray(new String[0]);
    }

    public static String[] getAvailableIDs(String string) {
        Set<String> set = TimeZone.getAvailableIDs(SystemTimeZoneType.ANY, string, null);
        return set.toArray(new String[0]);
    }

    public static String[] getAvailableIDs() {
        Set<String> set = TimeZone.getAvailableIDs(SystemTimeZoneType.ANY, null, null);
        return set.toArray(new String[0]);
    }

    public static int countEquivalentIDs(String string) {
        return ZoneMeta.countEquivalentIDs(string);
    }

    public static String getEquivalentID(String string, int n2) {
        return ZoneMeta.getEquivalentID(string, n2);
    }

    @Deprecated
    public static TimeZone forULocaleOrDefault(ULocale uLocale) {
        String string = uLocale.getKeywordValue("timezone");
        return string == null ? TimeZone.getDefault() : TimeZone.getTimeZone(string);
    }

    @Deprecated
    public static TimeZone forLocaleOrDefault(Locale locale) {
        return TimeZone.forULocaleOrDefault(ULocale.forLocale(locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimeZone getDefault() {
        TimeZone timeZone = defaultZone;
        if (timeZone != null) return timeZone.cloneAsThawed();
        Class<java.util.TimeZone> clazz = java.util.TimeZone.class;
        synchronized (java.util.TimeZone.class) {
            Class<TimeZone> clazz2 = TimeZone.class;
            synchronized (TimeZone.class) {
                timeZone = defaultZone;
                if (timeZone != null) return timeZone.cloneAsThawed();
                if (TZ_IMPL == 1) {
                    timeZone = new JavaTimeZone();
                } else {
                    java.util.TimeZone timeZone2 = java.util.TimeZone.getDefault();
                    timeZone = TimeZone.getFrozenTimeZone(timeZone2.getID());
                }
                defaultZone = timeZone;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return timeZone.cloneAsThawed();
            }
        }
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        TimeZone.setICUDefault(timeZone);
        if (timeZone != null) {
            String string;
            java.util.TimeZone timeZone2 = null;
            if (timeZone instanceof JavaTimeZone) {
                timeZone2 = ((JavaTimeZone)timeZone).unwrap();
            } else if (timeZone instanceof OlsonTimeZone && !(string = timeZone.getID()).equals((timeZone2 = java.util.TimeZone.getTimeZone(string)).getID()) && !(string = TimeZone.getCanonicalID(string)).equals((timeZone2 = java.util.TimeZone.getTimeZone(string)).getID())) {
                timeZone2 = null;
            }
            if (timeZone2 == null) {
                timeZone2 = TimeZoneAdapter.wrap(timeZone);
            }
            java.util.TimeZone.setDefault(timeZone2);
        }
    }

    @Deprecated
    public static synchronized void setICUDefault(TimeZone timeZone) {
        defaultZone = timeZone == null ? null : (timeZone.isFrozen() ? timeZone : ((TimeZone)timeZone.clone()).freeze());
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone != null && this.getRawOffset() == timeZone.getRawOffset() && this.useDaylightTime() == timeZone.useDaylightTime();
    }

    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.ID.equals(((TimeZone)object).ID);
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public static String getTZDataVersion() {
        return VersionInfo.getTZDataVersion();
    }

    public static String getCanonicalID(String string) {
        return TimeZone.getCanonicalID(string, null);
    }

    public static String getCanonicalID(String string, boolean[] blArray) {
        String string2 = null;
        boolean bl2 = false;
        if (string != null && string.length() != 0) {
            if (string.equals(UNKNOWN_ZONE_ID)) {
                string2 = UNKNOWN_ZONE_ID;
                bl2 = false;
            } else {
                string2 = ZoneMeta.getCanonicalCLDRID(string);
                if (string2 != null) {
                    bl2 = true;
                } else {
                    string2 = ZoneMeta.getCustomID(string);
                }
            }
        }
        if (blArray != null) {
            blArray[0] = bl2;
        }
        return string2;
    }

    public static String getIanaID(String string) {
        String string2 = UNKNOWN_ZONE_ID;
        if (string == null || string.length() == 0 || string.equals(UNKNOWN_ZONE)) {
            return string2;
        }
        String string3 = ZoneMeta.getIanaID(string);
        if (string3 != null) {
            string2 = string3;
        }
        return string2;
    }

    public static String getRegion(String string) {
        String string2 = null;
        if (!string.equals(UNKNOWN_ZONE_ID)) {
            string2 = ZoneMeta.getRegion(string);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Unknown system zone id: " + string);
        }
        return string2;
    }

    public static String getWindowsID(String string) {
        boolean[] blArray = new boolean[]{false};
        string = TimeZone.getCanonicalID(string, blArray);
        if (!blArray[0]) {
            return null;
        }
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "windowsZones", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle uResourceBundle2 = uResourceBundle.get("mapTimezones");
        UResourceBundleIterator uResourceBundleIterator = uResourceBundle2.getIterator();
        while (uResourceBundleIterator.hasNext()) {
            UResourceBundle uResourceBundle3 = uResourceBundleIterator.next();
            if (uResourceBundle3.getType() != 2) continue;
            UResourceBundleIterator uResourceBundleIterator2 = uResourceBundle3.getIterator();
            while (uResourceBundleIterator2.hasNext()) {
                String[] stringArray;
                UResourceBundle uResourceBundle4 = uResourceBundleIterator2.next();
                if (uResourceBundle4.getType() != 0) continue;
                for (String string2 : stringArray = uResourceBundle4.getString().split(" ")) {
                    if (!string2.equals(string)) continue;
                    return uResourceBundle3.getKey();
                }
            }
        }
        return null;
    }

    public static String getIDForWindowsID(String string, String string2) {
        String string3 = null;
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "windowsZones", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle uResourceBundle2 = uResourceBundle.get("mapTimezones");
        try {
            UResourceBundle uResourceBundle3 = uResourceBundle2.get(string);
            if (string2 != null) {
                try {
                    int n2;
                    string3 = uResourceBundle3.getString(string2);
                    if (string3 != null && (n2 = string3.indexOf(32)) > 0) {
                        string3 = string3.substring(0, n2);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (string3 == null) {
                string3 = uResourceBundle3.getString("001");
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string3;
    }

    @Override
    public boolean isFrozen() {
        return false;
    }

    @Override
    public TimeZone freeze() {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    @Override
    public TimeZone cloneAsThawed() {
        try {
            TimeZone timeZone = (TimeZone)super.clone();
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
    }

    static {
        String string = ICUConfig.get(TZIMPL_CONFIG_KEY, TZIMPL_CONFIG_ICU);
        if (string.equalsIgnoreCase(TZIMPL_CONFIG_JDK)) {
            TZ_IMPL = 1;
        }
    }

    private static final class ConstantZone
    extends TimeZone {
        private static final long serialVersionUID = 1L;
        private int rawOffset;
        private volatile transient boolean isFrozen = false;

        private ConstantZone(int n2, String string) {
            super(string);
            this.rawOffset = n2;
        }

        @Override
        public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
            return this.rawOffset;
        }

        @Override
        public void setRawOffset(int n2) {
            if (this.isFrozen()) {
                throw new UnsupportedOperationException("Attempt to modify a frozen TimeZone instance.");
            }
            this.rawOffset = n2;
        }

        @Override
        public int getRawOffset() {
            return this.rawOffset;
        }

        @Override
        public boolean useDaylightTime() {
            return false;
        }

        @Override
        public boolean inDaylightTime(Date date) {
            return false;
        }

        @Override
        public boolean isFrozen() {
            return this.isFrozen;
        }

        @Override
        public TimeZone freeze() {
            this.isFrozen = true;
            return this;
        }

        @Override
        public TimeZone cloneAsThawed() {
            ConstantZone constantZone = (ConstantZone)super.cloneAsThawed();
            constantZone.isFrozen = false;
            return constantZone;
        }
    }

    public static enum SystemTimeZoneType {
        ANY,
        CANONICAL,
        CANONICAL_LOCATION;

    }
}

