/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class LocalePriorityList
implements Iterable<ULocale> {
    private static final Double D1 = 1.0;
    private static final Pattern languageSplitter = Pattern.compile("\\s*,\\s*");
    private static final Pattern weightSplitter = Pattern.compile("\\s*(\\S*)\\s*;\\s*q\\s*=\\s*(\\S*)");
    private final Map<ULocale, Double> languagesAndWeights;
    private static Comparator<Double> myDescendingDouble = new Comparator<Double>(){

        @Override
        public int compare(Double d2, Double d3) {
            int n2 = d2.compareTo(d3);
            return n2 > 0 ? -1 : (n2 < 0 ? 1 : 0);
        }
    };

    public static Builder add(ULocale ... uLocaleArray) {
        return new Builder().add(uLocaleArray);
    }

    public static Builder add(ULocale uLocale, double d2) {
        return new Builder().add(uLocale, d2);
    }

    public static Builder add(LocalePriorityList localePriorityList) {
        return new Builder(localePriorityList);
    }

    public static Builder add(String string) {
        return new Builder().add(string);
    }

    public Double getWeight(ULocale uLocale) {
        return this.languagesAndWeights.get(uLocale);
    }

    public Set<ULocale> getULocales() {
        return this.languagesAndWeights.keySet();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<ULocale, Double> entry : this.languagesAndWeights.entrySet()) {
            ULocale uLocale = entry.getKey();
            double d2 = entry.getValue();
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(uLocale);
            if (d2 == 1.0) continue;
            stringBuilder.append(";q=").append(d2);
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<ULocale> iterator() {
        return this.languagesAndWeights.keySet().iterator();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            LocalePriorityList localePriorityList = (LocalePriorityList)object;
            return this.languagesAndWeights.equals(localePriorityList.languagesAndWeights);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public int hashCode() {
        return this.languagesAndWeights.hashCode();
    }

    private LocalePriorityList(Map<ULocale, Double> map) {
        this.languagesAndWeights = map;
    }

    public static class Builder {
        private Map<ULocale, Double> languageToWeight;
        private LocalePriorityList built;
        private boolean hasWeights = false;

        private Builder() {
            this.languageToWeight = new LinkedHashMap<ULocale, Double>();
        }

        private Builder(LocalePriorityList localePriorityList) {
            this.built = localePriorityList;
            for (Double d2 : localePriorityList.languagesAndWeights.values()) {
                double d3 = d2;
                assert (0.0 < d3 && d3 <= 1.0);
                if (d3 == 1.0) continue;
                this.hasWeights = true;
                break;
            }
        }

        public LocalePriorityList build() {
            return this.build(false);
        }

        public LocalePriorityList build(boolean bl2) {
            Map<ULocale, Double> map;
            if (this.built != null) {
                return this.built;
            }
            if (this.hasWeights) {
                Comparable<ULocale> comparable;
                TreeMap<Double, LinkedList<ULocale>> treeMap = new TreeMap<Double, LinkedList<ULocale>>(myDescendingDouble);
                for (Map.Entry<ULocale, Double> entry : this.languageToWeight.entrySet()) {
                    comparable = entry.getKey();
                    Double d2 = entry.getValue();
                    Serializable serializable = (LinkedList<ULocale>)treeMap.get(d2);
                    if (serializable == null) {
                        serializable = new LinkedList<ULocale>();
                        treeMap.put(d2, (LinkedList<ULocale>)serializable);
                    }
                    serializable.add(comparable);
                }
                if (treeMap.size() <= 1) {
                    map = this.languageToWeight;
                    if (treeMap.isEmpty() || (Double)treeMap.firstKey() == 1.0) {
                        this.hasWeights = false;
                    }
                } else {
                    map = new LinkedHashMap<ULocale, Double>();
                    for (Map.Entry<ULocale, Double> entry : treeMap.entrySet()) {
                        comparable = bl2 ? (Double)((Object)entry.getKey()) : D1;
                        for (Serializable serializable : (List)((Object)entry.getValue())) {
                            map.put((ULocale)serializable, (Double)comparable);
                        }
                    }
                }
            } else {
                map = this.languageToWeight;
            }
            this.languageToWeight = null;
            this.built = new LocalePriorityList(Collections.unmodifiableMap(map));
            return this.built;
        }

        public Builder add(LocalePriorityList localePriorityList) {
            for (Map.Entry entry : localePriorityList.languagesAndWeights.entrySet()) {
                this.add((ULocale)entry.getKey(), (Double)entry.getValue());
            }
            return this;
        }

        public Builder add(ULocale uLocale) {
            return this.add(uLocale, 1.0);
        }

        public Builder add(ULocale ... uLocaleArray) {
            for (ULocale uLocale : uLocaleArray) {
                this.add(uLocale, 1.0);
            }
            return this;
        }

        public Builder add(ULocale uLocale, double d2) {
            Double d3;
            if (this.languageToWeight == null) {
                this.languageToWeight = new LinkedHashMap<ULocale, Double>(this.built.languagesAndWeights);
                this.built = null;
            }
            if (this.languageToWeight.containsKey(uLocale)) {
                this.languageToWeight.remove(uLocale);
            }
            if (d2 <= 0.0) {
                return this;
            }
            if (d2 >= 1.0) {
                d3 = D1;
            } else {
                d3 = d2;
                this.hasWeights = true;
            }
            this.languageToWeight.put(uLocale, d3);
            return this;
        }

        public Builder add(String string) {
            String[] stringArray = languageSplitter.split(string.trim());
            Matcher matcher = weightSplitter.matcher("");
            for (String string2 : stringArray) {
                if (matcher.reset(string2).matches()) {
                    ULocale uLocale = new ULocale(matcher.group(1));
                    double d2 = Double.parseDouble(matcher.group(2));
                    if (!(0.0 <= d2) || !(d2 <= 1.0)) {
                        throw new IllegalArgumentException("Illegal weight, must be 0..1: " + d2);
                    }
                    this.add(uLocale, d2);
                    continue;
                }
                if (string2.length() == 0) continue;
                this.add(new ULocale(string2));
            }
            return this;
        }
    }
}

