/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalType;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.EraRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.GregorianCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class JapaneseCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -2977189902603704691L;
    private static final int GREGORIAN_EPOCH = 1970;
    private static final EraRules ERA_RULES = EraRules.getInstance(CalType.JAPANESE, JapaneseCalendar.enableTentativeEra());
    public static final int CURRENT_ERA;
    public static final int MEIJI;
    public static final int TAISHO;
    public static final int SHOWA;
    public static final int HEISEI;
    public static final int REIWA;

    public JapaneseCalendar() {
    }

    public JapaneseCalendar(TimeZone timeZone) {
        super(timeZone);
    }

    public JapaneseCalendar(Locale locale) {
        super(locale);
    }

    public JapaneseCalendar(ULocale uLocale) {
        super(uLocale);
    }

    public JapaneseCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
    }

    public JapaneseCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
    }

    public JapaneseCalendar(Date date) {
        this();
        this.setTime(date);
    }

    public JapaneseCalendar(int n2, int n3, int n4, int n5) {
        super(n3, n4, n5);
        this.set(0, n2);
    }

    public JapaneseCalendar(int n2, int n3, int n4) {
        super(n2, n3, n4);
        this.set(0, CURRENT_ERA);
    }

    public JapaneseCalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n2, n3, n4, n5, n6, n7);
        this.set(0, CURRENT_ERA);
    }

    @Deprecated
    public static boolean enableTentativeEra() {
        String string;
        boolean bl2 = false;
        String string2 = "ICU_ENABLE_TENTATIVE_ERA";
        String string3 = System.getProperty("ICU_ENABLE_TENTATIVE_ERA");
        if (string3 == null) {
            string3 = System.getenv("ICU_ENABLE_TENTATIVE_ERA");
        }
        bl2 = string3 != null ? string3.equalsIgnoreCase("true") : (string = System.getProperty("jdk.calendar.japanese.supplemental.era")) != null;
        return bl2;
    }

    @Override
    protected int handleGetExtendedYear() {
        int n2 = this.newerField(19, 1) == 19 && this.newerField(19, 0) == 19 ? this.internalGet(19, 1970) : this.internalGet(1, 1) + ERA_RULES.getStartYear(this.internalGet(0, CURRENT_ERA)) - 1;
        return n2;
    }

    @Override
    protected int getDefaultMonthInYear(int n2) {
        int n3 = this.internalGet(0, CURRENT_ERA);
        int[] nArray = ERA_RULES.getStartDate(n3, null);
        if (n2 == nArray[0]) {
            return nArray[1] - 1;
        }
        return super.getDefaultMonthInYear(n2);
    }

    @Override
    protected int getDefaultDayInMonth(int n2, int n3) {
        int n4 = this.internalGet(0, CURRENT_ERA);
        int[] nArray = ERA_RULES.getStartDate(n4, null);
        if (n2 == nArray[0] && n3 == nArray[1] - 1) {
            return nArray[2];
        }
        return super.getDefaultDayInMonth(n2, n3);
    }

    @Override
    protected void handleComputeFields(int n2) {
        super.handleComputeFields(n2);
        int n3 = this.internalGet(19);
        int n4 = ERA_RULES.getEraIndex(n3, this.internalGet(2) + 1, this.internalGet(5));
        this.internalSet(0, n4);
        this.internalSet(1, n3 - ERA_RULES.getStartYear(n4) + 1);
    }

    @Override
    protected int handleGetLimit(int n2, int n3) {
        switch (n2) {
            case 0: {
                if (n3 == 0 || n3 == 1) {
                    return 0;
                }
                return ERA_RULES.getNumberOfEras() - 1;
            }
            case 1: {
                switch (n3) {
                    case 0: 
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return super.handleGetLimit(n2, 3) - ERA_RULES.getStartYear(CURRENT_ERA);
                    }
                }
            }
        }
        return super.handleGetLimit(n2, n3);
    }

    @Override
    public String getType() {
        return "japanese";
    }

    @Override
    @Deprecated
    public boolean haveDefaultCentury() {
        return false;
    }

    @Override
    public int getActualMaximum(int n2) {
        if (n2 == 1) {
            int n3 = this.get(0);
            if (n3 == ERA_RULES.getNumberOfEras() - 1) {
                return this.handleGetLimit(1, 3);
            }
            int[] nArray = ERA_RULES.getStartDate(n3 + 1, null);
            int n4 = nArray[0];
            int n5 = nArray[1];
            int n6 = nArray[2];
            int n7 = n4 - ERA_RULES.getStartYear(n3) + 1;
            if (n5 == 1 && n6 == 1) {
                --n7;
            }
            return n7;
        }
        return super.getActualMaximum(n2);
    }

    @Override
    @Deprecated
    protected boolean isEra0CountingBackward() {
        return false;
    }

    static {
        MEIJI = 232;
        TAISHO = 233;
        SHOWA = 234;
        HEISEI = 235;
        REIWA = 236;
        CURRENT_ERA = ERA_RULES.getCurrentEraIndex();
    }
}

