/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class CodePointMap
implements Iterable<Range> {
    protected CodePointMap() {
    }

    public abstract int get(int var1);

    public abstract boolean getRange(int var1, ValueFilter var2, Range var3);

    public boolean getRange(int n2, RangeOption rangeOption, int n3, ValueFilter valueFilter, Range range) {
        assert (rangeOption != null);
        if (!this.getRange(n2, valueFilter, range)) {
            return false;
        }
        if (rangeOption == RangeOption.NORMAL) {
            return true;
        }
        int n4 = rangeOption == RangeOption.FIXED_ALL_SURROGATES ? 57343 : 56319;
        int n5 = range.end;
        if (n5 < 55295 || n2 > n4) {
            return true;
        }
        if (range.value == n3) {
            if (n5 >= n4) {
                return true;
            }
        } else {
            if (n2 <= 55295) {
                range.end = 55295;
                return true;
            }
            range.value = n3;
            if (n5 > n4) {
                range.end = n4;
                return true;
            }
        }
        if (this.getRange(n4 + 1, valueFilter, range) && range.value == n3) {
            range.start = n2;
            return true;
        }
        range.start = n2;
        range.end = n4;
        range.value = n3;
        return true;
    }

    @Override
    public Iterator<Range> iterator() {
        return new RangeIterator();
    }

    public StringIterator stringIterator(CharSequence charSequence, int n2) {
        return new StringIterator(charSequence, n2);
    }

    public class StringIterator {
        @Deprecated
        protected CharSequence s;
        @Deprecated
        protected int sIndex;
        @Deprecated
        protected int c;
        @Deprecated
        protected int value;

        @Deprecated
        protected StringIterator(CharSequence charSequence, int n2) {
            this.s = charSequence;
            this.sIndex = n2;
            this.c = -1;
            this.value = 0;
        }

        public void reset(CharSequence charSequence, int n2) {
            this.s = charSequence;
            this.sIndex = n2;
            this.c = -1;
            this.value = 0;
        }

        public boolean next() {
            if (this.sIndex >= this.s.length()) {
                return false;
            }
            this.c = Character.codePointAt(this.s, this.sIndex);
            this.sIndex += Character.charCount(this.c);
            this.value = CodePointMap.this.get(this.c);
            return true;
        }

        public boolean previous() {
            if (this.sIndex <= 0) {
                return false;
            }
            this.c = Character.codePointBefore(this.s, this.sIndex);
            this.sIndex -= Character.charCount(this.c);
            this.value = CodePointMap.this.get(this.c);
            return true;
        }

        public final int getIndex() {
            return this.sIndex;
        }

        public final int getCodePoint() {
            return this.c;
        }

        public final int getValue() {
            return this.value;
        }
    }

    private final class RangeIterator
    implements Iterator<Range> {
        private Range range = new Range();

        private RangeIterator() {
        }

        @Override
        public boolean hasNext() {
            return -1 <= this.range.end && this.range.end < 0x10FFFF;
        }

        @Override
        public Range next() {
            if (CodePointMap.this.getRange(this.range.end + 1, null, this.range)) {
                return this.range;
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Range {
        private int start = -1;
        private int end = -1;
        private int value = 0;

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getValue() {
            return this.value;
        }

        public void set(int n2, int n3, int n4) {
            this.start = n2;
            this.end = n3;
            this.value = n4;
        }
    }

    public static interface ValueFilter {
        public int apply(int var1);
    }

    public static enum RangeOption {
        NORMAL,
        FIXED_LEAD_SURROGATES,
        FIXED_ALL_SURROGATES;

    }
}

