/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalendarAstronomer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalendarCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.SimpleTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class ChineseCalendar
extends Calendar {
    private static final long serialVersionUID = 7312110751940929420L;
    private int epochYear;
    private TimeZone zoneAstro;
    private transient CalendarCache winterSolsticeCache = new CalendarCache();
    private transient CalendarCache newYearCache = new CalendarCache();
    private transient boolean hasLeapMonthBetweenWinterSolstices;
    private static final int[][] LIMITS = new int[][]{{1, 1, 83333, 83333}, {1, 1, 60, 60}, {0, 0, 11, 11}, {1, 1, 50, 55}, new int[0], {1, 1, 29, 30}, {1, 1, 353, 385}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0], {0, 0, 1, 1}, {0, 0, 11, 12}};
    static final int[][][] CHINESE_DATE_PRECEDENCE = new int[][][]{new int[][]{{5}, {3, 7}, {4, 7}, {8, 7}, {3, 18}, {4, 18}, {8, 18}, {6}, {37, 22}}, new int[][]{{3}, {4}, {8}, {40, 7}, {40, 18}}};
    private static final int CHINESE_EPOCH_YEAR = -2636;
    private static final TimeZone CHINA_ZONE = new SimpleTimeZone(28800000, "CHINA_ZONE").freeze();
    private static final int SYNODIC_GAP = 25;
    private static String[] gTemporalLeapMonthCodes = new String[]{"M01L", "M02L", "M03L", "M04L", "M05L", "M06L", "M07L", "M08L", "M09L", "M10L", "M11L", "M12L"};

    public ChineseCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
    }

    public ChineseCalendar(Date date) {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
        this.setTime(date);
    }

    public ChineseCalendar(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 0, 0, 0);
    }

    public ChineseCalendar(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
        this.set(14, 0);
        this.set(1, n2);
        this.set(2, n3);
        this.set(22, n4);
        this.set(5, n5);
        this.set(11, n6);
        this.set(12, n7);
        this.set(13, n8);
    }

    public ChineseCalendar(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, n5, n6, 0, 0, 0);
    }

    public ChineseCalendar(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
        this.set(14, 0);
        this.set(0, n2);
        this.set(1, n3);
        this.set(2, n4);
        this.set(22, n5);
        this.set(5, n6);
        this.set(11, n7);
        this.set(12, n8);
        this.set(13, n9);
    }

    public ChineseCalendar(Locale locale) {
        this(TimeZone.forLocaleOrDefault(locale), ULocale.forLocale(locale), -2636, CHINA_ZONE);
    }

    public ChineseCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
    }

    public ChineseCalendar(TimeZone timeZone, Locale locale) {
        this(timeZone, ULocale.forLocale(locale), -2636, CHINA_ZONE);
    }

    public ChineseCalendar(ULocale uLocale) {
        this(TimeZone.forULocaleOrDefault(uLocale), uLocale, -2636, CHINA_ZONE);
    }

    public ChineseCalendar(TimeZone timeZone, ULocale uLocale) {
        this(timeZone, uLocale, -2636, CHINA_ZONE);
    }

    @Deprecated
    protected ChineseCalendar(TimeZone timeZone, ULocale uLocale, int n2, TimeZone timeZone2) {
        super(timeZone, uLocale);
        this.epochYear = n2;
        this.zoneAstro = timeZone2;
        this.setTimeInMillis(System.currentTimeMillis());
    }

    @Override
    protected int handleGetLimit(int n2, int n3) {
        return LIMITS[n2][n3];
    }

    @Override
    protected int handleGetExtendedYear() {
        int n2;
        if (this.newestStamp(0, 1, 0) <= this.getStamp(19)) {
            n2 = this.internalGet(19, 1);
        } else {
            int n3 = this.internalGet(0, 1) - 1;
            n2 = n3 * 60 + this.internalGet(1, 1) - (this.epochYear - -2636);
        }
        return n2;
    }

    @Override
    protected int handleGetMonthLength(int n2, int n3) {
        int n4 = this.handleComputeMonthStart(n2, n3, true) - 2440588 + 1;
        int n5 = this.newMoonNear(n4 + 25, true);
        return n5 - n4;
    }

    @Override
    protected DateFormat handleGetDateFormat(String string, String string2, ULocale uLocale) {
        return super.handleGetDateFormat(string, string2, uLocale);
    }

    @Override
    protected int[][][] getFieldResolutionTable() {
        return CHINESE_DATE_PRECEDENCE;
    }

    private void offsetMonth(int n2, int n3, int n4) {
        n2 += (int)(29.530588853 * ((double)n4 - 0.5));
        n2 = this.newMoonNear(n2, true);
        int n5 = n2 + 2440588 - 1 + n3;
        if (n3 > 29) {
            this.set(20, n5 - 1);
            this.complete();
            if (this.getActualMaximum(5) >= n3) {
                this.set(20, n5);
            }
        } else {
            this.set(20, n5);
        }
    }

    @Override
    public void add(int n2, int n3) {
        switch (n2) {
            case 2: 
            case 23: {
                if (n3 == 0) break;
                int n4 = this.get(5);
                int n5 = this.get(20) - 2440588;
                int n6 = n5 - n4 + 1;
                this.offsetMonth(n6, n4, n3);
                break;
            }
            default: {
                super.add(n2, n3);
            }
        }
    }

    @Override
    public void roll(int n2, int n3) {
        switch (n2) {
            case 2: 
            case 23: {
                int n4;
                int n5;
                if (n3 == 0) break;
                int n6 = this.get(5);
                int n7 = this.get(20) - 2440588;
                int n8 = n7 - n6 + 1;
                int n9 = this.get(2);
                if (this.hasLeapMonthBetweenWinterSolstices) {
                    if (this.get(22) == 1) {
                        ++n9;
                    } else {
                        n5 = n8 - (int)(29.530588853 * ((double)n9 - 0.5));
                        if (this.isLeapMonthBetween(n5 = this.newMoonNear(n5, true), n8)) {
                            ++n9;
                        }
                    }
                }
                if ((n4 = (n9 + n3) % (n5 = this.hasLeapMonthBetweenWinterSolstices ? 13 : 12)) < 0) {
                    n4 += n5;
                }
                if (n4 == n9) break;
                this.offsetMonth(n8, n6, n4 - n9);
                break;
            }
            default: {
                super.roll(n2, n3);
            }
        }
    }

    private final long daysToMillis(int n2) {
        long l2 = (long)n2 * 86400000L;
        return l2 - (long)this.zoneAstro.getOffset(l2);
    }

    private final int millisToDays(long l2) {
        return (int)ChineseCalendar.floorDivide(l2 + (long)this.zoneAstro.getOffset(l2), 86400000L);
    }

    private int winterSolstice(int n2) {
        long l2 = this.winterSolsticeCache.get(n2);
        if (l2 == CalendarCache.EMPTY) {
            long l3 = this.daysToMillis(this.computeGregorianMonthStart(n2, 11) + 1 - 2440588);
            long l4 = new CalendarAstronomer(l3).getSunTime(CalendarAstronomer.WINTER_SOLSTICE, true);
            l2 = this.millisToDays(l4);
            this.winterSolsticeCache.put(n2, l2);
        }
        return (int)l2;
    }

    private int newMoonNear(int n2, boolean bl2) {
        long l2 = new CalendarAstronomer(this.daysToMillis(n2)).getMoonTime(CalendarAstronomer.NEW_MOON, bl2);
        return this.millisToDays(l2);
    }

    private int synodicMonthsBetween(int n2, int n3) {
        return (int)Math.round((double)(n3 - n2) / 29.530588853);
    }

    private int majorSolarTerm(int n2) {
        int n3 = ((int)Math.floor(6.0 * new CalendarAstronomer(this.daysToMillis(n2)).getSunLongitude() / Math.PI) + 2) % 12;
        if (n3 < 1) {
            n3 += 12;
        }
        return n3;
    }

    private boolean hasNoMajorSolarTerm(int n2) {
        int n3;
        int n4;
        int n5 = this.majorSolarTerm(n2);
        return n5 == (n4 = this.majorSolarTerm(n3 = this.newMoonNear(n2 + 25, true)));
    }

    private boolean isLeapMonthBetween(int n2, int n3) {
        if (this.synodicMonthsBetween(n2, n3) >= 50) {
            throw new IllegalArgumentException("isLeapMonthBetween(" + n2 + ", " + n3 + "): Invalid parameters");
        }
        return n3 >= n2 && (this.isLeapMonthBetween(n2, this.newMoonNear(n3 - 25, false)) || this.hasNoMajorSolarTerm(n3));
    }

    @Override
    protected void handleComputeFields(int n2) {
        this.computeChineseFields(n2 - 2440588, this.getGregorianYear(), this.getGregorianMonth(), true);
    }

    private void computeChineseFields(int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6;
        int n7 = this.winterSolstice(n3);
        if (n2 < n7) {
            n6 = this.winterSolstice(n3 - 1);
        } else {
            n6 = n7;
            n7 = this.winterSolstice(n3 + 1);
        }
        int n8 = this.newMoonNear(n6 + 1, true);
        int n9 = this.newMoonNear(n7 + 1, false);
        int n10 = this.newMoonNear(n2 + 1, false);
        this.hasLeapMonthBetweenWinterSolstices = this.synodicMonthsBetween(n8, n9) == 12;
        int n11 = this.synodicMonthsBetween(n8, n10);
        int n12 = this.newYear(n3);
        if (n2 < n12) {
            n12 = this.newYear(n3 - 1);
        }
        if (this.hasLeapMonthBetweenWinterSolstices && this.isLeapMonthBetween(n8, n10)) {
            --n11;
        }
        if (n11 < 1) {
            n11 += 12;
        }
        if ((n5 = this.synodicMonthsBetween(n12, n10)) < 0) {
            n5 += 12;
        }
        boolean bl3 = this.hasLeapMonthBetweenWinterSolstices && this.hasNoMajorSolarTerm(n10) && !this.isLeapMonthBetween(n8, this.newMoonNear(n10 - 25, false));
        this.internalSet(2, n11 - 1);
        this.internalSet(23, n5);
        this.internalSet(22, bl3 ? 1 : 0);
        if (bl2) {
            int n13 = n3 - this.epochYear;
            int n14 = n3 - -2636;
            if (n11 < 11 || n4 >= 6) {
                ++n13;
                ++n14;
            }
            int n15 = n2 - n10 + 1;
            this.internalSet(19, n13);
            int[] nArray = new int[1];
            int n16 = ChineseCalendar.floorDivide(n14 - 1, 60, nArray);
            this.internalSet(0, n16 + 1);
            this.internalSet(1, nArray[0] + 1);
            this.internalSet(5, n15);
            int n17 = this.newYear(n3);
            if (n2 < n17) {
                n17 = this.newYear(n3 - 1);
            }
            this.internalSet(6, n2 - n17 + 1);
        }
    }

    private int newYear(int n2) {
        long l2 = this.newYearCache.get(n2);
        if (l2 == CalendarCache.EMPTY) {
            int n3 = this.winterSolstice(n2 - 1);
            int n4 = this.winterSolstice(n2);
            int n5 = this.newMoonNear(n3 + 1, true);
            int n6 = this.newMoonNear(n5 + 25, true);
            int n7 = this.newMoonNear(n4 + 1, false);
            l2 = this.synodicMonthsBetween(n5, n7) == 12 && (this.hasNoMajorSolarTerm(n5) || this.hasNoMajorSolarTerm(n6)) ? (long)this.newMoonNear(n6 + 25, true) : (long)n6;
            this.newYearCache.put(n2, l2);
        }
        return (int)l2;
    }

    @Override
    protected int handleComputeMonthStart(int n2, int n3, boolean bl2) {
        if (n3 < 0 || n3 > 11) {
            int[] nArray = new int[1];
            n2 += ChineseCalendar.floorDivide(n3, 12, nArray);
            n3 = nArray[0];
        }
        int n4 = n2 + this.epochYear - 1;
        int n5 = this.newYear(n4);
        int n6 = this.newMoonNear(n5 + n3 * 29, true);
        int n7 = n6 + 2440588;
        int n8 = this.internalGet(2);
        int n9 = this.internalGet(23);
        int n10 = this.internalGet(22);
        int n11 = bl2 ? n10 : 0;
        this.computeGregorianFields(n7);
        this.computeChineseFields(n6, this.getGregorianYear(), this.getGregorianMonth(), false);
        if (n3 != this.internalGet(2) || n11 != this.internalGet(22)) {
            n6 = this.newMoonNear(n6 + 25, true);
            n7 = n6 + 2440588;
        }
        this.internalSet(2, n8);
        this.internalSet(23, n9);
        this.internalSet(22, n10);
        return n7 - 1;
    }

    @Override
    public String getType() {
        return "chinese";
    }

    @Override
    @Deprecated
    public boolean haveDefaultCentury() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.epochYear = -2636;
        this.zoneAstro = CHINA_ZONE;
        objectInputStream.defaultReadObject();
        this.winterSolsticeCache = new CalendarCache();
        this.newYearCache = new CalendarCache();
    }

    @Override
    public boolean inTemporalLeapYear() {
        return this.getActualMaximum(6) > 360;
    }

    @Override
    public String getTemporalMonthCode() {
        int n2 = this.get(22);
        if (n2 != 0) {
            return gTemporalLeapMonthCodes[this.get(2)];
        }
        return super.getTemporalMonthCode();
    }

    @Override
    public void setTemporalMonthCode(String string) {
        if (string.length() != 4 || string.charAt(0) != 'M' || string.charAt(3) != 'L') {
            this.set(22, 0);
            super.setTemporalMonthCode(string);
            return;
        }
        for (int i2 = 0; i2 < gTemporalLeapMonthCodes.length; ++i2) {
            if (!string.equals(gTemporalLeapMonthCodes[i2])) continue;
            this.set(2, i2);
            this.set(22, 1);
            return;
        }
        throw new IllegalArgumentException("Incorrect temporal Month code: " + string);
    }

    @Override
    @Deprecated
    protected int internalGetMonth() {
        if (this.resolveFields(MONTH_PRECEDENCE) == 2) {
            return this.internalGet(2);
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.set(2, 0);
        calendar.set(22, 0);
        calendar.set(5, 1);
        calendar.roll(2, this.internalGet(23));
        this.internalSet(22, calendar.get(22));
        int n2 = calendar.get(2);
        this.internalSet(2, n2);
        return n2;
    }

    @Override
    @Deprecated
    protected int internalGetMonth(int n2) {
        if (this.resolveFields(MONTH_PRECEDENCE) == 2) {
            return this.internalGet(2, n2);
        }
        return this.internalGetMonth();
    }
}

