/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.StringTrieBuilder;

public final class BytesTrieBuilder
extends StringTrieBuilder {
    private final byte[] intBytes = new byte[5];
    private byte[] bytes;
    private int bytesLength;

    public BytesTrieBuilder add(byte[] byArray, int n2, int n3) {
        this.addImpl(new BytesAsCharSequence(byArray, n2), n3);
        return this;
    }

    public BytesTrie build(StringTrieBuilder.Option option) {
        this.buildBytes(option);
        return new BytesTrie(this.bytes, this.bytes.length - this.bytesLength);
    }

    public ByteBuffer buildByteBuffer(StringTrieBuilder.Option option) {
        this.buildBytes(option);
        return ByteBuffer.wrap(this.bytes, this.bytes.length - this.bytesLength, this.bytesLength);
    }

    private void buildBytes(StringTrieBuilder.Option option) {
        if (this.bytes == null) {
            this.bytes = new byte[1024];
        }
        this.buildImpl(option);
    }

    public BytesTrieBuilder clear() {
        this.clearImpl();
        this.bytes = null;
        this.bytesLength = 0;
        return this;
    }

    @Override
    @Deprecated
    protected boolean matchNodesCanHaveValues() {
        return false;
    }

    @Override
    @Deprecated
    protected int getMaxBranchLinearSubNodeLength() {
        return 5;
    }

    @Override
    @Deprecated
    protected int getMinLinearMatch() {
        return 16;
    }

    @Override
    @Deprecated
    protected int getMaxLinearMatchLength() {
        return 16;
    }

    private void ensureCapacity(int n2) {
        if (n2 > this.bytes.length) {
            int n3 = this.bytes.length;
            while ((n3 *= 2) <= n2) {
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.bytes, this.bytes.length - this.bytesLength, byArray, byArray.length - this.bytesLength, this.bytesLength);
            this.bytes = byArray;
        }
    }

    @Override
    @Deprecated
    protected int write(int n2) {
        int n3 = this.bytesLength + 1;
        this.ensureCapacity(n3);
        this.bytesLength = n3;
        this.bytes[this.bytes.length - this.bytesLength] = (byte)n2;
        return this.bytesLength;
    }

    @Override
    @Deprecated
    protected int write(int n2, int n3) {
        int n4 = this.bytesLength + n3;
        this.ensureCapacity(n4);
        this.bytesLength = n4;
        int n5 = this.bytes.length - this.bytesLength;
        while (n3 > 0) {
            this.bytes[n5++] = (byte)this.strings.charAt(n2++);
            --n3;
        }
        return this.bytesLength;
    }

    private int write(byte[] byArray, int n2) {
        int n3 = this.bytesLength + n2;
        this.ensureCapacity(n3);
        this.bytesLength = n3;
        System.arraycopy(byArray, 0, this.bytes, this.bytes.length - this.bytesLength, n2);
        return this.bytesLength;
    }

    @Override
    @Deprecated
    protected int writeValueAndFinal(int n2, boolean bl2) {
        if (0 <= n2 && n2 <= 64) {
            return this.write(16 + n2 << 1 | (bl2 ? 1 : 0));
        }
        int n3 = 1;
        if (n2 < 0 || n2 > 0xFFFFFF) {
            this.intBytes[0] = 127;
            this.intBytes[1] = (byte)(n2 >> 24);
            this.intBytes[2] = (byte)(n2 >> 16);
            this.intBytes[3] = (byte)(n2 >> 8);
            this.intBytes[4] = (byte)n2;
            n3 = 5;
        } else {
            if (n2 <= 6911) {
                this.intBytes[0] = (byte)(81 + (n2 >> 8));
            } else {
                if (n2 <= 0x11FFFF) {
                    this.intBytes[0] = (byte)(108 + (n2 >> 16));
                } else {
                    this.intBytes[0] = 126;
                    this.intBytes[1] = (byte)(n2 >> 16);
                    n3 = 2;
                }
                this.intBytes[n3++] = (byte)(n2 >> 8);
            }
            this.intBytes[n3++] = (byte)n2;
        }
        this.intBytes[0] = (byte)(this.intBytes[0] << 1 | (bl2 ? 1 : 0));
        return this.write(this.intBytes, n3);
    }

    @Override
    @Deprecated
    protected int writeValueAndType(boolean bl2, int n2, int n3) {
        int n4 = this.write(n3);
        if (bl2) {
            n4 = this.writeValueAndFinal(n2, false);
        }
        return n4;
    }

    @Override
    @Deprecated
    protected int writeDeltaTo(int n2) {
        int n3 = this.bytesLength - n2;
        assert (n3 >= 0);
        if (n3 <= 191) {
            return this.write(n3);
        }
        return this.write(this.intBytes, BytesTrieBuilder.internalEncodeDelta(n3, this.intBytes));
    }

    @Deprecated
    public static final int internalEncodeDelta(int n2, byte[] byArray) {
        assert (n2 >= 0);
        if (n2 <= 191) {
            byArray[0] = (byte)n2;
            return 1;
        }
        int n3 = 1;
        if (n2 <= 12287) {
            byArray[0] = (byte)(192 + (n2 >> 8));
        } else {
            if (n2 <= 917503) {
                byArray[0] = (byte)(240 + (n2 >> 16));
            } else {
                if (n2 <= 0xFFFFFF) {
                    byArray[0] = -2;
                } else {
                    byArray[0] = -1;
                    byArray[1] = (byte)(n2 >> 24);
                    n3 = 2;
                }
                byArray[n3++] = (byte)(n2 >> 16);
            }
            byArray[n3++] = (byte)(n2 >> 8);
        }
        byArray[n3++] = (byte)n2;
        return n3;
    }

    private static final class BytesAsCharSequence
    implements CharSequence {
        private byte[] s;
        private int len;

        public BytesAsCharSequence(byte[] byArray, int n2) {
            this.s = byArray;
            this.len = n2;
        }

        @Override
        public char charAt(int n2) {
            return (char)(this.s[n2] & 0xFF);
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public CharSequence subSequence(int n2, int n3) {
            return null;
        }
    }
}

