/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper> {
    public byte[] bytes;
    public int size;

    public ByteArrayWrapper() {
    }

    public ByteArrayWrapper(byte[] byArray, int n2) {
        if (byArray == null && n2 != 0 || n2 < 0 || byArray != null && n2 > byArray.length) {
            throw new IndexOutOfBoundsException("illegal size: " + n2);
        }
        this.bytes = byArray;
        this.size = n2;
    }

    public ByteArrayWrapper(ByteBuffer byteBuffer) {
        this.size = byteBuffer.limit();
        this.bytes = new byte[this.size];
        byteBuffer.get(this.bytes, 0, this.size);
    }

    public ByteArrayWrapper ensureCapacity(int n2) {
        if (this.bytes == null || this.bytes.length < n2) {
            byte[] byArray = new byte[n2];
            if (this.bytes != null) {
                ByteArrayWrapper.copyBytes(this.bytes, 0, byArray, 0, this.size);
            }
            this.bytes = byArray;
        }
        return this;
    }

    public final ByteArrayWrapper set(byte[] byArray, int n2, int n3) {
        this.size = 0;
        this.append(byArray, n2, n3);
        return this;
    }

    public final ByteArrayWrapper append(byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        this.ensureCapacity(this.size + n4);
        ByteArrayWrapper.copyBytes(byArray, n2, this.bytes, this.size, n4);
        this.size += n4;
        return this;
    }

    public final byte[] releaseBytes() {
        byte[] byArray = this.bytes;
        this.bytes = null;
        this.size = 0;
        return byArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(Utility.hex(this.bytes[i2] & 0xFF, 2));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)object;
            if (this.size != byteArrayWrapper.size) {
                return false;
            }
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.bytes[i2] == byteArrayWrapper.bytes[i2]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int n2 = this.size;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = 37 * n2 + this.bytes[i2];
        }
        return n2;
    }

    @Override
    public int compareTo(ByteArrayWrapper byteArrayWrapper) {
        if (this == byteArrayWrapper) {
            return 0;
        }
        int n2 = this.size < byteArrayWrapper.size ? this.size : byteArrayWrapper.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.bytes[i2] == byteArrayWrapper.bytes[i2]) continue;
            return (this.bytes[i2] & 0xFF) - (byteArrayWrapper.bytes[i2] & 0xFF);
        }
        return this.size - byteArrayWrapper.size;
    }

    private static final void copyBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (n4 < 64) {
            int n5 = n2;
            int n6 = n3;
            while (--n4 >= 0) {
                byArray2[n6] = byArray[n5];
                ++n5;
                ++n6;
            }
        } else {
            System.arraycopy(byArray, n2, byArray2, n3, n4);
        }
    }
}

