/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Grego;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DateTimeRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneRule;

public class AnnualTimeZoneRule
extends TimeZoneRule {
    private static final long serialVersionUID = -8870666707791230688L;
    public static final int MAX_YEAR = Integer.MAX_VALUE;
    private final DateTimeRule dateTimeRule;
    private final int startYear;
    private final int endYear;

    public AnnualTimeZoneRule(String string, int n2, int n3, DateTimeRule dateTimeRule, int n4, int n5) {
        super(string, n2, n3);
        this.dateTimeRule = dateTimeRule;
        this.startYear = n4;
        this.endYear = n5;
    }

    public DateTimeRule getRule() {
        return this.dateTimeRule;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public Date getStartInYear(int n2, int n3, int n4) {
        long l2;
        if (n2 < this.startYear || n2 > this.endYear) {
            return null;
        }
        int n5 = this.dateTimeRule.getDateRuleType();
        if (n5 == 0) {
            l2 = Grego.fieldsToDay(n2, this.dateTimeRule.getRuleMonth(), this.dateTimeRule.getRuleDayOfMonth());
        } else {
            int n6;
            int n7;
            boolean bl2 = true;
            if (n5 == 1) {
                n7 = this.dateTimeRule.getRuleWeekInMonth();
                if (n7 > 0) {
                    l2 = Grego.fieldsToDay(n2, this.dateTimeRule.getRuleMonth(), 1);
                    l2 += (long)(7 * (n7 - 1));
                } else {
                    bl2 = false;
                    l2 = Grego.fieldsToDay(n2, this.dateTimeRule.getRuleMonth(), Grego.monthLength(n2, this.dateTimeRule.getRuleMonth()));
                    l2 += (long)(7 * (n7 + 1));
                }
            } else {
                n7 = this.dateTimeRule.getRuleMonth();
                n6 = this.dateTimeRule.getRuleDayOfMonth();
                if (n5 == 3) {
                    bl2 = false;
                    if (n7 == 1 && n6 == 29 && !Grego.isLeapYear(n2)) {
                        --n6;
                    }
                }
                l2 = Grego.fieldsToDay(n2, n7, n6);
            }
            n7 = Grego.dayOfWeek(l2);
            n6 = this.dateTimeRule.getRuleDayOfWeek() - n7;
            n6 = bl2 ? (n6 < 0 ? n6 + 7 : n6) : (n6 > 0 ? n6 - 7 : n6);
            l2 += (long)n6;
        }
        long l3 = l2 * 86400000L + (long)this.dateTimeRule.getRuleMillisInDay();
        if (this.dateTimeRule.getTimeRuleType() != 2) {
            l3 -= (long)n3;
        }
        if (this.dateTimeRule.getTimeRuleType() == 0) {
            l3 -= (long)n4;
        }
        return new Date(l3);
    }

    @Override
    public Date getFirstStart(int n2, int n3) {
        return this.getStartInYear(this.startYear, n2, n3);
    }

    @Override
    public Date getFinalStart(int n2, int n3) {
        if (this.endYear == Integer.MAX_VALUE) {
            return null;
        }
        return this.getStartInYear(this.endYear, n2, n3);
    }

    @Override
    public Date getNextStart(long l2, int n2, int n3, boolean bl2) {
        int[] nArray = Grego.timeToFields(l2, null);
        int n4 = nArray[0];
        if (n4 < this.startYear) {
            return this.getFirstStart(n2, n3);
        }
        Date date = this.getStartInYear(n4, n2, n3);
        if (date != null && (date.getTime() < l2 || !bl2 && date.getTime() == l2)) {
            date = this.getStartInYear(n4 + 1, n2, n3);
        }
        return date;
    }

    @Override
    public Date getPreviousStart(long l2, int n2, int n3, boolean bl2) {
        int[] nArray = Grego.timeToFields(l2, null);
        int n4 = nArray[0];
        if (n4 > this.endYear) {
            return this.getFinalStart(n2, n3);
        }
        Date date = this.getStartInYear(n4, n2, n3);
        if (date != null && (date.getTime() > l2 || !bl2 && date.getTime() == l2)) {
            date = this.getStartInYear(n4 - 1, n2, n3);
        }
        return date;
    }

    @Override
    public boolean isEquivalentTo(TimeZoneRule timeZoneRule) {
        if (!(timeZoneRule instanceof AnnualTimeZoneRule)) {
            return false;
        }
        AnnualTimeZoneRule annualTimeZoneRule = (AnnualTimeZoneRule)timeZoneRule;
        if (this.startYear == annualTimeZoneRule.startYear && this.endYear == annualTimeZoneRule.endYear && this.dateTimeRule.equals(annualTimeZoneRule.dateTimeRule)) {
            return super.isEquivalentTo(timeZoneRule);
        }
        return false;
    }

    @Override
    public boolean isTransitionRule() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(", rule={" + this.dateTimeRule + "}");
        stringBuilder.append(", startYear=" + this.startYear);
        stringBuilder.append(", endYear=");
        if (this.endYear == Integer.MAX_VALUE) {
            stringBuilder.append("max");
        } else {
            stringBuilder.append(this.endYear);
        }
        return stringBuilder.toString();
    }
}

